/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 92\u00020\u0001:\u0003789B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\u0010J>\u0010\"\u001a\u00020\u001d26\u0010#\u001a2\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u00020\u0007H\u0016J\b\u00102\u001a\u00020\u0007H\u0016J\u0018\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0016J\b\u00106\u001a\u00020\u001dH\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "activePointerId", "scaleDetector", "Landroid/view/ScaleGestureDetector;", "gestureDetector", "Landroid/view/GestureDetector;", "scaleFactor", "", "isZoomEnabled", "", "maxZoom", "zoomDuration", "", "isZoomingInProgress", "lastTouchX", "lastTouchY", "posX", "posY", "zoomChangeListener", "Lkotlin/Function2;", "", "setZoomEnabled", "enabled", "isZoomedIn", "getZoomScale", "setOnZoomChangeListener", "listener", "Lkotlin/ParameterName;", "name", "scale", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "onInterceptTouchEvent", "onDraw", "canvas", "Landroid/graphics/Canvas;", "dispatchDraw", "canScrollVertically", "direction", "computeVerticalScrollOffset", "computeVerticalScrollRange", "fling", "velocityX", "velocityY", "clampPosition", "ScaleListener", "GestureListener", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPinchZoomRecyclerView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PinchZoomRecyclerView.kt\ncom/rajat/pdfviewer/PinchZoomRecyclerView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n1#2:296\n1#2:307\n1617#3,9:297\n1869#3:306\n1870#3:308\n1626#3:309\n*S KotlinDebug\n*F\n+ 1 PinchZoomRecyclerView.kt\ncom/rajat/pdfviewer/PinchZoomRecyclerView\n*L\n168#1:307\n168#1:297,9\n168#1:306\n168#1:308\n168#1:309\n*E\n"})
public final class PinchZoomRecyclerView
extends RecyclerView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int activePointerId;
    @NotNull
    private final ScaleGestureDetector scaleDetector;
    @NotNull
    private final GestureDetector gestureDetector;
    private float scaleFactor;
    private boolean isZoomEnabled;
    private float maxZoom;
    private long zoomDuration;
    private boolean isZoomingInProgress;
    private float lastTouchX;
    private float lastTouchY;
    private float posX;
    private float posY;
    @Nullable
    private Function2<? super Boolean, ? super Float, Unit> zoomChangeListener;
    public static final int $stable = 8;
    private static final int INVALID_POINTER_ID = -1;
    private static final float MAX_ZOOM = 3.0f;
    private static final long ZOOM_DURATION = 300L;

    @JvmOverloads
    public PinchZoomRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.activePointerId = -1;
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.scaleFactor = 1.0f;
        this.isZoomEnabled = true;
        this.maxZoom = 3.0f;
        this.zoomDuration = 300L;
        this.setWillNotDraw(false);
    }

    public /* synthetic */ PinchZoomRecyclerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setZoomEnabled(boolean enabled) {
        this.isZoomEnabled = enabled;
    }

    public final boolean isZoomedIn() {
        return this.scaleFactor > 1.0f;
    }

    public final float getZoomScale() {
        return this.scaleFactor;
    }

    public final void setOnZoomChangeListener(@NotNull Function2<? super Boolean, ? super Float, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.zoomChangeListener = listener;
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (!this.isZoomEnabled) {
            return super.onTouchEvent(ev);
        }
        this.gestureDetector.onTouchEvent(ev);
        this.scaleDetector.onTouchEvent(ev);
        if (this.isZoomingInProgress) {
            return true;
        }
        boolean superHandled = super.onTouchEvent(ev);
        switch (ev.getActionMasked()) {
            case 0: {
                this.lastTouchX = ev.getX();
                this.lastTouchY = ev.getY();
                this.activePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex;
                if (this.scaleDetector.isInProgress() || !(this.scaleFactor > 1.0f) || (pointerIndex = ev.findPointerIndex(this.activePointerId)) == -1) break;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                float dx = x - this.lastTouchX;
                float dy = y - this.lastTouchY;
                this.posX += dx;
                this.posY += dy;
                this.clampPosition();
                this.invalidate();
                this.lastTouchX = x;
                this.lastTouchY = y;
                break;
            }
            case 6: {
                int pointerIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId != this.activePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.lastTouchX = ev.getX(newPointerIndex);
                this.lastTouchY = ev.getY(newPointerIndex);
                this.activePointerId = ev.getPointerId(newPointerIndex);
                break;
            }
            case 3: {
                this.activePointerId = -1;
            }
        }
        return superHandled || this.scaleFactor > 1.0f;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.isZoomingInProgress ? true : super.onInterceptTouchEvent(ev);
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate(this.posX, this.posY);
        canvas.scale(this.scaleFactor, this.scaleFactor);
        super.onDraw(canvas);
        canvas.restore();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate(this.posX, this.posY);
        canvas.scale(this.scaleFactor, this.scaleFactor);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    public boolean canScrollVertically(int direction) {
        return this.scaleFactor > 1.0f && super.canScrollVertically(direction);
    }

    public int computeVerticalScrollOffset() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
        if (linearLayoutManager == null) {
            return 0;
        }
        LinearLayoutManager layoutManager2 = linearLayoutManager;
        int firstVisible = layoutManager2.findFirstVisibleItemPosition();
        View view = layoutManager2.findViewByPosition(firstVisible);
        if (view == null) {
            return 0;
        }
        View firstView = view;
        int scrolledPast = -layoutManager2.getDecoratedTop(firstView);
        Integer n = firstView.getHeight();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int itemHeight = n2 != null ? n2.intValue() : this.getHeight();
        int offset = firstVisible * itemHeight + scrolledPast;
        return (int)((float)offset * this.scaleFactor);
    }

    /*
     * WARNING - void declaration
     */
    public int computeVerticalScrollRange() {
        void $this$mapNotNullTo$iv$iv;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
        if (linearLayoutManager == null) {
            return this.getHeight();
        }
        LinearLayoutManager layoutManager2 = linearLayoutManager;
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            return this.getHeight();
        }
        int itemCount = adapter.getItemCount();
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)layoutManager2.getChildCount());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            View view = layoutManager2.getChildAt(it);
            if ((view != null ? Integer.valueOf(view.getHeight()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List visibleHeights = (List)destination$iv$iv;
        Double d = CollectionsKt.averageOfInt((Iterable)visibleHeights);
        double it = ((Number)d).doubleValue();
        boolean bl = false;
        Double d2 = it > 0.0 ? d : null;
        double averageHeight = d2 != null ? d2 : (double)this.getHeight();
        return (int)(averageHeight * (double)itemCount * (double)this.scaleFactor);
    }

    public boolean fling(int velocityX, int velocityY) {
        return this.scaleFactor > 1.0f ? super.fling(0, velocityY) : super.fling(velocityX, velocityY);
    }

    private final void clampPosition() {
        float contentWidth = (float)this.getWidth() * this.scaleFactor;
        float contentHeight = (float)this.getHeight() * this.scaleFactor;
        float maxPosX = contentWidth > (float)this.getWidth() ? contentWidth - (float)this.getWidth() : 0.0f;
        float maxPosY = contentHeight > (float)this.getHeight() ? contentHeight - (float)this.getHeight() : 0.0f;
        this.posX = RangesKt.coerceIn((float)this.posX, (float)(-maxPosX), (float)maxPosX);
        this.posY = RangesKt.coerceIn((float)this.posY, (float)(-maxPosY), (float)maxPosY);
    }

    @JvmOverloads
    public PinchZoomRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PinchZoomRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$Companion;", "", "<init>", "()V", "INVALID_POINTER_ID", "", "MAX_ZOOM", "", "ZOOM_DURATION", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "<init>", "(Lcom/rajat/pdfviewer/PinchZoomRecyclerView;)V", "onDoubleTap", "", "e", "Landroid/view/MotionEvent;", "zoomTo", "", "targetScale", "", "focusX", "focusY", "duration", "", "pdfViewer_release"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDoubleTap(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!PinchZoomRecyclerView.this.isZoomEnabled) {
                return false;
            }
            float targetScale = PinchZoomRecyclerView.this.scaleFactor < 1.5f ? 1.5f : (PinchZoomRecyclerView.this.scaleFactor < PinchZoomRecyclerView.this.maxZoom ? PinchZoomRecyclerView.this.maxZoom : 1.0f);
            this.zoomTo(targetScale, e.getX(), e.getY(), PinchZoomRecyclerView.this.zoomDuration);
            return true;
        }

        private final void zoomTo(float targetScale, float focusX, float focusY, long duration) {
            float startScale = PinchZoomRecyclerView.this.scaleFactor;
            float focusXInContent = (focusX - PinchZoomRecyclerView.this.posX) / PinchZoomRecyclerView.this.scaleFactor;
            float focusYInContent = (focusY - PinchZoomRecyclerView.this.posY) / PinchZoomRecyclerView.this.scaleFactor;
            Object object = new float[]{0.0f, 1.0f};
            object = ValueAnimator.ofFloat((float[])object);
            PinchZoomRecyclerView pinchZoomRecyclerView = PinchZoomRecyclerView.this;
            Object $this$zoomTo_u24lambda_u241 = object;
            boolean bl = false;
            $this$zoomTo_u24lambda_u241.setDuration(duration);
            $this$zoomTo_u24lambda_u241.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            $this$zoomTo_u24lambda_u241.addUpdateListener(arg_0 -> GestureListener.zoomTo$lambda$1$lambda$0(startScale, targetScale, pinchZoomRecyclerView, focusX, focusXInContent, focusY, focusYInContent, arg_0));
            $this$zoomTo_u24lambda_u241.start();
        }

        private static final void zoomTo$lambda$1$lambda$0(float $startScale, float $targetScale, PinchZoomRecyclerView this$0, float $focusX, float $focusXInContent, float $focusY, float $focusYInContent, ValueAnimator animator) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                Object object = animator.getAnimatedValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                float fraction = ((Float)object).floatValue();
                float scale = $startScale + ($targetScale - $startScale) * fraction;
                this$0.scaleFactor = scale;
                this$0.posX = $focusX - $focusXInContent * this$0.scaleFactor;
                this$0.posY = $focusY - $focusYInContent * this$0.scaleFactor;
                this$0.clampPosition();
                this$0.invalidate();
                this$0.awakenScrollBars();
                Function2 function2 = this$0.zoomChangeListener;
                if (function2 == null) break block0;
                function2.invoke((Object)this$0.isZoomedIn(), (Object)Float.valueOf(this$0.scaleFactor));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "<init>", "(Lcom/rajat/pdfviewer/PinchZoomRecyclerView;)V", "onScaleBegin", "", "detector", "Landroid/view/ScaleGestureDetector;", "onScale", "onScaleEnd", "", "pdfViewer_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            PinchZoomRecyclerView.this.isZoomingInProgress = true;
            PinchZoomRecyclerView.this.suppressLayout(true);
            return true;
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                float scaleFactorChange = detector.getScaleFactor();
                boolean bl = 0.98f <= scaleFactorChange ? scaleFactorChange <= 1.02f : false;
                if (bl) {
                    return true;
                }
                float newScale = RangesKt.coerceIn((float)(PinchZoomRecyclerView.this.scaleFactor * scaleFactorChange), (float)1.0f, (float)PinchZoomRecyclerView.this.maxZoom);
                if (newScale == PinchZoomRecyclerView.this.scaleFactor) break block2;
                float focusXInContent = (detector.getFocusX() - PinchZoomRecyclerView.this.posX) / PinchZoomRecyclerView.this.scaleFactor;
                float focusYInContent = (detector.getFocusY() - PinchZoomRecyclerView.this.posY) / PinchZoomRecyclerView.this.scaleFactor;
                PinchZoomRecyclerView.this.scaleFactor = newScale;
                PinchZoomRecyclerView.this.posX = detector.getFocusX() - focusXInContent * PinchZoomRecyclerView.this.scaleFactor;
                PinchZoomRecyclerView.this.posY = detector.getFocusY() - focusYInContent * PinchZoomRecyclerView.this.scaleFactor;
                PinchZoomRecyclerView.this.clampPosition();
                PinchZoomRecyclerView.this.invalidate();
                PinchZoomRecyclerView.this.awakenScrollBars();
                Function2 function2 = PinchZoomRecyclerView.this.zoomChangeListener;
                if (function2 != null) {
                    function2.invoke((Object)PinchZoomRecyclerView.this.isZoomedIn(), (Object)Float.valueOf(PinchZoomRecyclerView.this.scaleFactor));
                }
            }
            return true;
        }

        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            PinchZoomRecyclerView.this.isZoomingInProgress = false;
            PinchZoomRecyclerView.this.suppressLayout(false);
        }
    }
}

