/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleCoroutineScope;
import androidx.lifecycle.LifecycleObserver;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.HeaderData;
import com.rajat.pdfviewer.PdfDownloader;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewAdapter;
import com.rajat.pdfviewer.PinchZoomRecyclerView;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.util.CacheStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001)\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001aB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00105\u001a\u00020\u001eH\u0002J\u0006\u00106\u001a\u00020\u001eJ\b\u00107\u001a\u00020\u001eH\u0002J\u001a\u00108\u001a\u00020\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u00109\u001a\u00020\bH\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\bH\u0002J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020;0>J\b\u0010?\u001a\u00020\rH\u0007J\u0018\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010C\u001a\u00020\u001e2\u0006\u0010D\u001a\u00020EJ2\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020H2\b\b\u0002\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010O\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020HH\u0002J\u000e\u0010S\u001a\u00020\u001e2\u0006\u0010T\u001a\u00020\bJ\u0012\u0010U\u001a\u00020\u001e2\b\u0010V\u001a\u0004\u0018\u00010WH\u0014J\b\u0010X\u001a\u00020WH\u0014J\b\u0010Y\u001a\u00020\u001eH\u0002J\u0010\u0010Z\u001a\u00020\u001e2\u0006\u0010[\u001a\u00020\\H\u0002J\u000e\u0010]\u001a\u00020\u001e2\u0006\u0010^\u001a\u00020\rJ\u0010\u0010_\u001a\u00020\u001e2\u0006\u0010`\u001a\u00020\bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010+\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006b"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView;", "Landroid/widget/FrameLayout;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "disableScreenshots", "", "divider", "Landroid/graphics/drawable/Drawable;", "enableLoadingForPages", "isZoomEnabled", "pageMargin", "Landroid/graphics/Rect;", "pageNo", "Landroid/widget/TextView;", "pdfRendererCore", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pdfRendererCoreInitialised", "pdfViewAdapter", "Lcom/rajat/pdfviewer/PdfViewAdapter;", "positionToUseForState", "postInitializationAction", "Lkotlin/Function0;", "", "recyclerView", "Lcom/rajat/pdfviewer/PinchZoomRecyclerView;", "getRecyclerView", "()Lcom/rajat/pdfviewer/PinchZoomRecyclerView;", "setRecyclerView", "(Lcom/rajat/pdfviewer/PinchZoomRecyclerView;)V", "restoredScrollPosition", "runnable", "Ljava/lang/Runnable;", "scrollListener", "com/rajat/pdfviewer/PdfRendererView$scrollListener$1", "Lcom/rajat/pdfviewer/PdfRendererView$scrollListener$1;", "showDivider", "statusListener", "Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "getStatusListener", "()Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "setStatusListener", "(Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;)V", "totalPageCount", "getTotalPageCount", "()I", "applyScreenshotSecurity", "closePdfRender", "forceUpdatePageNumber", "getAttrs", "defStyle", "getBitmapByPage", "Landroid/graphics/Bitmap;", "page", "getLoadedBitmaps", "", "getZoomEnabled", "initWithFile", "file", "Ljava/io/File;", "initWithUri", "uri", "Landroid/net/Uri;", "initWithUrl", "url", "", "headers", "Lcom/rajat/pdfviewer/HeaderData;", "lifecycleCoroutineScope", "Landroidx/lifecycle/LifecycleCoroutineScope;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "initializeRenderer", "fileDescriptor", "Landroid/os/ParcelFileDescriptor;", "cacheIdentifier", "jumpToPage", "pageNumber", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "preloadCacheIntoMemory", "setTypeArray", "typedArray", "Landroid/content/res/TypedArray;", "setZoomEnabled", "zoomEnabled", "updatePageNumberDisplay", "position", "StatusCallBack", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfRendererView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfRendererView.kt\ncom/rajat/pdfviewer/PdfRendererView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n1#2:380\n1#2:391\n1603#3,9:381\n1855#3:390\n1856#3:392\n1612#3:393\n*S KotlinDebug\n*F\n+ 1 PdfRendererView.kt\ncom/rajat/pdfviewer/PdfRendererView\n*L\n328#1:391\n328#1:381,9\n328#1:390\n328#1:392\n328#1:393\n*E\n"})
public final class PdfRendererView
extends FrameLayout
implements LifecycleObserver {
    public PinchZoomRecyclerView recyclerView;
    private TextView pageNo;
    private PdfRendererCore pdfRendererCore;
    private PdfViewAdapter pdfViewAdapter;
    private boolean showDivider;
    private boolean isZoomEnabled;
    @Nullable
    private Drawable divider;
    @NotNull
    private Runnable runnable;
    private boolean enableLoadingForPages;
    private boolean pdfRendererCoreInitialised;
    @NotNull
    private Rect pageMargin;
    @Nullable
    private StatusCallBack statusListener;
    private int positionToUseForState;
    private int restoredScrollPosition;
    private boolean disableScreenshots;
    @Nullable
    private Function0<Unit> postInitializationAction;
    @NotNull
    private CacheStrategy cacheStrategy;
    @NotNull
    private final scrollListener.1 scrollListener;
    public static final int $stable = 8;

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.showDivider = true;
        this.isZoomEnabled = true;
        this.runnable = PdfRendererView::runnable$lambda$0;
        this.pageMargin = new Rect(0, 0, 0, 0);
        this.restoredScrollPosition = -1;
        this.cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
        this.getAttrs(attrs, defStyleAttr);
        this.scrollListener = new RecyclerView.OnScrollListener(this, context){
            private int lastDisplayedPage;
            private int lastScrollDirection;
            @NotNull
            private final Runnable hideRunnable;
            final /* synthetic */ PdfRendererView this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.lastDisplayedPage = -1;
                this.hideRunnable = () -> scrollListener.1.hideRunnable$lambda$0($receiver);
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                int pageToShow;
                int scrollDirection;
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrolled(recyclerView, dx, dy);
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
                int firstVisiblePosition = layoutManager2.findFirstVisibleItemPosition();
                int firstCompletelyVisiblePosition = layoutManager2.findFirstCompletelyVisibleItemPosition();
                int lastVisiblePosition = layoutManager2.findLastVisibleItemPosition();
                int lastCompletelyVisiblePosition = layoutManager2.findLastCompletelyVisibleItemPosition();
                this.lastScrollDirection = scrollDirection = dy > 0 ? 1 : (dy < 0 ? -1 : this.lastScrollDirection);
                switch (scrollDirection) {
                    case 1: {
                        int n;
                        Integer n2 = lastCompletelyVisiblePosition;
                        int it22 = ((Number)n2).intValue();
                        boolean bl = false;
                        Integer n3 = it22 != -1 ? n2 : null;
                        if (n3 != null) {
                            n = n3;
                            break;
                        }
                        Integer it22 = lastVisiblePosition;
                        int it2 = ((Number)it22).intValue();
                        boolean bl2 = false;
                        Integer n4 = it2 != -1 ? it22 : null;
                        if (n4 != null) {
                            n = n4;
                            break;
                        }
                        n = firstVisiblePosition;
                        break;
                    }
                    case -1: {
                        int n;
                        Integer n2 = firstCompletelyVisiblePosition;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        Integer n5 = it != -1 ? n2 : null;
                        if (n5 != null) {
                            n = n5;
                            break;
                        }
                        Integer n6 = firstVisiblePosition;
                        int it2 = ((Number)n6).intValue();
                        boolean bl3 = false;
                        Integer n7 = it2 != -1 ? n6 : null;
                        if (n7 != null) {
                            n = n7;
                            break;
                        }
                        n = lastVisiblePosition;
                        break;
                    }
                    default: {
                        int n = pageToShow = firstVisiblePosition;
                    }
                }
                if (pageToShow != this.lastDisplayedPage) {
                    this.updatePageNumberDisplay(pageToShow);
                    this.lastDisplayedPage = pageToShow;
                }
            }

            public final void updatePageNumberDisplay(int position) {
                block5: {
                    if (position == -1) break block5;
                    TextView textView = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView = null;
                    }
                    Object[] objectArray = new Object[]{position + 1, this.this$0.getTotalPageCount()};
                    textView.setText((CharSequence)this.$context.getString(R.string.pdfView_page_no, objectArray));
                    TextView textView2 = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView2 = null;
                    }
                    textView2.setVisibility(0);
                    TextView textView3 = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView3 = null;
                    }
                    textView3.removeCallbacks(this.hideRunnable);
                    TextView textView4 = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView4 = null;
                    }
                    textView4.postDelayed(this.hideRunnable, 3000L);
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack != null) {
                        statusCallBack.onPageChanged(position + 1, this.this$0.getTotalPageCount());
                    }
                }
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    TextView textView = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView = null;
                    }
                    textView.removeCallbacks(this.hideRunnable);
                    TextView textView2 = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView2 = null;
                    }
                    textView2.postDelayed(this.hideRunnable, 3000L);
                } else {
                    TextView textView = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView = null;
                    }
                    textView.removeCallbacks(this.hideRunnable);
                }
            }

            private static final void hideRunnable$lambda$0(PdfRendererView this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                TextView textView = PdfRendererView.access$getPageNo$p(this$0);
                if (textView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                    textView = null;
                }
                if (textView.getVisibility() == 0) {
                    TextView textView2 = PdfRendererView.access$getPageNo$p(this$0);
                    if (textView2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView2 = null;
                    }
                    textView2.setVisibility(8);
                }
            }
        };
    }

    public /* synthetic */ PdfRendererView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final PinchZoomRecyclerView getRecyclerView() {
        PinchZoomRecyclerView pinchZoomRecyclerView = this.recyclerView;
        if (pinchZoomRecyclerView != null) {
            return pinchZoomRecyclerView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        return null;
    }

    public final void setRecyclerView(@NotNull PinchZoomRecyclerView pinchZoomRecyclerView) {
        Intrinsics.checkNotNullParameter((Object)((Object)pinchZoomRecyclerView), (String)"<set-?>");
        this.recyclerView = pinchZoomRecyclerView;
    }

    @Nullable
    public final StatusCallBack getStatusListener() {
        return this.statusListener;
    }

    public final void setStatusListener(@Nullable StatusCallBack statusCallBack) {
        this.statusListener = statusCallBack;
    }

    public final int getTotalPageCount() {
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        return pdfRendererCore.getPageCount();
    }

    public final void initWithUrl(@NotNull String url, @NotNull HeaderData headers, @NotNull LifecycleCoroutineScope lifecycleCoroutineScope, @NotNull Lifecycle lifecycle, @NotNull CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)lifecycleCoroutineScope, (String)"lifecycleCoroutineScope");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
        lifecycle.addObserver((LifecycleObserver)this);
        this.cacheStrategy = cacheStrategy;
        new PdfDownloader((CoroutineScope)lifecycleCoroutineScope, headers, url, cacheStrategy, new PdfDownloader.StatusListener(this, cacheStrategy){
            final /* synthetic */ PdfRendererView this$0;
            final /* synthetic */ CacheStrategy $cacheStrategy;
            {
                this.this$0 = $receiver;
                this.$cacheStrategy = $cacheStrategy;
            }

            @NotNull
            public Context getContext() {
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                return context;
            }

            public void onDownloadStart() {
                block0: {
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onPdfLoadStart();
                }
            }

            public void onDownloadProgress(long currentBytes, long totalBytes) {
                block1: {
                    int progress = (int)((float)currentBytes / (float)totalBytes * 100.0f);
                    if (progress >= 100) {
                        progress = 100;
                    }
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block1;
                    statusCallBack.onPdfLoadProgress(progress, currentBytes, totalBytes);
                }
            }

            public void onDownloadSuccess(@NotNull File downloadedFile) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)downloadedFile, (String)"downloadedFile");
                    this.this$0.initWithFile(new File(downloadedFile.getAbsolutePath()), this.$cacheStrategy);
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    String string2 = downloadedFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                    statusCallBack.onPdfLoadSuccess(string2);
                }
            }

            public void onError(@NotNull Throwable error) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    error.printStackTrace();
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onError(error);
                }
            }
        });
    }

    public static /* synthetic */ void initWithUrl$default(PdfRendererView pdfRendererView, String string2, HeaderData headerData, LifecycleCoroutineScope lifecycleCoroutineScope, Lifecycle lifecycle, CacheStrategy cacheStrategy, int n, Object object) {
        if ((n & 2) != 0) {
            headerData = new HeaderData(null, 1, null);
        }
        if ((n & 0x10) != 0) {
            cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
        }
        pdfRendererView.initWithUrl(string2, headerData, lifecycleCoroutineScope, lifecycle, cacheStrategy);
    }

    public final void initWithFile(@NotNull File file, @NotNull CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
        String cacheIdentifier = file.getName();
        this.cacheStrategy = cacheStrategy;
        ParcelFileDescriptor fileDescriptor = PdfRendererCore.Companion.getFileDescriptor$pdfViewer_release(file);
        Intrinsics.checkNotNull((Object)cacheIdentifier);
        this.initializeRenderer(fileDescriptor, cacheIdentifier);
    }

    public static /* synthetic */ void initWithFile$default(PdfRendererView pdfRendererView, File file, CacheStrategy cacheStrategy, int n, Object object) {
        if ((n & 2) != 0) {
            cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
        }
        pdfRendererView.initWithFile(file, cacheStrategy);
    }

    public final void initWithUri(@NotNull Uri uri) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        ParcelFileDescriptor parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(uri, "r");
        if (parcelFileDescriptor == null) {
            return;
        }
        ParcelFileDescriptor fileDescriptor = parcelFileDescriptor;
        String cacheIdentifier = String.valueOf(uri.toString().hashCode());
        this.initializeRenderer(fileDescriptor, cacheIdentifier);
    }

    private final void initializeRenderer(ParcelFileDescriptor fileDescriptor, String cacheIdentifier) {
        PinchZoomRecyclerView pinchZoomRecyclerView;
        PdfRendererCore.Companion.setEnableDebugMetrics(true);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.pdfRendererCore = new PdfRendererCore(context, fileDescriptor, cacheIdentifier, this.cacheStrategy);
        this.pdfRendererCoreInitialised = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        this.pdfViewAdapter = new PdfViewAdapter(context2, pdfRendererCore, this.pageMargin, this.enableLoadingForPages);
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pdf_rendererview, (ViewGroup)this, false);
        this.addView(v);
        View view = this.findViewById(R.id.recyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.setRecyclerView((PinchZoomRecyclerView)view);
        View view2 = this.findViewById(R.id.pageNumber);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.pageNo = (TextView)view2;
        PinchZoomRecyclerView $this$initializeRenderer_u24lambda_u244 = pinchZoomRecyclerView = this.getRecyclerView();
        boolean bl = false;
        PdfViewAdapter pdfViewAdapter = this.pdfViewAdapter;
        if (pdfViewAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfViewAdapter");
            pdfViewAdapter = null;
        }
        $this$initializeRenderer_u24lambda_u244.setAdapter(pdfViewAdapter);
        $this$initializeRenderer_u24lambda_u244.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$initializeRenderer_u24lambda_u244.getContext(), 1, false));
        $this$initializeRenderer_u24lambda_u244.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        if (this.showDivider) {
            DividerItemDecoration dividerItemDecoration;
            DividerItemDecoration $this$initializeRenderer_u24lambda_u244_u24lambda_u242 = dividerItemDecoration = new DividerItemDecoration($this$initializeRenderer_u24lambda_u244.getContext(), 1);
            boolean bl2 = false;
            Drawable drawable = this.divider;
            if (drawable != null) {
                Drawable it = drawable;
                boolean bl3 = false;
                $this$initializeRenderer_u24lambda_u244_u24lambda_u242.setDrawable(it);
            }
            DividerItemDecoration it = dividerItemDecoration;
            boolean bl4 = false;
            $this$initializeRenderer_u24lambda_u244.addItemDecoration((RecyclerView.ItemDecoration)it);
        }
        $this$initializeRenderer_u24lambda_u244.setZoomEnabled(this.isZoomEnabled);
        $this$initializeRenderer_u24lambda_u244.addOnScrollListener(this.scrollListener);
        new Handler(Looper.getMainLooper()).postDelayed(() -> PdfRendererView.initializeRenderer$lambda$5(this), 500L);
        this.runnable = () -> PdfRendererView.initializeRenderer$lambda$6(this);
        this.getRecyclerView().post(() -> PdfRendererView.initializeRenderer$lambda$7(this));
        this.preloadCacheIntoMemory();
    }

    public final void jumpToPage(int pageNumber) {
        Function0 action2 = (Function0)new Function0<Unit>(pageNumber, this){
            final /* synthetic */ int $pageNumber;
            final /* synthetic */ PdfRendererView this$0;
            {
                this.$pageNumber = $pageNumber;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl = 0 <= this.$pageNumber ? this.$pageNumber < this.this$0.getTotalPageCount() : false;
                if (bl) {
                    this.this$0.getRecyclerView().post(() -> jumpToPage.action.1.invoke$lambda$1(this.this$0, this.$pageNumber));
                }
            }

            private static final void invoke$lambda$1$lambda$0(PdfRendererView this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                PdfRendererView.access$forceUpdatePageNumber(this$0);
            }

            private static final void invoke$lambda$1(PdfRendererView this$0, int $pageNumber) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                RecyclerView.LayoutManager layoutManager = this$0.getRecyclerView().getLayoutManager();
                Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
                layoutManager2.scrollToPositionWithOffset($pageNumber, 0);
                this$0.getRecyclerView().post(() -> jumpToPage.action.1.invoke$lambda$1$lambda$0(this$0));
            }
        };
        if (this.pdfRendererCore != null) {
            action2.invoke();
        } else {
            this.postInitializationAction = action2;
        }
    }

    private final void forceUpdatePageNumber() {
        int n;
        RecyclerView.LayoutManager layoutManager = this.getRecyclerView().getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
        LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
        int firstVisiblePosition = layoutManager2.findFirstVisibleItemPosition();
        int firstCompletelyVisiblePosition = layoutManager2.findFirstCompletelyVisibleItemPosition();
        int lastVisiblePosition = layoutManager2.findLastVisibleItemPosition();
        int lastCompletelyVisiblePosition = layoutManager2.findLastCompletelyVisibleItemPosition();
        Integer n2 = lastCompletelyVisiblePosition;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it != -1 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = lastVisiblePosition;
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 != -1 ? n4 : null;
            if (n5 != null) {
                n = n5;
            } else {
                Integer n6 = firstCompletelyVisiblePosition;
                int it3 = ((Number)n6).intValue();
                boolean bl3 = false;
                Integer n7 = it3 != -1 ? n6 : null;
                n = n7 != null ? n7 : firstVisiblePosition;
            }
        }
        int positionToUse = n;
        this.updatePageNumberDisplay(positionToUse);
    }

    private final void updatePageNumberDisplay(int position) {
        block5: {
            if (position == -1) break block5;
            TextView textView = this.pageNo;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                textView = null;
            }
            Object[] objectArray = new Object[]{position + 1, this.getTotalPageCount()};
            textView.setText((CharSequence)this.getContext().getString(R.string.pdfView_page_no, objectArray));
            TextView textView2 = this.pageNo;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                textView2 = null;
            }
            textView2.setVisibility(0);
            if (position == 0) {
                TextView textView3 = this.pageNo;
                if (textView3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                    textView3 = null;
                }
                textView3.postDelayed(() -> PdfRendererView.updatePageNumberDisplay$lambda$11(this), 3000L);
            }
            StatusCallBack statusCallBack = this.statusListener;
            if (statusCallBack != null) {
                statusCallBack.onPageChanged(position + 1, this.getTotalPageCount());
            }
        }
    }

    private final void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PdfRendererView, defStyle, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        this.setTypeArray(typedArray2);
    }

    private final void setTypeArray(TypedArray typedArray) {
        this.showDivider = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_showDivider, true);
        this.divider = typedArray.getDrawable(R.styleable.PdfRendererView_pdfView_divider);
        this.enableLoadingForPages = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_enableLoadingForPages, false);
        this.disableScreenshots = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_disableScreenshots, false);
        this.isZoomEnabled = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_enableZoom, true);
        int marginDim = typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_margin, 0);
        this.pageMargin.set(typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginLeft, marginDim), typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginTop, marginDim), typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginRight, marginDim), typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginBottom, marginDim));
        this.applyScreenshotSecurity();
        typedArray.recycle();
    }

    private final void applyScreenshotSecurity() {
        block0: {
            Context context;
            Activity activity;
            if (!this.disableScreenshots || (activity = (context = this.getContext()) instanceof Activity ? (Activity)context : null) == null || (activity = activity.getWindow()) == null) break block0;
            activity.addFlags(8192);
        }
    }

    public final void closePdfRender() {
        if (this.pdfRendererCoreInitialised) {
            PdfRendererCore pdfRendererCore = this.pdfRendererCore;
            if (pdfRendererCore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
                pdfRendererCore = null;
            }
            pdfRendererCore.closePdfRender();
            this.pdfRendererCoreInitialised = false;
        }
    }

    private final Bitmap getBitmapByPage(int page) {
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        return pdfRendererCore.getBitmapFromCache$pdfViewer_release(page);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bitmap> getLoadedBitmaps() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)this.getTotalPageCount());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Bitmap it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int page = element$iv$iv;
            boolean bl2 = false;
            if (this.getBitmapByPage(page) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void setZoomEnabled(boolean zoomEnabled) {
        this.isZoomEnabled = zoomEnabled;
    }

    @TestOnly
    public final boolean getZoomEnabled() {
        return this.isZoomEnabled;
    }

    private final void preloadCacheIntoMemory() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PdfRendererView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PdfRendererCore pdfRendererCore = PdfRendererView.access$getPdfRendererCore$p(this.this$0);
                        if (pdfRendererCore == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
                            pdfRendererCore = null;
                        }
                        PdfRendererCore renderer = pdfRendererCore;
                        boolean bl = false;
                        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)renderer.getPageCount());
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int pageNo = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl2 = false;
                            renderer.getBitmapFromCache$pdfViewer_release(pageNo);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle savedState = new Bundle();
        savedState.putParcelable("superState", superState);
        if (this.recyclerView != null) {
            savedState.putInt("scrollPosition", this.positionToUseForState);
        }
        return (Parcelable)savedState;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable savedState = state;
        if (savedState instanceof Bundle) {
            Parcelable superState = Build.VERSION.SDK_INT >= 33 ? (Parcelable)((Bundle)savedState).getParcelable("superState", Parcelable.class) : ((Bundle)savedState).getParcelable("superState");
            super.onRestoreInstanceState(superState);
            this.restoredScrollPosition = ((Bundle)savedState).getInt("scrollPosition", this.positionToUseForState);
        } else {
            super.onRestoreInstanceState(savedState);
        }
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void runnable$lambda$0() {
    }

    private static final void initializeRenderer$lambda$5(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.restoredScrollPosition != -1) {
            this$0.getRecyclerView().scrollToPosition(this$0.restoredScrollPosition);
            this$0.restoredScrollPosition = -1;
        }
    }

    private static final void initializeRenderer$lambda$6(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TextView textView = this$0.pageNo;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
            textView = null;
        }
        textView.setVisibility(8);
    }

    private static final void initializeRenderer$lambda$7(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Function0<Unit> function0 = this$0.postInitializationAction;
        if (function0 != null) {
            function0.invoke();
        }
        this$0.postInitializationAction = null;
    }

    private static final void updatePageNumberDisplay$lambda$11(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TextView textView = this$0.pageNo;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
            textView = null;
        }
        textView.setVisibility(8);
    }

    public static final /* synthetic */ void access$forceUpdatePageNumber(PdfRendererView $this) {
        $this.forceUpdatePageNumber();
    }

    public static final /* synthetic */ PdfRendererCore access$getPdfRendererCore$p(PdfRendererView $this) {
        return $this.pdfRendererCore;
    }

    public static final /* synthetic */ TextView access$getPageNo$p(PdfRendererView $this) {
        return $this.pageNo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J'\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "", "onError", "", "error", "", "onPageChanged", "currentPage", "", "totalPage", "onPdfLoadProgress", "progress", "downloadedBytes", "", "totalBytes", "(IJLjava/lang/Long;)V", "onPdfLoadStart", "onPdfLoadSuccess", "absolutePath", "", "pdfViewer_release"})
    public static interface StatusCallBack {
        public void onPdfLoadStart();

        public void onPdfLoadProgress(int var1, long var2, @Nullable Long var4);

        public void onPdfLoadSuccess(@NotNull String var1);

        public void onError(@NotNull Throwable var1);

        public void onPageChanged(int var1, int var2);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onPdfLoadStart(@NotNull StatusCallBack $this) {
            }

            public static void onPdfLoadProgress(@NotNull StatusCallBack $this, int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public static void onPdfLoadSuccess(@NotNull StatusCallBack $this, @NotNull String absolutePath) {
                Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
            }

            public static void onError(@NotNull StatusCallBack $this, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public static void onPageChanged(@NotNull StatusCallBack $this, int currentPage, int totalPage) {
            }
        }
    }
}

