/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.LruCache;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\fJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/rajat/pdfviewer/util/CacheManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cacheDir", "Ljava/io/File;", "memoryCache", "Landroid/util/LruCache;", "", "Landroid/graphics/Bitmap;", "addBitmapToCache", "", "pageNo", "bitmap", "clearCache", "createMemoryCache", "decodeBitmapFromDiskCache", "getBitmapFromCache", "initCache", "pageExistsInCache", "", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
public final class CacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final LruCache<Integer, Bitmap> memoryCache;
    @NotNull
    private final File cacheDir;
    public static final int $stable = 8;
    @NotNull
    public static final String CACHE_PATH = "___pdf___cache___";

    public CacheManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.memoryCache = this.createMemoryCache();
        this.cacheDir = new File(this.context.getCacheDir(), CACHE_PATH);
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    private final LruCache<Integer, Bitmap> createMemoryCache() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / (long)1024);
        int cacheSize = maxMemory / 8;
        return (LruCache)new LruCache<Integer, Bitmap>(cacheSize){

            protected int sizeOf(int key, @NotNull Bitmap value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getByteCount() / 1024;
            }
        };
    }

    public final void initCache() {
        File cacheDir = new File(this.context.getCacheDir(), CACHE_PATH);
        if (cacheDir.exists()) {
            FilesKt.deleteRecursively((File)cacheDir);
        }
        cacheDir.mkdirs();
    }

    @Nullable
    public final Bitmap getBitmapFromCache(int pageNo) {
        Bitmap bitmap = (Bitmap)this.memoryCache.get((Object)pageNo);
        if (bitmap == null) {
            bitmap = this.decodeBitmapFromDiskCache(pageNo);
        }
        return bitmap;
    }

    private final Bitmap decodeBitmapFromDiskCache(int pageNo) {
        File file = new File(this.cacheDir, String.valueOf(pageNo));
        return file.exists() ? BitmapFactory.decodeFile((String)file.getAbsolutePath()) : null;
    }

    public final void addBitmapToCache(int pageNo, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.memoryCache.put((Object)pageNo, (Object)bitmap);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pageNo, bitmap, null){
            int label;
            final /* synthetic */ CacheManager this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$pageNo = $pageNo;
                this.$bitmap = $bitmap;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        File file = new File(CacheManager.access$getCacheDir$p(this.this$0), String.valueOf(this.$pageNo));
                        Closeable closeable = new FileOutputStream(file);
                        Bitmap bitmap = this.$bitmap;
                        Throwable throwable = null;
                        try {
                            FileOutputStream fos = (FileOutputStream)closeable;
                            boolean bl = false;
                            bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)fos);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean pageExistsInCache(int pageNo) {
        return new File(this.cacheDir, String.valueOf(pageNo)).exists();
    }

    public final void clearCache() {
        this.memoryCache.evictAll();
        FilesKt.deleteRecursively((File)this.cacheDir);
    }

    public static final /* synthetic */ File access$getCacheDir$p(CacheManager $this) {
        return $this.cacheDir;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/rajat/pdfviewer/util/CacheManager$Companion;", "", "()V", "CACHE_PATH", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

