/*
 * Decompiled with CFR 0.152.
 */
package io.github.adraffy.ens;

import io.github.adraffy.ens.Decoder;
import io.github.adraffy.ens.IntList;
import io.github.adraffy.ens.ReadOnlyIntSet;
import io.github.adraffy.ens.StringUtils;
import java.util.HashMap;

public class NF {
    static final int SHIFT = 24;
    static final int MASK = 0xFFFFFF;
    static final int NONE = -1;
    static final int S0 = 44032;
    static final int L0 = 4352;
    static final int V0 = 4449;
    static final int T0 = 4519;
    static final int L_COUNT = 19;
    static final int V_COUNT = 21;
    static final int T_COUNT = 28;
    static final int N_COUNT = 588;
    static final int S_COUNT = 11172;
    static final int S1 = 55204;
    static final int L1 = 4371;
    static final int V1 = 4470;
    static final int T1 = 4547;
    public final String unicodeVersion;
    final ReadOnlyIntSet exclusions;
    final ReadOnlyIntSet quickCheck;
    final HashMap<Integer, int[]> decomps = new HashMap();
    final HashMap<Integer, HashMap<Integer, Integer>> recomps = new HashMap();
    final HashMap<Integer, Integer> ranks = new HashMap();

    static boolean isHangul(int cp) {
        return cp >= 44032 && cp < 55204;
    }

    static int unpackCC(int packed) {
        return packed >> 24;
    }

    static int unpackCP(int packed) {
        return packed & 0xFFFFFF;
    }

    public NF(Decoder dec) {
        this.unicodeVersion = dec.readString();
        this.exclusions = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        this.quickCheck = ReadOnlyIntSet.fromOwnedUnsorted(dec.readUnique());
        int[] decomp1 = dec.readSortedUnique();
        int[] decomp1A = dec.readUnsortedDeltas(decomp1.length);
        for (int i = 0; i < decomp1.length; ++i) {
            this.decomps.put(decomp1[i], new int[]{decomp1A[i]});
        }
        int[] decomp2 = dec.readSortedUnique();
        int n = decomp2.length;
        int[] decomp2A = dec.readUnsortedDeltas(n);
        int[] decomp2B = dec.readUnsortedDeltas(n);
        for (int i = 0; i < n; ++i) {
            int cp = decomp2[i];
            int cpA = decomp2A[i];
            int cpB = decomp2B[i];
            this.decomps.put(cp, new int[]{cpB, cpA});
            if (this.exclusions.contains(cp)) continue;
            HashMap<Integer, Integer> recomp = this.recomps.get(cpA);
            if (recomp == null) {
                recomp = new HashMap();
                this.recomps.put(cpA, recomp);
            }
            recomp.put(cpB, cp);
        }
        int rank = 0;
        block2: while (true) {
            rank += 0x1000000;
            int[] v = dec.readUnique();
            if (v.length == 0) break;
            Integer boxed = rank;
            int[] nArray = v;
            int n2 = nArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) continue block2;
                int cp = nArray[n3];
                this.ranks.put(cp, boxed);
                ++n3;
            }
            break;
        }
    }

    int composePair(int a, int b) {
        Integer boxed;
        if (a >= 4352 && a < 4371 && b >= 4449 && b < 4470) {
            return 44032 + (a - 4352) * 588 + (b - 4449) * 28;
        }
        if (NF.isHangul(a) && b > 4519 && b < 4547 && (a - 44032) % 28 == 0) {
            return a + (b - 4519);
        }
        HashMap<Integer, Integer> map = this.recomps.get(a);
        if (map != null && (boxed = map.get(b)) != null) {
            return boxed;
        }
        return -1;
    }

    int[] decomposed(int[] cps) {
        Packer p = new Packer();
        IntList buf = new IntList();
        int[] nArray = cps;
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int cp0;
            int cp = cp0 = nArray[i];
            while (true) {
                if (cp < 128) {
                    p.buf.add(cp);
                } else if (NF.isHangul(cp)) {
                    int s_index = cp - 44032;
                    int l_index = s_index / 588;
                    int v_index = s_index % 588 / 28;
                    int t_index = s_index % 28;
                    p.add(4352 + l_index);
                    p.add(4449 + v_index);
                    if (t_index > 0) {
                        p.add(4519 + t_index);
                    }
                } else {
                    int[] decomp = this.decomps.get(cp);
                    if (decomp != null) {
                        for (int x : decomp) {
                            buf.add(x);
                        }
                    } else {
                        p.add(cp);
                    }
                }
                if (buf.count == 0) continue block0;
                cp = buf.pop();
            }
        }
        p.fixOrder();
        return p.buf.consume();
    }

    int[] composedFromPacked(int[] packed) {
        IntList cps = new IntList();
        IntList stack = new IntList();
        int prev_cp = -1;
        int prev_cc = 0;
        for (int p : packed) {
            int cc = NF.unpackCC(p);
            int cp = NF.unpackCP(p);
            if (prev_cp == -1) {
                if (cc == 0) {
                    prev_cp = cp;
                    continue;
                }
                cps.add(cp);
                continue;
            }
            if (prev_cc > 0 && prev_cc >= cc) {
                if (cc == 0) {
                    cps.add(prev_cp);
                    cps.add(stack);
                    stack.count = 0;
                    prev_cp = cp;
                } else {
                    stack.add(cp);
                }
                prev_cc = cc;
                continue;
            }
            int composed = this.composePair(prev_cp, cp);
            if (composed != -1) {
                prev_cp = composed;
                continue;
            }
            if (prev_cc == 0 && cc == 0) {
                cps.add(prev_cp);
                prev_cp = cp;
                continue;
            }
            stack.add(cp);
            prev_cc = cc;
        }
        if (prev_cp != -1) {
            cps.add(prev_cp);
            cps.add(stack);
        }
        return cps.consume();
    }

    public int[] NFD(int ... cps) {
        int[] v = this.decomposed(cps);
        int e = v.length;
        for (int i = 0; i < e; ++i) {
            v[i] = NF.unpackCP(v[i]);
        }
        return v;
    }

    public int[] NFC(int ... cps) {
        return this.composedFromPacked(this.decomposed(cps));
    }

    public String NFD(String s) {
        return StringUtils.implode(this.NFD(StringUtils.explode(s)));
    }

    public String NFC(String s) {
        return StringUtils.implode(this.NFC(StringUtils.explode(s)));
    }

    class Packer {
        final IntList buf = new IntList();
        boolean check = false;

        Packer() {
        }

        void add(int cp) {
            int cc = NF.this.ranks.getOrDefault(cp, 0);
            if (cc != 0) {
                this.check = true;
                cp |= cc;
            }
            this.buf.add(cp);
        }

        void fixOrder() {
            if (!this.check) {
                return;
            }
            int[] v = this.buf.array;
            int prev = NF.unpackCC(v[0]);
            int e = this.buf.count;
            for (int i = 1; i < e; ++i) {
                int cc = NF.unpackCC(v[i]);
                if (cc == 0 || prev <= cc) {
                    prev = cc;
                    continue;
                }
                int j = i - 1;
                do {
                    int temp = v[j];
                    v[j] = v[j + 1];
                    v[j + 1] = temp;
                } while (j != 0 && (prev = NF.unpackCC(v[--j])) > cc);
                prev = NF.unpackCC(v[i]);
            }
        }
    }
}

