/*
 * Decompiled with CFR 0.152.
 */
package io.github.aakira.napier;

import android.os.Build;
import android.util.Log;
import io.github.aakira.napier.Antilog;
import io.github.aakira.napier.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u000eJ.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0012H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\u0003*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/github/aakira/napier/DebugAntilog;", "Lio/github/aakira/napier/Antilog;", "defaultTag", "", "(Ljava/lang/String;)V", "anonymousClass", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "stackTraceString", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "createStackElementTag", "className", "createStackElementTag$napier_release", "performLog", "", "priority", "Lio/github/aakira/napier/LogLevel;", "tag", "throwable", "message", "performTag", "toValue", "", "Companion", "napier_release"})
public final class DebugAntilog
extends Antilog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String defaultTag;
    private final Pattern anonymousClass;
    private static final int MAX_LOG_LENGTH = 4000;
    private static final int MAX_TAG_LENGTH = 23;
    private static final int CALL_STACK_INDEX = 9;

    public DebugAntilog(@NotNull String defaultTag) {
        Intrinsics.checkNotNullParameter((Object)defaultTag, (String)"defaultTag");
        this.defaultTag = defaultTag;
        this.anonymousClass = Pattern.compile("(\\$\\d+)+$");
    }

    public /* synthetic */ DebugAntilog(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "app";
        }
        this(string);
    }

    @Override
    protected void performLog(@NotNull LogLevel priority, @Nullable String tag, @Nullable Throwable throwable, @Nullable String message) {
        Object object;
        String debugTag;
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        String string = tag;
        if (string == null) {
            string = debugTag = this.performTag(this.defaultTag);
        }
        if (message != null) {
            object = throwable != null ? message + "\n" + this.getStackTraceString(throwable) : message;
        } else {
            object = throwable;
            if (object == null || (object = this.getStackTraceString((Throwable)object)) == null) {
                return;
            }
        }
        Object fullMessage = object;
        int length = ((String)fullMessage).length();
        if (length <= 4000) {
            if (priority == LogLevel.ASSERT) {
                Log.wtf((String)debugTag, (String)fullMessage);
            } else {
                Log.println((int)this.toValue(priority), (String)debugTag, (String)fullMessage);
            }
            return;
        }
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = StringsKt.indexOf$default((CharSequence)((CharSequence)fullMessage), (char)'\n', (int)i, (boolean)false, (int)4, null);
            newline = newline != -1 ? newline : length;
            do {
                String part;
                end = Math.min(newline, i + 4000);
                Intrinsics.checkNotNullExpressionValue((Object)((String)fullMessage).substring(i, end), (String)"substring(...)");
                if (this.toValue(priority) == 7) {
                    Log.wtf((String)debugTag, (String)part);
                    continue;
                }
                Log.println((int)this.toValue(priority), (String)debugTag, (String)part);
            } while ((i = end) < newline);
        }
    }

    private final String performTag(String tag) {
        Object object;
        StackTraceElement[] thread = Thread.currentThread().getStackTrace();
        if (thread.length >= 9) {
            StackTraceElement $this$performTag_u24lambda_u240 = thread[9];
            boolean bl = false;
            String string = $this$performTag_u24lambda_u240.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            object = this.createStackElementTag$napier_release(string) + "$" + $this$performTag_u24lambda_u240.getMethodName();
        } else {
            object = tag;
        }
        return object;
    }

    @NotNull
    public final String createStackElementTag$napier_release(@NotNull String className) {
        String string;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String tag = className;
        Matcher m = this.anonymousClass.matcher(tag);
        if (m.find()) {
            String string2 = m.replaceAll("");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceAll(...)");
            tag = string2;
        }
        String string3 = tag.substring(StringsKt.lastIndexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        tag = string3;
        if (tag.length() <= 23 || Build.VERSION.SDK_INT >= 24) {
            string = tag;
        } else {
            String string4 = tag.substring(0, 23);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        return string;
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int toValue(LogLevel $this$toValue) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toValue.ordinal()]) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            case 5 -> 6;
            case 6 -> 7;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public DebugAntilog() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/aakira/napier/DebugAntilog$Companion;", "", "()V", "CALL_STACK_INDEX", "", "MAX_LOG_LENGTH", "MAX_TAG_LENGTH", "napier_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ASSERT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

