/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.transport.rest.handler;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.ListTasksResponse;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageRequestOrBuilder;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.SetTaskPushNotificationConfigRequest;
import io.a2a.grpc.SetTaskPushNotificationConfigRequestOrBuilder;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.server.AgentCardValidator;
import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.PublicAgentCard;
import io.a2a.server.ServerCallContext;
import io.a2a.server.extensions.A2AExtensions;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.server.util.async.AsyncUtils;
import io.a2a.server.util.async.Internal;
import io.a2a.server.version.A2AVersionValidator;
import io.a2a.spec.A2AError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.ExtendedCardNotConfiguredError;
import io.a2a.spec.ExtensionSupportRequiredError;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskState;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.spec.VersionNotSupportedError;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import mutiny.zero.TubeConfiguration;
import mutiny.zero.ZeroPublisher;
import org.jspecify.annotations.Nullable;

@ApplicationScoped
public class RestHandler {
    private static final Logger log = Logger.getLogger(RestHandler.class.getName());
    private static final String TASK_STATE_PREFIX = "TASK_STATE_";
    private AgentCard agentCard;
    private @Nullable Instance<AgentCard> extendedAgentCard;
    private RequestHandler requestHandler;
    private Executor executor;

    protected RestHandler() {
        this.executor = null;
    }

    @Inject
    public RestHandler(@PublicAgentCard AgentCard agentCard, @ExtendedAgentCard Instance<AgentCard> extendedAgentCard, RequestHandler requestHandler, @Internal Executor executor) {
        this.agentCard = agentCard;
        this.extendedAgentCard = extendedAgentCard;
        this.requestHandler = requestHandler;
        this.executor = executor;
        AgentCardValidator.validateTransportConfiguration((AgentCard)agentCard);
    }

    public RestHandler(AgentCard agentCard, RequestHandler requestHandler, Executor executor) {
        this.agentCard = agentCard;
        this.requestHandler = requestHandler;
        this.executor = executor;
    }

    public HTTPRestResponse sendMessage(String body, String tenant, ServerCallContext context) {
        try {
            A2AVersionValidator.validateProtocolVersion((AgentCard)this.agentCard, (ServerCallContext)context);
            A2AExtensions.validateRequiredExtensions((AgentCard)this.agentCard, (ServerCallContext)context);
            SendMessageRequest.Builder request = SendMessageRequest.newBuilder();
            this.parseRequestBody(body, (Message.Builder)request);
            request.setTenant(tenant);
            EventKind result = this.requestHandler.onMessageSend(ProtoUtils.FromProto.messageSendParams((SendMessageRequestOrBuilder)request), context);
            return this.createSuccessResponse(200, (Message.Builder)SendMessageResponse.newBuilder((SendMessageResponse)ProtoUtils.ToProto.taskOrMessage((EventKind)result)));
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse sendStreamingMessage(String body, String tenant, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().streaming()) {
                return this.createErrorResponse((A2AError)new InvalidRequestError("Streaming is not supported by the agent"));
            }
            A2AVersionValidator.validateProtocolVersion((AgentCard)this.agentCard, (ServerCallContext)context);
            A2AExtensions.validateRequiredExtensions((AgentCard)this.agentCard, (ServerCallContext)context);
            SendMessageRequest.Builder request = SendMessageRequest.newBuilder();
            this.parseRequestBody(body, (Message.Builder)request);
            request.setTenant(tenant);
            Flow.Publisher publisher = this.requestHandler.onMessageSendStream(ProtoUtils.FromProto.messageSendParams((SendMessageRequestOrBuilder)request), context);
            return this.createStreamingResponse(publisher);
        }
        catch (A2AError e) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse(e).toJson()}));
        }
        catch (Throwable throwable) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse((A2AError)new InternalError(throwable.getMessage())).toJson()}));
        }
    }

    public HTTPRestResponse cancelTask(String taskId, String tenant, ServerCallContext context) {
        try {
            if (taskId == null || taskId.isEmpty()) {
                throw new InvalidParamsError();
            }
            TaskIdParams params = new TaskIdParams(taskId, tenant);
            io.a2a.spec.Task task = this.requestHandler.onCancelTask(params, context);
            if (task != null) {
                return this.createSuccessResponse(200, (Message.Builder)Task.newBuilder((Task)ProtoUtils.ToProto.task((io.a2a.spec.Task)task)));
            }
            throw new UnsupportedOperationError();
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse setTaskPushNotificationConfiguration(String taskId, String body, String tenant, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            SetTaskPushNotificationConfigRequest.Builder builder = SetTaskPushNotificationConfigRequest.newBuilder();
            this.parseRequestBody(body, (Message.Builder)builder);
            builder.setTenant(tenant);
            io.a2a.spec.TaskPushNotificationConfig result = this.requestHandler.onSetTaskPushNotificationConfig(ProtoUtils.FromProto.setTaskPushNotificationConfig((SetTaskPushNotificationConfigRequestOrBuilder)builder), context);
            return this.createSuccessResponse(201, (Message.Builder)TaskPushNotificationConfig.newBuilder((TaskPushNotificationConfig)ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)result)));
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse subscribeToTask(String taskId, String tenant, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().streaming()) {
                return this.createErrorResponse((A2AError)new InvalidRequestError("Streaming is not supported by the agent"));
            }
            TaskIdParams params = new TaskIdParams(taskId, tenant);
            Flow.Publisher publisher = this.requestHandler.onResubscribeToTask(params, context);
            return this.createStreamingResponse(publisher);
        }
        catch (A2AError e) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse(e).toJson()}));
        }
        catch (Throwable throwable) {
            return new HTTPRestStreamingResponse(ZeroPublisher.fromItems((Object[])new String[]{new HTTPRestErrorResponse((A2AError)new InternalError(throwable.getMessage())).toJson()}));
        }
    }

    public HTTPRestResponse getTask(String taskId, @Nullable Integer historyLength, String tenant, ServerCallContext context) {
        try {
            TaskQueryParams params = new TaskQueryParams(taskId, historyLength, tenant);
            io.a2a.spec.Task task = this.requestHandler.onGetTask(params, context);
            if (task != null) {
                return this.createSuccessResponse(200, (Message.Builder)Task.newBuilder((Task)ProtoUtils.ToProto.task((io.a2a.spec.Task)task)));
            }
            throw new TaskNotFoundError();
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse listTasks(@Nullable String contextId, @Nullable String status, @Nullable Integer pageSize, @Nullable String pageToken, @Nullable Integer historyLength, @Nullable String lastUpdatedAfter, @Nullable Boolean includeArtifacts, String tenant, ServerCallContext context) {
        try {
            HashMap<String, Object> errorData;
            ListTasksParams.Builder paramsBuilder = ListTasksParams.builder();
            if (contextId != null) {
                paramsBuilder.contextId(contextId);
            }
            if (status != null) {
                TaskState taskState = null;
                try {
                    taskState = TaskState.fromString((String)status);
                }
                catch (IllegalArgumentException e) {
                    if (status.startsWith(TASK_STATE_PREFIX)) {
                        String enumName = status.substring(TASK_STATE_PREFIX.length());
                        try {
                            taskState = TaskState.valueOf((String)enumName);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    try {
                        taskState = TaskState.valueOf((String)status);
                    }
                    catch (IllegalArgumentException enumName) {
                        // empty catch block
                    }
                }
                if (taskState == null) {
                    String validStates = Arrays.stream(TaskState.values()).map(TaskState::asString).collect(Collectors.joining(", "));
                    errorData = new HashMap<String, Object>();
                    errorData.put("parameter", "status");
                    errorData.put("reason", "Must be one of: " + validStates);
                    throw new InvalidParamsError(null, "Invalid params", errorData);
                }
                paramsBuilder.status(taskState);
            }
            if (pageSize != null) {
                paramsBuilder.pageSize(pageSize);
            }
            if (pageToken != null) {
                paramsBuilder.pageToken(pageToken);
            }
            if (historyLength != null) {
                paramsBuilder.historyLength(historyLength);
            }
            paramsBuilder.tenant(tenant);
            if (lastUpdatedAfter != null) {
                try {
                    long millis = Long.parseLong(lastUpdatedAfter);
                    if (millis < 0L) {
                        errorData = new HashMap();
                        errorData.put("parameter", "lastUpdatedAfter");
                        errorData.put("reason", "Must be a non-negative timestamp value, got: " + millis);
                        throw new InvalidParamsError(null, "Invalid params", errorData);
                    }
                    paramsBuilder.lastUpdatedAfter(Instant.ofEpochMilli(millis));
                }
                catch (NumberFormatException nfe) {
                    try {
                        paramsBuilder.lastUpdatedAfter(Instant.parse(lastUpdatedAfter));
                    }
                    catch (DateTimeParseException e) {
                        errorData = new HashMap();
                        errorData.put("parameter", "lastUpdatedAfter");
                        errorData.put("reason", "Must be valid Unix milliseconds or ISO-8601 timestamp");
                        throw new InvalidParamsError(null, "Invalid params", errorData);
                    }
                }
            }
            if (includeArtifacts != null) {
                paramsBuilder.includeArtifacts(includeArtifacts);
            }
            ListTasksParams params = paramsBuilder.build();
            ListTasksResult result = this.requestHandler.onListTasks(params, context);
            return this.createSuccessResponse(200, (Message.Builder)ListTasksResponse.newBuilder((ListTasksResponse)ProtoUtils.ToProto.listTasksResult((ListTasksResult)result)));
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse getTaskPushNotificationConfiguration(String taskId, @Nullable String configId, String tenant, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            GetTaskPushNotificationConfigParams params = new GetTaskPushNotificationConfigParams(taskId, configId, tenant);
            io.a2a.spec.TaskPushNotificationConfig config = this.requestHandler.onGetTaskPushNotificationConfig(params, context);
            return this.createSuccessResponse(200, (Message.Builder)TaskPushNotificationConfig.newBuilder((TaskPushNotificationConfig)ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)config)));
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse listTaskPushNotificationConfigurations(String taskId, int pageSize, String pageToken, String tenant, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            ListTaskPushNotificationConfigParams params = new ListTaskPushNotificationConfigParams(taskId, pageSize, pageToken, tenant);
            ListTaskPushNotificationConfigResult result = this.requestHandler.onListTaskPushNotificationConfig(params, context);
            return this.createSuccessResponse(200, (Message.Builder)ListTaskPushNotificationConfigResponse.newBuilder((ListTaskPushNotificationConfigResponse)ProtoUtils.ToProto.listTaskPushNotificationConfigResponse((ListTaskPushNotificationConfigResult)result)));
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    public HTTPRestResponse deleteTaskPushNotificationConfiguration(String taskId, String configId, String tenant, ServerCallContext context) {
        try {
            if (!this.agentCard.capabilities().pushNotifications()) {
                throw new PushNotificationNotSupportedError();
            }
            DeleteTaskPushNotificationConfigParams params = new DeleteTaskPushNotificationConfigParams(taskId, configId, tenant);
            this.requestHandler.onDeleteTaskPushNotificationConfig(params, context);
            return new HTTPRestResponse(204, "application/json", "");
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable throwable) {
            return this.createErrorResponse((A2AError)new InternalError(throwable.getMessage()));
        }
    }

    private void parseRequestBody(String body, Message.Builder builder) throws A2AError {
        try {
            if (body == null || body.trim().isEmpty()) {
                throw new InvalidRequestError("Request body is required");
            }
            this.validate(body);
            JsonFormat.parser().merge(body, builder);
        }
        catch (InvalidProtocolBufferException e) {
            log.log(Level.SEVERE, "Error parsing JSON request body: {0}", body);
            log.log(Level.SEVERE, "Parse error details", e);
            throw new InvalidParamsError("Failed to parse request body: " + e.getMessage());
        }
    }

    private void validate(String json) {
        try {
            JsonParser.parseString((String)json);
        }
        catch (JsonSyntaxException e) {
            throw new JSONParseError(Integer.valueOf(-32700), "Failed to parse json", (Object)e.getMessage());
        }
    }

    private HTTPRestResponse createSuccessResponse(int statusCode, Message.Builder builder) {
        try {
            String jsonBody = JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)builder);
            return new HTTPRestResponse(statusCode, "application/json", jsonBody);
        }
        catch (InvalidProtocolBufferException e) {
            return this.createErrorResponse((A2AError)new InternalError("Failed to serialize response: " + e.getMessage()));
        }
    }

    public HTTPRestResponse createErrorResponse(A2AError error) {
        int statusCode = this.mapErrorToHttpStatus(error);
        return this.createErrorResponse(statusCode, error);
    }

    private HTTPRestResponse createErrorResponse(int statusCode, A2AError error) {
        String jsonBody = new HTTPRestErrorResponse(error).toJson();
        return new HTTPRestResponse(statusCode, "application/json", jsonBody);
    }

    private HTTPRestStreamingResponse createStreamingResponse(Flow.Publisher<StreamingEventKind> publisher) {
        return new HTTPRestStreamingResponse(this.convertToSendStreamingMessageResponse(publisher));
    }

    private Flow.Publisher<String> convertToSendStreamingMessageResponse(Flow.Publisher<StreamingEventKind> publisher) {
        return ZeroPublisher.create((TubeConfiguration)AsyncUtils.createTubeConfig(), tube -> CompletableFuture.runAsync(() -> publisher.subscribe(new Flow.Subscriber<StreamingEventKind>(){
             @Nullable Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(StreamingEventKind item) {
                try {
                    String payload = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)ProtoUtils.ToProto.taskOrMessageStream((StreamingEventKind)item));
                    tube.send((Object)payload);
                    if (this.subscription != null) {
                        this.subscription.request(1L);
                    }
                }
                catch (InvalidProtocolBufferException ex) {
                    this.onError(ex);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                if (throwable instanceof A2AError) {
                    A2AError jsonrpcError = (A2AError)throwable;
                    tube.send((Object)new HTTPRestErrorResponse(jsonrpcError).toJson());
                } else {
                    tube.send((Object)new HTTPRestErrorResponse((A2AError)new InternalError(throwable.getMessage())).toJson());
                }
                this.onComplete();
            }

            @Override
            public void onComplete() {
                tube.complete();
            }
        }), this.executor));
    }

    private int mapErrorToHttpStatus(A2AError error) {
        if (error instanceof InvalidRequestError || error instanceof JSONParseError) {
            return 400;
        }
        if (error instanceof InvalidParamsError) {
            return 422;
        }
        if (error instanceof MethodNotFoundError || error instanceof TaskNotFoundError) {
            return 404;
        }
        if (error instanceof TaskNotCancelableError) {
            return 409;
        }
        if (error instanceof PushNotificationNotSupportedError || error instanceof UnsupportedOperationError || error instanceof VersionNotSupportedError) {
            return 501;
        }
        if (error instanceof ContentTypeNotSupportedError) {
            return 415;
        }
        if (error instanceof InvalidAgentResponseError) {
            return 502;
        }
        if (error instanceof ExtendedCardNotConfiguredError || error instanceof ExtensionSupportRequiredError) {
            return 400;
        }
        if (error instanceof InternalError) {
            return 500;
        }
        return 500;
    }

    public HTTPRestResponse getExtendedAgentCard(String tenant) {
        try {
            if (!this.agentCard.supportsExtendedAgentCard() || this.extendedAgentCard == null || !this.extendedAgentCard.isResolvable()) {
                throw new ExtendedCardNotConfiguredError(null, "Extended Card not configured", null);
            }
            return new HTTPRestResponse(200, "application/json", JsonUtil.toJson((Object)this.extendedAgentCard.get()));
        }
        catch (A2AError e) {
            return this.createErrorResponse(e);
        }
        catch (Throwable t) {
            return this.createErrorResponse(500, (A2AError)new InternalError(t.getMessage()));
        }
    }

    public HTTPRestResponse getAgentCard() {
        try {
            return new HTTPRestResponse(200, "application/json", JsonUtil.toJson((Object)this.agentCard));
        }
        catch (Throwable t) {
            return this.createErrorResponse(500, (A2AError)new InternalError(t.getMessage()));
        }
    }

    public static class HTTPRestResponse {
        private final int statusCode;
        private final String contentType;
        private final String body;

        public HTTPRestResponse(int statusCode, String contentType, String body) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "HTTPRestResponse{statusCode=" + this.statusCode + ", contentType=" + this.contentType + ", body=" + this.body + "}";
        }
    }

    public static class HTTPRestStreamingResponse
    extends HTTPRestResponse {
        private final Flow.Publisher<String> publisher;

        public HTTPRestStreamingResponse(Flow.Publisher<String> publisher) {
            super(200, "text/event-stream", "");
            this.publisher = publisher;
        }

        public Flow.Publisher<String> getPublisher() {
            return this.publisher;
        }
    }

    private static class HTTPRestErrorResponse {
        private final String error;
        private final @Nullable String message;

        private HTTPRestErrorResponse(A2AError jsonRpcError) {
            this.error = jsonRpcError.getClass().getName();
            this.message = jsonRpcError.getMessage();
        }

        private String toJson() {
            return "{\"error\": \"" + this.error + "\", \"message\": \"" + this.message + "\"}";
        }

        public String toString() {
            return "HTTPRestErrorResponse{error=" + this.error + ", message=" + this.message + "}";
        }
    }
}

