/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

public enum TransportProtocol {
    JSONRPC("JSONRPC"),
    GRPC("GRPC"),
    HTTP_JSON("HTTP+JSON");

    private final String transport;

    private TransportProtocol(String transport) {
        this.transport = transport;
    }

    public String asString() {
        return this.transport;
    }

    public static TransportProtocol fromString(String transport) {
        return switch (transport) {
            case "JSONRPC" -> JSONRPC;
            case "GRPC" -> GRPC;
            case "HTTP+JSON" -> HTTP_JSON;
            default -> throw new IllegalArgumentException("Invalid transport: " + transport);
        };
    }
}

