/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.util.Assert;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public record SecurityRequirement(Map<String, List<String>> schemes) {
    public SecurityRequirement {
        Assert.checkNotNullParam((String)"schemes", schemes);
        schemes = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(schemes));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, List<String>> schemes = new LinkedHashMap<String, List<String>>();

        private Builder() {
        }

        public Builder scheme(String schemeName, List<String> scopes) {
            this.schemes.put(schemeName, List.copyOf(scopes));
            return this;
        }

        public SecurityRequirement build() {
            return new SecurityRequirement(this.schemes);
        }
    }
}

