/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.AuthenticationInfo;
import io.a2a.util.Assert;
import org.jspecify.annotations.Nullable;

public record PushNotificationConfig(String url, @Nullable String token, @Nullable AuthenticationInfo authentication, @Nullable String id) {
    public PushNotificationConfig(String url, @Nullable String token, @Nullable AuthenticationInfo authentication, @Nullable String id) {
        Assert.checkNotNullParam((String)"url", (Object)url);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PushNotificationConfig config) {
        return new Builder(config);
    }

    public static class Builder {
        private @Nullable String url;
        private @Nullable String token;
        private @Nullable AuthenticationInfo authentication;
        private @Nullable String id;

        private Builder() {
        }

        private Builder(PushNotificationConfig notificationConfig) {
            this.url = notificationConfig.url;
            this.token = notificationConfig.token;
            this.authentication = notificationConfig.authentication;
            this.id = notificationConfig.id;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder authentication(AuthenticationInfo authenticationInfo) {
            this.authentication = authenticationInfo;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public PushNotificationConfig build() {
            return new PushNotificationConfig((String)Assert.checkNotNullParam((String)"url", (Object)this.url), this.token, this.authentication, this.id);
        }
    }
}

