/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.util.Assert;
import io.a2a.util.Utils;
import org.jspecify.annotations.Nullable;

public record ListTaskPushNotificationConfigParams(String id, int pageSize, String pageToken, String tenant) {
    public ListTaskPushNotificationConfigParams {
        Assert.checkNotNullParam((String)"id", (Object)id);
        Assert.checkNotNullParam((String)"tenant", (Object)tenant);
    }

    public ListTaskPushNotificationConfigParams(String id) {
        this(id, 0, "", "");
    }

    public int getEffectivePageSize() {
        if (this.pageSize <= 0 || this.pageSize > 100) {
            return 100;
        }
        return this.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String id;
        private @Nullable Integer pageSize;
        private @Nullable String pageToken;
        private @Nullable String tenant;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ListTaskPushNotificationConfigParams build() {
            return new ListTaskPushNotificationConfigParams((String)Assert.checkNotNullParam((String)"id", (Object)this.id), this.pageSize != null ? this.pageSize : 0, this.pageToken != null ? this.pageToken : "", Utils.defaultIfNull(this.tenant, ""));
        }
    }
}

