/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCardSignature;
import io.a2a.spec.AgentInterface;
import io.a2a.spec.AgentProvider;
import io.a2a.spec.AgentSkill;
import io.a2a.spec.SecurityRequirement;
import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public record AgentCard(String name, String description, @Nullable AgentProvider provider, String version, @Nullable String documentationUrl, AgentCapabilities capabilities, List<String> defaultInputModes, List<String> defaultOutputModes, List<AgentSkill> skills, @Nullable Map<String, SecurityScheme> securitySchemes, @Nullable List<SecurityRequirement> securityRequirements, @Nullable String iconUrl, List<AgentInterface> supportedInterfaces, @Nullable List<AgentCardSignature> signatures) {
    public AgentCard(String name, String description, @Nullable AgentProvider provider, String version, @Nullable String documentationUrl, AgentCapabilities capabilities, List<String> defaultInputModes, List<String> defaultOutputModes, List<AgentSkill> skills, @Nullable Map<String, SecurityScheme> securitySchemes, @Nullable List<SecurityRequirement> securityRequirements, @Nullable String iconUrl, List<AgentInterface> supportedInterfaces, @Nullable List<AgentCardSignature> signatures) {
        Assert.checkNotNullParam((String)"capabilities", (Object)capabilities);
        Assert.checkNotNullParam((String)"defaultInputModes", defaultInputModes);
        Assert.checkNotNullParam((String)"defaultOutputModes", defaultOutputModes);
        Assert.checkNotNullParam((String)"description", (Object)description);
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"skills", skills);
        Assert.checkNotNullParam((String)"supportedInterfaces", supportedInterfaces);
        Assert.checkNotNullParam((String)"version", (Object)version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AgentCard card) {
        return new Builder(card);
    }

    public static class Builder {
        private @Nullable String name;
        private @Nullable String description;
        private @Nullable AgentProvider provider;
        private @Nullable String version;
        private @Nullable String documentationUrl;
        private @Nullable AgentCapabilities capabilities;
        private @Nullable List<String> defaultInputModes;
        private @Nullable List<String> defaultOutputModes;
        private @Nullable List<AgentSkill> skills;
        private @Nullable Map<String, SecurityScheme> securitySchemes;
        private @Nullable List<SecurityRequirement> securityRequirements;
        private @Nullable String iconUrl;
        private @Nullable List<AgentInterface> supportedInterfaces;
        private @Nullable List<AgentCardSignature> signatures;

        private Builder() {
        }

        private Builder(AgentCard card) {
            this.name = card.name;
            this.description = card.description;
            this.provider = card.provider;
            this.version = card.version;
            this.documentationUrl = card.documentationUrl;
            this.capabilities = card.capabilities;
            this.defaultInputModes = card.defaultInputModes != null ? new ArrayList<String>(card.defaultInputModes) : Collections.emptyList();
            this.defaultOutputModes = card.defaultOutputModes != null ? new ArrayList<String>(card.defaultOutputModes) : Collections.emptyList();
            this.skills = card.skills != null ? new ArrayList<AgentSkill>(card.skills) : Collections.emptyList();
            this.securitySchemes = card.securitySchemes != null ? Map.copyOf(card.securitySchemes) : Collections.emptyMap();
            this.securityRequirements = card.securityRequirements != null ? new ArrayList<SecurityRequirement>(card.securityRequirements) : Collections.emptyList();
            this.iconUrl = card.iconUrl;
            this.supportedInterfaces = card.supportedInterfaces != null ? new ArrayList<AgentInterface>(card.supportedInterfaces) : Collections.emptyList();
            this.signatures = card.signatures != null ? new ArrayList<AgentCardSignature>(card.signatures) : null;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder provider(AgentProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public Builder capabilities(AgentCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder defaultInputModes(List<String> defaultInputModes) {
            this.defaultInputModes = defaultInputModes;
            return this;
        }

        public Builder defaultOutputModes(List<String> defaultOutputModes) {
            this.defaultOutputModes = defaultOutputModes;
            return this;
        }

        public Builder skills(List<AgentSkill> skills) {
            this.skills = skills;
            return this;
        }

        public Builder securitySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes = securitySchemes;
            return this;
        }

        public Builder securityRequirements(List<SecurityRequirement> securityRequirements) {
            this.securityRequirements = securityRequirements;
            return this;
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder supportedInterfaces(List<AgentInterface> supportedInterfaces) {
            this.supportedInterfaces = supportedInterfaces;
            return this;
        }

        public Builder signatures(List<AgentCardSignature> signatures) {
            this.signatures = signatures;
            return this;
        }

        public AgentCard build() {
            return new AgentCard((String)Assert.checkNotNullParam((String)"name", (Object)this.name), (String)Assert.checkNotNullParam((String)"description", (Object)this.description), this.provider, (String)Assert.checkNotNullParam((String)"version", (Object)this.version), this.documentationUrl, (AgentCapabilities)Assert.checkNotNullParam((String)"capabilities", (Object)this.capabilities), (List)Assert.checkNotNullParam((String)"defaultInputModes", this.defaultInputModes), (List)Assert.checkNotNullParam((String)"defaultOutputModes", this.defaultOutputModes), (List)Assert.checkNotNullParam((String)"skills", this.skills), this.securitySchemes, this.securityRequirements, this.iconUrl, (List)Assert.checkNotNullParam((String)"supportedInterfaces", this.supportedInterfaces), this.signatures);
        }
    }
}

