/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.JSONRPCRequestDeserializerBase;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.MethodNotFoundJsonMappingException;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import java.io.IOException;

public class NonStreamingJSONRPCRequestDeserializer
extends JSONRPCRequestDeserializerBase<NonStreamingJSONRPCRequest<?>> {
    public NonStreamingJSONRPCRequestDeserializer() {
        this(null);
    }

    public NonStreamingJSONRPCRequestDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public NonStreamingJSONRPCRequest<?> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String jsonrpc = this.getAndValidateJsonrpc(treeNode, jsonParser);
        String method = this.getAndValidateMethod(treeNode, jsonParser);
        Object id = this.getAndValidateId(treeNode, jsonParser);
        JsonNode paramsNode = treeNode.get("params");
        switch (method) {
            case "tasks/get": {
                return new GetTaskRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskQueryParams.class));
            }
            case "tasks/cancel": {
                return new CancelTaskRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "tasks/pushNotificationConfig/set": {
                return new SetTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskPushNotificationConfig.class));
            }
            case "tasks/pushNotificationConfig/get": {
                return new GetTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "message/send": {
                return new SendMessageRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, MessageSendParams.class));
            }
        }
        throw new MethodNotFoundJsonMappingException("Invalid method", this.getIdIfPossible(treeNode, jsonParser));
    }
}

