/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.IdJsonMappingException;
import io.a2a.spec.InvalidParamsJsonMappingException;
import io.a2a.spec.JSONRPCRequest;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.MethodNotFoundJsonMappingException;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskResubscriptionRequest;
import io.a2a.util.Utils;
import java.io.Closeable;
import java.io.IOException;

public abstract class JSONRPCRequestDeserializerBase<T>
extends StdDeserializer<JSONRPCRequest<?>> {
    public JSONRPCRequestDeserializerBase() {
        this(null);
    }

    public JSONRPCRequestDeserializerBase(Class<?> vc) {
        super(vc);
    }

    public JSONRPCRequest<?> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String jsonrpc = this.getAndValidateJsonrpc(treeNode, jsonParser);
        String method = this.getAndValidateMethod(treeNode, jsonParser);
        Object id = this.getAndValidateId(treeNode, jsonParser);
        JsonNode paramsNode = treeNode.get("params");
        switch (method) {
            case "tasks/get": {
                return new GetTaskRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskQueryParams.class));
            }
            case "tasks/cancel": {
                return new CancelTaskRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "tasks/pushNotificationConfig/set": {
                return new SetTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskPushNotificationConfig.class));
            }
            case "tasks/pushNotificationConfig/get": {
                return new GetTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "message/send": {
                return new SendMessageRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, MessageSendParams.class));
            }
            case "tasks/resubscribe": {
                return new TaskResubscriptionRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "message/stream": {
                return new SendStreamingMessageRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, MessageSendParams.class));
            }
        }
        throw new MethodNotFoundJsonMappingException("Invalid method", this.getIdIfPossible(treeNode, jsonParser));
    }

    protected <T> T getAndValidateParams(JsonNode paramsNode, JsonParser jsonParser, JsonNode node, Class<T> paramsType) throws JsonMappingException {
        if (paramsNode == null) {
            return null;
        }
        try {
            return (T)Utils.OBJECT_MAPPER.treeToValue((TreeNode)paramsNode, paramsType);
        }
        catch (JsonProcessingException e) {
            throw new InvalidParamsJsonMappingException("Invalid params", e, this.getIdIfPossible(node, jsonParser));
        }
    }

    protected String getAndValidateJsonrpc(JsonNode treeNode, JsonParser jsonParser) throws JsonMappingException {
        JsonNode jsonrpcNode = treeNode.get("jsonrpc");
        if (jsonrpcNode == null || !jsonrpcNode.asText().equals("2.0")) {
            throw new IdJsonMappingException("Invalid JSON-RPC protocol version", this.getIdIfPossible(treeNode, jsonParser));
        }
        return jsonrpcNode.asText();
    }

    protected String getAndValidateMethod(JsonNode treeNode, JsonParser jsonParser) throws JsonMappingException {
        JsonNode methodNode = treeNode.get("method");
        if (methodNode == null) {
            throw new IdJsonMappingException("Missing method", this.getIdIfPossible(treeNode, jsonParser));
        }
        String method = methodNode.asText();
        if (!JSONRPCRequestDeserializerBase.isValidMethodName(method)) {
            throw new MethodNotFoundJsonMappingException("Invalid method", this.getIdIfPossible(treeNode, jsonParser));
        }
        return method;
    }

    protected Object getAndValidateId(JsonNode treeNode, JsonParser jsonParser) throws JsonProcessingException {
        JsonNode idNode = treeNode.get("id");
        Object id = null;
        if (idNode != null) {
            if (idNode.isTextual()) {
                id = Utils.OBJECT_MAPPER.treeToValue((TreeNode)idNode, String.class);
            } else if (idNode.isNumber()) {
                id = Utils.OBJECT_MAPPER.treeToValue((TreeNode)idNode, Integer.class);
            } else {
                throw new JsonMappingException((Closeable)jsonParser, "Invalid id");
            }
        }
        return id;
    }

    protected Object getIdIfPossible(JsonNode treeNode, JsonParser jsonParser) {
        try {
            return this.getAndValidateId(treeNode, jsonParser);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    protected static boolean isValidMethodName(String methodName) {
        return methodName != null && (methodName.equals("tasks/cancel") || methodName.equals("tasks/get") || methodName.equals("tasks/pushNotificationConfig/get") || methodName.equals("tasks/pushNotificationConfig/set") || methodName.equals("tasks/resubscribe") || methodName.equals("message/send") || methodName.equals("message/stream"));
    }
}

