/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

public class ResourceNameParser {
    public static String extractTaskId(String resourceName) {
        return resourceName.substring(resourceName.lastIndexOf(47) + 1);
    }

    public static String defineTaskName(String taskId) {
        return "tasks/" + taskId;
    }

    public static String[] parseTaskPushNotificationConfigName(String resourceName) {
        String[] parts = resourceName.split("/");
        if (parts.length < 4) {
            throw new IllegalArgumentException("Invalid name format for TaskPushNotificationConfig: " + resourceName);
        }
        return new String[]{parts[1], parts[3]};
    }

    public static String[] parseGetTaskPushNotificationConfigName(String resourceName) {
        String configId;
        String[] parts = resourceName.split("/");
        String taskId = parts[1];
        if (parts.length == 2) {
            configId = taskId;
        } else {
            if (parts.length < 4) {
                throw new IllegalArgumentException("Invalid name format for GetTaskPushNotificationConfigRequest: " + resourceName);
            }
            configId = parts[3];
        }
        return new String[]{taskId, configId};
    }

    public static String defineGetTaskPushNotificationConfigName(String taskId, String configId) {
        String name = "tasks/" + taskId;
        if (configId != null && !configId.isBlank()) {
            name = name + "/pushNotificationConfigs/" + configId;
        }
        return name;
    }

    public static String defineTaskPushNotificationConfigName(String taskId, String configId) {
        return "tasks/" + taskId + "/pushNotificationConfigs/" + configId;
    }

    public static String extractParentId(String parentName) {
        return parentName.substring(parentName.lastIndexOf(47) + 1);
    }
}

