/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.Message;
import io.a2a.grpc.Part;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.MessageMapper;
import io.a2a.grpc.mapper.PartMapper;
import io.a2a.grpc.mapper.RoleMapper;
import io.a2a.spec.Message;
import java.util.List;

public class MessageMapperImpl
implements MessageMapper {
    private final RoleMapper roleMapper = RoleMapper.INSTANCE;
    private final PartMapper partMapper = PartMapper.INSTANCE;
    private final A2ACommonFieldMapper a2ACommonFieldMapper = A2ACommonFieldMapper.INSTANCE;

    @Override
    public Message toProto(io.a2a.spec.Message domain) {
        if (domain == null) {
            return null;
        }
        Message.Builder message = Message.newBuilder();
        if (domain.messageId() != null) {
            message.setMessageId(domain.messageId());
        }
        if (domain.contextId() != null) {
            message.setContextId(domain.contextId());
        }
        if (domain.taskId() != null) {
            message.setTaskId(domain.taskId());
        }
        message.setMetadata(this.a2ACommonFieldMapper.metadataToProto(domain.metadata()));
        message.setRole(this.roleMapper.toProto(domain.role()));
        if (domain.parts() != null) {
            for (io.a2a.spec.Part part : domain.parts()) {
                message.addParts(this.partMapper.toProto(part));
            }
        }
        if (domain.extensions() != null) {
            for (String extension : domain.extensions()) {
                message.addExtensions(extension);
            }
        }
        if (domain.referenceTaskIds() != null) {
            for (String referenceTaskId : domain.referenceTaskIds()) {
                message.addReferenceTaskIds(referenceTaskId);
            }
        }
        return message.build();
    }

    @Override
    public io.a2a.spec.Message fromProto(Message proto) {
        if (proto == null) {
            return null;
        }
        Message.Builder message = io.a2a.spec.Message.builder();
        message.messageId(this.a2ACommonFieldMapper.requireNonEmpty(proto.getMessageId()));
        message.contextId(this.a2ACommonFieldMapper.emptyToNull(proto.getContextId()));
        message.taskId(this.a2ACommonFieldMapper.emptyToNull(proto.getTaskId()));
        if (proto.hasMetadata()) {
            message.metadata(this.a2ACommonFieldMapper.metadataFromProto(proto.getMetadata()));
        }
        message.role(this.roleMapper.fromProto(proto.getRole()));
        message.parts(this.partListToPartArray(proto.getPartsList()));
        message.extensions(A2ACommonFieldMapper.INSTANCE.emptyListToNull(proto.getExtensionsList()));
        message.referenceTaskIds(A2ACommonFieldMapper.INSTANCE.emptyListToNull(proto.getReferenceTaskIdsList()));
        return message.build();
    }

    protected io.a2a.spec.Part[] partListToPartArray(List<Part> list) {
        if (list == null) {
            return null;
        }
        io.a2a.spec.Part[] partTmp = new io.a2a.spec.Part[list.size()];
        int i = 0;
        for (Part part : list) {
            partTmp[i] = this.partMapper.fromProto(part);
            ++i;
        }
        return partTmp;
    }
}

