/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.AgentCapabilities;
import io.a2a.grpc.AgentExtension;
import io.a2a.grpc.mapper.AgentCapabilitiesMapper;
import io.a2a.grpc.mapper.AgentExtensionMapper;
import io.a2a.spec.AgentCapabilities;
import java.util.ArrayList;
import java.util.List;

public class AgentCapabilitiesMapperImpl
implements AgentCapabilitiesMapper {
    private final AgentExtensionMapper agentExtensionMapper = AgentExtensionMapper.INSTANCE;

    @Override
    public AgentCapabilities toProto(io.a2a.spec.AgentCapabilities domain) {
        if (domain == null) {
            return null;
        }
        AgentCapabilities.Builder agentCapabilities = AgentCapabilities.newBuilder();
        agentCapabilities.setStreaming(domain.streaming());
        agentCapabilities.setPushNotifications(domain.pushNotifications());
        agentCapabilities.setStateTransitionHistory(domain.stateTransitionHistory());
        if (domain.extensions() != null) {
            for (io.a2a.spec.AgentExtension extension : domain.extensions()) {
                agentCapabilities.addExtensions(this.agentExtensionMapper.toProto(extension));
            }
        }
        return agentCapabilities.build();
    }

    @Override
    public io.a2a.spec.AgentCapabilities fromProto(AgentCapabilities proto) {
        if (proto == null) {
            return null;
        }
        AgentCapabilities.Builder agentCapabilities = io.a2a.spec.AgentCapabilities.builder();
        if (proto.hasStreaming()) {
            agentCapabilities.streaming(proto.getStreaming());
        }
        if (proto.hasPushNotifications()) {
            agentCapabilities.pushNotifications(proto.getPushNotifications());
        }
        if (proto.hasStateTransitionHistory()) {
            agentCapabilities.stateTransitionHistory(proto.getStateTransitionHistory());
        }
        agentCapabilities.extensions(this.agentExtensionListToAgentExtensionList(proto.getExtensionsList()));
        return agentCapabilities.build();
    }

    protected List<io.a2a.spec.AgentExtension> agentExtensionListToAgentExtensionList(List<AgentExtension> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.a2a.spec.AgentExtension> list1 = new ArrayList<io.a2a.spec.AgentExtension>(list.size());
        for (AgentExtension agentExtension : list) {
            list1.add(this.agentExtensionMapper.fromProto(agentExtension));
        }
        return list1;
    }
}

