/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.extensions;

import io.a2a.server.ServerCallContext;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentExtension;
import io.a2a.spec.ExtensionSupportRequiredError;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class A2AExtensions {
    public static Set<String> getRequestedExtensions(List<String> values) {
        HashSet<String> extensions = new HashSet<String>();
        if (values == null) {
            return extensions;
        }
        for (String value : values) {
            String[] parts;
            if (value == null) continue;
            for (String part : parts = value.split(",")) {
                String trimmed = part.trim();
                if (trimmed.isEmpty()) continue;
                extensions.add(trimmed);
            }
        }
        return extensions;
    }

    public static @Nullable AgentExtension findExtensionByUri(AgentCard card, String uri) {
        if (card.capabilities() == null || card.capabilities().extensions() == null) {
            return null;
        }
        for (AgentExtension extension : card.capabilities().extensions()) {
            if (!extension.uri().equals(uri)) continue;
            return extension;
        }
        return null;
    }

    public static void validateRequiredExtensions(AgentCard agentCard, ServerCallContext context) throws ExtensionSupportRequiredError {
        if (agentCard.capabilities() == null || agentCard.capabilities().extensions() == null) {
            return;
        }
        for (AgentExtension extension : agentCard.capabilities().extensions()) {
            if (!extension.required() || context.isExtensionRequested(extension.uri())) continue;
            throw new ExtensionSupportRequiredError(null, "Required extension '" + extension.uri() + "' was not requested by the client", null);
        }
    }
}

