/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.requesthandlers;

import io.a2a.server.PublicAgentCard;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.server.util.async.AsyncUtils;
import io.a2a.spec.AgentCard;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.CancelTaskResponse;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskPushNotificationConfigResponse;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.GetTaskResponse;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendMessageResponse;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.SendStreamingMessageResponse;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.SetTaskPushNotificationConfigResponse;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskResubscriptionRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.concurrent.Flow;
import mutiny.zero.TubeConfiguration;
import mutiny.zero.ZeroPublisher;

@ApplicationScoped
public class JSONRPCHandler {
    private AgentCard agentCard;
    private RequestHandler requestHandler;

    protected JSONRPCHandler() {
    }

    @Inject
    public JSONRPCHandler(@PublicAgentCard AgentCard agentCard, RequestHandler requestHandler) {
        this.agentCard = agentCard;
        this.requestHandler = requestHandler;
    }

    public SendMessageResponse onMessageSend(SendMessageRequest request) {
        try {
            EventKind taskOrMessage = this.requestHandler.onMessageSend((MessageSendParams)request.getParams());
            return new SendMessageResponse(request.getId(), taskOrMessage);
        }
        catch (JSONRPCError e) {
            return new SendMessageResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new SendMessageResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public Flow.Publisher<SendStreamingMessageResponse> onMessageSendStream(SendStreamingMessageRequest request) {
        if (!this.agentCard.capabilities().streaming()) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InvalidRequestError("Streaming is not supported by the agent"))});
        }
        try {
            Flow.Publisher<StreamingEventKind> publisher = this.requestHandler.onMessageSendStream((MessageSendParams)request.getParams());
            return this.convertToSendStreamingMessageResponse(request.getId(), publisher);
        }
        catch (JSONRPCError e) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), e)});
        }
        catch (Throwable throwable) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InternalError(throwable.getMessage()))});
        }
    }

    public CancelTaskResponse onCancelTask(CancelTaskRequest request) {
        try {
            Task task = this.requestHandler.onCancelTask((TaskIdParams)request.getParams());
            if (task != null) {
                return new CancelTaskResponse(request.getId(), task);
            }
            return new CancelTaskResponse(request.getId(), (JSONRPCError)new TaskNotFoundError());
        }
        catch (JSONRPCError e) {
            return new CancelTaskResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new CancelTaskResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public Flow.Publisher<SendStreamingMessageResponse> onResubscribeToTask(TaskResubscriptionRequest request) {
        if (!this.agentCard.capabilities().streaming()) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InvalidRequestError("Streaming is not supported by the agent"))});
        }
        try {
            Flow.Publisher<StreamingEventKind> publisher = this.requestHandler.onResubscribeToTask((TaskIdParams)request.getParams());
            return this.convertToSendStreamingMessageResponse(request.getId(), publisher);
        }
        catch (JSONRPCError e) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), e)});
        }
        catch (Throwable throwable) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InternalError(throwable.getMessage()))});
        }
    }

    public GetTaskPushNotificationConfigResponse getPushNotification(GetTaskPushNotificationConfigRequest request) {
        try {
            TaskPushNotificationConfig config = this.requestHandler.onGetTaskPushNotificationConfig((TaskIdParams)request.getParams());
            return new GetTaskPushNotificationConfigResponse(request.getId(), config);
        }
        catch (JSONRPCError e) {
            return new GetTaskPushNotificationConfigResponse((Object)request.getId().toString(), e);
        }
        catch (Throwable t) {
            return new GetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public SetTaskPushNotificationConfigResponse setPushNotification(SetTaskPushNotificationConfigRequest request) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InvalidRequestError("Push notifications are not supported by the agent"));
        }
        try {
            TaskPushNotificationConfig config = this.requestHandler.onSetTaskPushNotificationConfig((TaskPushNotificationConfig)request.getParams());
            return new SetTaskPushNotificationConfigResponse((Object)request.getId().toString(), config);
        }
        catch (JSONRPCError e) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public GetTaskResponse onGetTask(GetTaskRequest request) {
        try {
            Task task = this.requestHandler.onGetTask((TaskQueryParams)request.getParams());
            return new GetTaskResponse(request.getId(), task);
        }
        catch (JSONRPCError e) {
            return new GetTaskResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new GetTaskResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public AgentCard getAgentCard() {
        return this.agentCard;
    }

    private Flow.Publisher<SendStreamingMessageResponse> convertToSendStreamingMessageResponse(final Object requestId, Flow.Publisher<StreamingEventKind> publisher) {
        return ZeroPublisher.create((TubeConfiguration)AsyncUtils.createTubeConfig(), tube -> publisher.subscribe(new Flow.Subscriber<StreamingEventKind>(){
            Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(StreamingEventKind item) {
                tube.send((Object)new SendStreamingMessageResponse(requestId, item));
                this.subscription.request(1L);
            }

            @Override
            public void onError(Throwable throwable) {
                if (throwable instanceof JSONRPCError) {
                    JSONRPCError jsonrpcError = (JSONRPCError)throwable;
                    tube.send((Object)new SendStreamingMessageResponse(requestId, jsonrpcError));
                } else {
                    tube.send((Object)new SendStreamingMessageResponse(requestId, (JSONRPCError)new InternalError(throwable.getMessage())));
                }
                this.onComplete();
            }

            @Override
            public void onComplete() {
                tube.complete();
            }
        }));
    }
}

