/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.rest.quarkus;

import io.a2a.server.ServerCallContext;
import io.a2a.server.auth.UnauthenticatedUser;
import io.a2a.server.auth.User;
import io.a2a.server.extensions.A2AExtensions;
import io.a2a.server.rest.quarkus.CallContextFactory;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.A2AError;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.transport.rest.handler.RestHandler;
import io.a2a.util.Utils;
import io.quarkus.security.Authenticated;
import io.quarkus.vertx.web.Body;
import io.quarkus.vertx.web.ReactiveRoutes;
import io.quarkus.vertx.web.Route;
import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.security.PermitAll;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

@Singleton
@Authenticated
public class A2AServerRoutes {
    private static final String HISTORY_LENGTH_PARAM = "historyLength";
    private static final String PAGE_SIZE_PARAM = "pageSize";
    private static final String PAGE_TOKEN_PARAM = "pageToken";
    @Inject
    RestHandler jsonRestHandler;
    private static volatile @Nullable Runnable streamingMultiSseSupportSubscribedRunnable;
    @Inject
    @Internal
    Executor executor;
    @Inject
    Instance<CallContextFactory> callContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)message:send$", order=1, methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void sendMessage(@Body String body, RoutingContext rc) {
        ServerCallContext context = this.createCallContext(rc, "SendMessage");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = this.jsonRestHandler.sendMessage(body, this.extractTenant(rc), context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)message:stream$", order=1, methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void sendMessageStreaming(@Body String body, RoutingContext rc) {
        ServerCallContext context = this.createCallContext(rc, "SendStreamingMessage");
        RestHandler.HTTPRestStreamingResponse streamingResponse = null;
        RestHandler.HTTPRestResponse error = null;
        try {
            RestHandler.HTTPRestResponse response = this.jsonRestHandler.sendStreamingMessage(body, this.extractTenant(rc), context);
            if (response instanceof RestHandler.HTTPRestStreamingResponse) {
                RestHandler.HTTPRestStreamingResponse hTTPRestStreamingResponse;
                streamingResponse = hTTPRestStreamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
            } else {
                error = response;
            }
            if (error != null) {
                this.sendResponse(rc, error);
                return;
            }
            if (streamingResponse == null) return;
        }
        catch (Throwable throwable) {
            if (error != null) {
                this.sendResponse(rc, error);
                throw throwable;
            } else {
                if (streamingResponse == null) throw throwable;
                Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
                this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
            }
            throw throwable;
        }
        Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
        this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
    }

    /*
     * Exception decompiling
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\??", order=0, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void listTasks(RoutingContext rc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^:^/]+)$", order=1, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void getTask(RoutingContext rc) {
        RestHandler.HTTPRestResponse response;
        block8: {
            String taskId = rc.pathParam("taskId");
            ServerCallContext context = this.createCallContext(rc, "GetTask");
            response = null;
            try {
                if (taskId == null || taskId.isEmpty()) {
                    response = this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id"));
                    break block8;
                }
                Integer historyLength = null;
                if (rc.request().params().contains(HISTORY_LENGTH_PARAM)) {
                    historyLength = Integer.valueOf(rc.request().params().get(HISTORY_LENGTH_PARAM));
                }
                response = this.jsonRestHandler.getTask(taskId, historyLength, this.extractTenant(rc), context);
            }
            catch (NumberFormatException e) {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad historyLength"));
                this.sendResponse(rc, response);
            }
            catch (Throwable t) {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
                {
                    catch (Throwable throwable) {
                        this.sendResponse(rc, response);
                        throw throwable;
                    }
                }
            }
        }
        this.sendResponse(rc, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+):cancel$", order=1, methods={Route.HttpMethod.POST}, type=Route.HandlerType.BLOCKING)
    public void cancelTask(RoutingContext rc) {
        String taskId = rc.pathParam("taskId");
        ServerCallContext context = this.createCallContext(rc, "CancelTask");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.cancelTask(taskId, this.extractTenant(rc), context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                if (t instanceof A2AError) {
                    A2AError error = (A2AError)t;
                    response = this.jsonRestHandler.createErrorResponse(error);
                } else {
                    response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                }
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    private void sendResponse(RoutingContext rc, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable RestHandler.HTTPRestResponse response) {
        if (response != null) {
            rc.response().setStatusCode(response.getStatusCode()).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)response.getContentType()).end(response.getBody());
        } else {
            rc.response().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+):subscribe$", order=1, methods={Route.HttpMethod.POST}, type=Route.HandlerType.BLOCKING)
    public void subscribeToTask(RoutingContext rc) {
        String taskId = rc.pathParam("taskId");
        ServerCallContext context = this.createCallContext(rc, "SubscribeToTask");
        RestHandler.HTTPRestStreamingResponse streamingResponse = null;
        RestHandler.HTTPRestResponse error = null;
        try {
            if (taskId == null || taskId.isEmpty()) {
                error = this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id"));
            } else {
                RestHandler.HTTPRestResponse response = this.jsonRestHandler.subscribeToTask(taskId, this.extractTenant(rc), context);
                if (response instanceof RestHandler.HTTPRestStreamingResponse) {
                    RestHandler.HTTPRestStreamingResponse hTTPRestStreamingResponse;
                    streamingResponse = hTTPRestStreamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
                } else {
                    error = response;
                }
            }
            if (error != null) {
                this.sendResponse(rc, error);
                return;
            }
            if (streamingResponse == null) return;
        }
        catch (Throwable throwable) {
            if (error != null) {
                this.sendResponse(rc, error);
                throw throwable;
            } else {
                if (streamingResponse == null) throw throwable;
                Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
                this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
            }
            throw throwable;
        }
        Multi events = Multi.createFrom().publisher(streamingResponse.getPublisher());
        this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)events.map(i -> i), rc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+)\\/pushNotificationConfigs$", order=1, methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void setTaskPushNotificationConfiguration(@Body String body, RoutingContext rc) {
        String taskId = rc.pathParam("taskId");
        ServerCallContext context = this.createCallContext(rc, "SetTaskPushNotificationConfig");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.setTaskPushNotificationConfiguration(taskId, body, this.extractTenant(rc), context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+)\\/pushNotificationConfigs\\/(?<configId>[^\\/]+)", order=2, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void getTaskPushNotificationConfiguration(RoutingContext rc) {
        String taskId = rc.pathParam("taskId");
        String configId = rc.pathParam("configId");
        ServerCallContext context = this.createCallContext(rc, "GetTaskPushNotificationConfig");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.getTaskPushNotificationConfiguration(taskId, configId, this.extractTenant(rc), context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+)\\/pushNotificationConfigs\\/$", order=1, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void getTaskPushNotificationConfigurationWithoutId(RoutingContext rc) {
        String taskId = rc.pathParam("taskId");
        ServerCallContext context = this.createCallContext(rc, "GetTaskPushNotificationConfig");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id")) : this.jsonRestHandler.getTaskPushNotificationConfiguration(taskId, null, this.extractTenant(rc), context);
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+)\\/pushNotificationConfigs", order=3, methods={Route.HttpMethod.GET}, type=Route.HandlerType.BLOCKING)
    public void listTaskPushNotificationConfigurations(RoutingContext rc) {
        RestHandler.HTTPRestResponse response;
        block9: {
            String taskId = rc.pathParam("taskId");
            ServerCallContext context = this.createCallContext(rc, "ListTaskPushNotificationConfig");
            response = null;
            try {
                if (taskId == null || taskId.isEmpty()) {
                    response = this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id"));
                    break block9;
                }
                int pageSize = 0;
                if (rc.request().params().contains(PAGE_SIZE_PARAM)) {
                    pageSize = Integer.parseInt(rc.request().params().get(PAGE_SIZE_PARAM));
                }
                String pageToken = "";
                if (rc.request().params().contains(PAGE_TOKEN_PARAM)) {
                    pageToken = (String)Utils.defaultIfNull((Object)rc.request().params().get(PAGE_TOKEN_PARAM), (Object)"");
                }
                response = this.jsonRestHandler.listTaskPushNotificationConfigurations(taskId, pageSize, pageToken, this.extractTenant(rc), context);
            }
            catch (NumberFormatException e) {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad pageSize"));
                this.sendResponse(rc, response);
            }
            catch (Throwable t) {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
                {
                    catch (Throwable throwable) {
                        this.sendResponse(rc, response);
                        throw throwable;
                    }
                }
            }
        }
        this.sendResponse(rc, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)tasks\\/(?<taskId>[^/]+)\\/pushNotificationConfigs\\/(?<configId>[^/]+)", order=1, methods={Route.HttpMethod.DELETE}, type=Route.HandlerType.BLOCKING)
    public void deleteTaskPushNotificationConfiguration(RoutingContext rc) {
        String taskId = rc.pathParam("taskId");
        String configId = rc.pathParam("configId");
        ServerCallContext context = this.createCallContext(rc, "DeleteTaskPushNotificationConfig");
        RestHandler.HTTPRestResponse response = null;
        try {
            response = taskId == null || taskId.isEmpty() ? this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad task id")) : (configId == null || configId.isEmpty() ? this.jsonRestHandler.createErrorResponse((A2AError)new InvalidParamsError("bad config id")) : this.jsonRestHandler.deleteTaskPushNotificationConfiguration(taskId, configId, this.extractTenant(rc), context));
            this.sendResponse(rc, response);
        }
        catch (Throwable t) {
            try {
                response = this.jsonRestHandler.createErrorResponse((A2AError)new InternalError(t.getMessage()));
                this.sendResponse(rc, response);
            }
            catch (Throwable throwable) {
                this.sendResponse(rc, response);
                throw throwable;
            }
        }
    }

    private String extractTenant(RoutingContext rc) {
        String tenantPath = rc.pathParam("tenant");
        if (tenantPath == null || tenantPath.isBlank()) {
            return "";
        }
        if (tenantPath.startsWith("/")) {
            tenantPath = tenantPath.substring(1);
        }
        if (tenantPath.endsWith("/")) {
            tenantPath = tenantPath.substring(0, tenantPath.length() - 1);
        }
        return tenantPath;
    }

    @Route(path="/.well-known/agent-card.json", order=1, methods={Route.HttpMethod.GET}, produces={"application/json"})
    @PermitAll
    public void getAgentCard(RoutingContext rc) {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.getAgentCard();
        this.sendResponse(rc, response);
    }

    @Route(regex="^\\/(?<tenant>[^\\/]*\\/?)extendedAgentCard$", order=1, methods={Route.HttpMethod.GET}, produces={"application/json"})
    public void getExtendedAgentCard(RoutingContext rc) {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.getExtendedAgentCard(this.extractTenant(rc));
        this.sendResponse(rc, response);
    }

    @Route(path="^/.*", order=100, methods={Route.HttpMethod.DELETE, Route.HttpMethod.GET, Route.HttpMethod.HEAD, Route.HttpMethod.OPTIONS, Route.HttpMethod.POST, Route.HttpMethod.PUT}, produces={"application/json"})
    public void methodNotFoundMessage(RoutingContext rc) {
        RestHandler.HTTPRestResponse response = this.jsonRestHandler.createErrorResponse((A2AError)new MethodNotFoundError());
        this.sendResponse(rc, response);
    }

    static void setStreamingMultiSseSupportSubscribedRunnable(Runnable runnable) {
        streamingMultiSseSupportSubscribedRunnable = runnable;
    }

    private ServerCallContext createCallContext(final RoutingContext rc, String jsonRpcMethodName) {
        if (this.callContextFactory.isUnsatisfied()) {
            Object user = rc.user() == null ? UnauthenticatedUser.INSTANCE : new User(){

                public boolean isAuthenticated() {
                    if (rc.userContext() != null) {
                        return rc.userContext().authenticated();
                    }
                    return false;
                }

                public String getUsername() {
                    if (rc.user() != null && rc.user().subject() != null) {
                        return rc.user().subject();
                    }
                    return "";
                }
            };
            HashMap<String, Object> state = new HashMap<String, Object>();
            HashMap headers = new HashMap();
            Set headerNames = rc.request().headers().names();
            headerNames.forEach(name -> headers.put(name, rc.request().getHeader(name)));
            state.put("headers", headers);
            state.put("method", jsonRpcMethodName);
            String requestedVersion = rc.request().getHeader("X-A2A-Version");
            List extensionHeaderValues = rc.request().headers().getAll("X-A2A-Extensions");
            Set requestedExtensions = A2AExtensions.getRequestedExtensions((List)extensionHeaderValues);
            return new ServerCallContext((User)user, state, requestedExtensions, requestedVersion);
        }
        CallContextFactory builder = (CallContextFactory)this.callContextFactory.get();
        return builder.build(rc);
    }

    private static class MultiSseSupport {
        private MultiSseSupport() {
        }

        private static void initialize(HttpServerResponse response) {
            if (response.bytesWritten() == 0L) {
                MultiMap headers = response.headers();
                if (headers.get(HttpHeaders.CONTENT_TYPE) == null) {
                    headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                }
                response.setChunked(true);
            }
        }

        private static void onWriteDone( @Nullable Flow.Subscription subscription, AsyncResult<Void> ar, RoutingContext rc) {
            if (ar.failed()) {
                rc.fail(ar.cause());
            } else if (subscription != null) {
                subscription.request(1L);
            }
        }

        private static void write(Multi<Buffer> multi, final RoutingContext rc) {
            final HttpServerResponse response = rc.response();
            multi.subscribe().withSubscriber((Flow.Subscriber)new Flow.Subscriber<Buffer>(){
                 @Nullable Flow.Subscription upstream;

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.upstream = subscription;
                    this.upstream.request(1L);
                    Runnable runnable = streamingMultiSseSupportSubscribedRunnable;
                    if (runnable != null) {
                        runnable.run();
                    }
                }

                @Override
                public void onNext(Buffer item) {
                    MultiSseSupport.initialize(response);
                    response.write((Object)item, (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> ar) {
                            MultiSseSupport.onWriteDone(upstream, ar, rc);
                        }
                    });
                }

                @Override
                public void onError(Throwable throwable) {
                    rc.fail(throwable);
                }

                @Override
                public void onComplete() {
                    MultiSseSupport.endOfStream(response);
                }
            });
        }

        private static void subscribeObject(Multi<Object> multi, RoutingContext rc) {
            final AtomicLong count = new AtomicLong();
            MultiSseSupport.write((Multi<Buffer>)multi.map((Function)new Function<Object, Buffer>(){

                @Override
                public Buffer apply(Object o) {
                    if (o instanceof ReactiveRoutes.ServerSentEvent) {
                        ReactiveRoutes.ServerSentEvent ev = (ReactiveRoutes.ServerSentEvent)o;
                        long id = ev.id() != -1L ? ev.id() : count.getAndIncrement();
                        String e = ev.event() == null ? "" : "event: " + ev.event() + "\n";
                        return Buffer.buffer((String)(e + "data: " + String.valueOf(ev.data()) + "\nid: " + id + "\n\n"));
                    }
                    return Buffer.buffer((String)("data: " + String.valueOf(o) + "\nid: " + count.getAndIncrement() + "\n\n"));
                }
            }), rc);
        }

        private static void endOfStream(HttpServerResponse response) {
            MultiMap headers;
            if (response.bytesWritten() == 0L && (headers = response.headers()).get(HttpHeaders.CONTENT_TYPE) == null) {
                headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
            }
            response.end();
        }
    }
}

