/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.opentelemetry.it;

import io.a2a.server.events.QueueManager;
import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.Event;
import io.a2a.spec.Task;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;

@ApplicationScoped
public class TestUtilsBean {
    @Inject
    TaskStore taskStore;
    @Inject
    QueueManager queueManager;

    public void saveTask(Task task) {
        this.taskStore.save(task, false);
    }

    public Task getTask(String taskId) {
        return this.taskStore.get(taskId);
    }

    public void deleteTask(String taskId) {
        this.taskStore.delete(taskId);
    }

    public void ensureQueue(String taskId) {
        this.queueManager.createOrTap(taskId);
    }

    public void enqueueEvent(String taskId, Event event) {
        this.queueManager.get(taskId).enqueueEvent(event);
    }

    public int getChildQueueCount(String taskId) {
        return this.queueManager.getActiveChildQueueCount(taskId);
    }
}

