/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.integrations.microprofile;

import io.a2a.server.config.A2AConfigProvider;
import io.a2a.server.config.DefaultValuesConfigProvider;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=50)
public class MicroProfileConfigProvider
implements A2AConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroProfileConfigProvider.class);
    @Inject
    Config mpConfig;
    @Inject
    DefaultValuesConfigProvider defaultValues;

    public String getValue(String name) {
        Optional value = this.mpConfig.getOptionalValue(name, String.class);
        if (value.isPresent()) {
            LOGGER.trace("Config value '{}' = '{}' (from MicroProfile Config)", (Object)name, value.get());
            return (String)value.get();
        }
        String defaultValue = this.defaultValues.getValue(name);
        LOGGER.trace("Config value '{}' = '{}' (from DefaultValuesConfigProvider)", (Object)name, (Object)defaultValue);
        return defaultValue;
    }

    public Optional<String> getOptionalValue(String name) {
        Optional value = this.mpConfig.getOptionalValue(name, String.class);
        if (value.isPresent()) {
            LOGGER.trace("Optional config value '{}' = '{}' (from MicroProfile Config)", (Object)name, value.get());
            return value;
        }
        Optional defaultValue = this.defaultValues.getOptionalValue(name);
        LOGGER.trace("Optional config value '{}' = '{}' (from DefaultValuesConfigProvider)", (Object)name, (Object)defaultValue.orElse("<absent>"));
        return defaultValue;
    }
}

