/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.jsonrpc.common.wrappers;

import io.a2a.jsonrpc.common.wrappers.NonStreamingJSONRPCRequest;
import io.a2a.spec.MessageSendParams;
import java.util.UUID;

public final class SendMessageRequest
extends NonStreamingJSONRPCRequest<MessageSendParams> {
    public SendMessageRequest(String jsonrpc, Object id, MessageSendParams params) {
        super(jsonrpc, "SendMessage", id, params);
    }

    public SendMessageRequest(Object id, MessageSendParams params) {
        this("2.0", id, params);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String jsonrpc;
        private Object id;
        private MessageSendParams params;

        private Builder() {
        }

        public Builder jsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
            return this;
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder params(MessageSendParams params) {
            this.params = params;
            return this;
        }

        public SendMessageRequest build() {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            return new SendMessageRequest(this.jsonrpc, this.id, this.params);
        }
    }
}

