/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.jsonrpc.common.wrappers;

import io.a2a.spec.Task;
import io.a2a.util.Assert;
import java.util.List;
import org.jspecify.annotations.Nullable;

public record ListTasksResult(List<Task> tasks, int totalSize, int pageSize, @Nullable String nextPageToken) {
    public ListTasksResult(List<Task> tasks, int totalSize, int pageSize, @Nullable String nextPageToken) {
        Assert.checkNotNullParam((String)"tasks", tasks);
        if (totalSize < 0) {
            throw new IllegalArgumentException("totalSize must be non-negative");
        }
        if (pageSize < 0) {
            throw new IllegalArgumentException("pageSize must be non-negative");
        }
        if (pageSize != tasks.size()) {
            throw new IllegalArgumentException("pageSize must be equal to the number of tasks in the list. Got " + pageSize + ", but list has " + tasks.size() + " tasks.");
        }
        tasks = List.copyOf(tasks);
    }

    public ListTasksResult(List<Task> tasks) {
        this(tasks, tasks.size(), tasks.size(), null);
    }

    public boolean hasMoreResults() {
        return this.nextPageToken != null && !this.nextPageToken.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Task> tasks;
        private int totalSize;
        private int pageSize;
        private String nextPageToken;

        private Builder() {
        }

        public Builder tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this;
        }

        public Builder totalSize(int totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public ListTasksResult build() {
            return new ListTasksResult(this.tasks, this.totalSize, this.pageSize, this.nextPageToken);
        }
    }
}

