/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client;

import io.a2a.client.Client;
import io.a2a.client.ClientEvent;
import io.a2a.client.config.ClientConfig;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.ClientTransportConfig;
import io.a2a.client.transport.spi.ClientTransportConfigBuilder;
import io.a2a.client.transport.spi.ClientTransportProvider;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentInterface;
import io.a2a.spec.TransportProtocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ClientBuilder {
    private static final Map<String, ClientTransportProvider<? extends ClientTransport, ? extends ClientTransportConfig<?>>> transportProviderRegistry = new HashMap();
    private static final Map<Class<? extends ClientTransport>, String> transportProtocolMapping = new HashMap<Class<? extends ClientTransport>, String>();
    private final AgentCard agentCard;
    private final List<BiConsumer<ClientEvent, AgentCard>> consumers = new ArrayList<BiConsumer<ClientEvent, AgentCard>>();
    private @Nullable Consumer<Throwable> streamErrorHandler;
    private ClientConfig clientConfig = new ClientConfig.Builder().build();
    private final Map<Class<? extends ClientTransport>, ClientTransportConfig<? extends ClientTransport>> clientTransports = new LinkedHashMap<Class<? extends ClientTransport>, ClientTransportConfig<? extends ClientTransport>>();

    ClientBuilder(@NonNull AgentCard agentCard) {
        this.agentCard = agentCard;
    }

    public <T extends ClientTransport> ClientBuilder withTransport(Class<T> clazz, ClientTransportConfigBuilder<? extends ClientTransportConfig<T>, ?> configBuilder) {
        return this.withTransport(clazz, configBuilder.build());
    }

    public <T extends ClientTransport> ClientBuilder withTransport(Class<T> clazz, ClientTransportConfig<T> config) {
        this.clientTransports.put(clazz, config);
        return this;
    }

    public ClientBuilder addConsumer(BiConsumer<ClientEvent, AgentCard> consumer) {
        this.consumers.add(consumer);
        return this;
    }

    public ClientBuilder addConsumers(List<BiConsumer<ClientEvent, AgentCard>> consumers) {
        this.consumers.addAll(consumers);
        return this;
    }

    public ClientBuilder streamingErrorHandler(Consumer<Throwable> streamErrorHandler) {
        this.streamErrorHandler = streamErrorHandler;
        return this;
    }

    public ClientBuilder clientConfig(@NonNull ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    public Client build() throws A2AClientException {
        if (this.clientConfig == null) {
            this.clientConfig = new ClientConfig.Builder().build();
        }
        ClientTransport clientTransport = this.buildClientTransport();
        return new Client(this.agentCard, this.clientConfig, clientTransport, this.consumers, this.streamErrorHandler);
    }

    private ClientTransport buildClientTransport() throws A2AClientException {
        AgentInterface agentInterface = this.findBestClientTransport();
        ClientTransportProvider<? extends ClientTransport, ? extends ClientTransportConfig<?>> clientTransportProvider = transportProviderRegistry.get(agentInterface.protocolBinding());
        if (clientTransportProvider == null) {
            throw new A2AClientException("No client available for " + agentInterface.protocolBinding());
        }
        Class transportProtocolClass = clientTransportProvider.getTransportProtocolClass();
        ClientTransportConfig<? extends ClientTransport> clientTransportConfig = this.clientTransports.get(transportProtocolClass);
        if (clientTransportConfig == null) {
            throw new A2AClientException("Missing required TransportConfig for " + agentInterface.protocolBinding());
        }
        return clientTransportProvider.create(clientTransportConfig, this.agentCard, agentInterface);
    }

    private Map<String, String> getServerPreferredTransports() throws A2AClientException {
        LinkedHashMap<String, String> serverPreferredTransports = new LinkedHashMap<String, String>();
        if (this.agentCard.supportedInterfaces() == null || this.agentCard.supportedInterfaces().isEmpty()) {
            throw new A2AClientException("No server interface available in the AgentCard");
        }
        for (AgentInterface agentInterface : this.agentCard.supportedInterfaces()) {
            serverPreferredTransports.putIfAbsent(agentInterface.protocolBinding(), agentInterface.url());
        }
        return serverPreferredTransports;
    }

    private List<String> getClientPreferredTransports() {
        ArrayList<String> supportedClientTransports = new ArrayList<String>();
        if (this.clientTransports.isEmpty()) {
            supportedClientTransports.add(TransportProtocol.JSONRPC.asString());
        } else {
            this.clientTransports.forEach((aClass, clientTransportConfig) -> supportedClientTransports.add(transportProtocolMapping.get(aClass)));
        }
        return supportedClientTransports;
    }

    private AgentInterface findBestClientTransport() throws A2AClientException {
        Map<String, String> serverPreferredTransports = this.getServerPreferredTransports();
        List<String> clientPreferredTransports = this.getClientPreferredTransports();
        String transportProtocol = null;
        String transportUrl = null;
        if (this.clientConfig.isUseClientPreference()) {
            for (String clientPreferredTransport : clientPreferredTransports) {
                if (!serverPreferredTransports.containsKey(clientPreferredTransport)) continue;
                transportProtocol = clientPreferredTransport;
                transportUrl = serverPreferredTransports.get(transportProtocol);
                break;
            }
        } else {
            for (Map.Entry<String, String> transport : serverPreferredTransports.entrySet()) {
                if (!clientPreferredTransports.contains(transport.getKey())) continue;
                transportProtocol = transport.getKey();
                transportUrl = transport.getValue();
                break;
            }
        }
        if (transportProtocol == null || transportUrl == null) {
            throw new A2AClientException("No compatible transport found");
        }
        if (!transportProviderRegistry.containsKey(transportProtocol)) {
            throw new A2AClientException("No client available for " + transportProtocol);
        }
        return new AgentInterface(transportProtocol, transportUrl);
    }

    static {
        ServiceLoader<ClientTransportProvider> loader = ServiceLoader.load(ClientTransportProvider.class);
        for (ClientTransportProvider transport : loader) {
            transportProviderRegistry.put(transport.getTransportProtocol(), transport);
            transportProtocolMapping.put(transport.getTransportProtocolClass(), transport.getTransportProtocol());
        }
    }
}

