/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.grpc;

import io.a2a.client.transport.grpc.EventStreamObserver;
import io.a2a.client.transport.grpc.GrpcErrorMapper;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import io.a2a.grpc.A2AServiceGrpc;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.MessageOrBuilder;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.TaskOrBuilder;
import io.a2a.grpc.TaskPushNotificationConfigOrBuilder;
import io.a2a.grpc.TaskSubscriptionRequest;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.util.Assert;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class GrpcTransport
implements ClientTransport {
    private static final Metadata.Key<String> AUTHORIZATION_METADATA_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> EXTENSIONS_KEY = Metadata.Key.of((String)"X-A2A-Extensions", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final A2AServiceGrpc.A2AServiceBlockingV2Stub blockingStub;
    private final A2AServiceGrpc.A2AServiceStub asyncStub;
    private final @Nullable List<ClientCallInterceptor> interceptors;
    private AgentCard agentCard;

    public GrpcTransport(Channel channel, AgentCard agentCard) {
        this(channel, agentCard, null);
    }

    public GrpcTransport(Channel channel, AgentCard agentCard, @Nullable List<ClientCallInterceptor> interceptors) {
        Assert.checkNotNullParam((String)"channel", (Object)channel);
        Assert.checkNotNullParam((String)"agentCard", (Object)agentCard);
        this.asyncStub = A2AServiceGrpc.newStub((Channel)channel);
        this.blockingStub = A2AServiceGrpc.newBlockingV2Stub((Channel)channel);
        this.agentCard = agentCard;
        this.interceptors = interceptors;
    }

    public EventKind sendMessage(MessageSendParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        SendMessageRequest sendMessageRequest = this.createGrpcSendMessageRequest(request, context);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("message/send", sendMessageRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            SendMessageResponse response = stubWithMetadata.sendMessage(sendMessageRequest);
            if (response.hasMsg()) {
                return ProtoUtils.FromProto.message((MessageOrBuilder)response.getMsg());
            }
            if (response.hasTask()) {
                return ProtoUtils.FromProto.task((TaskOrBuilder)response.getTask());
            }
            throw new A2AClientException("Server response did not contain a message or task");
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to send message: ");
        }
    }

    public void sendMessageStreaming(MessageSendParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        SendMessageRequest grpcRequest = this.createGrpcSendMessageRequest(request, context);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("message/stream", grpcRequest, this.agentCard, context);
        EventStreamObserver streamObserver = new EventStreamObserver(eventConsumer, errorConsumer);
        try {
            A2AServiceGrpc.A2AServiceStub stubWithMetadata = this.createAsyncStubWithMetadata(context, payloadAndHeaders);
            stubWithMetadata.sendStreamingMessage(grpcRequest, (StreamObserver)streamObserver);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to send streaming message request: ");
        }
    }

    public Task getTask(TaskQueryParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskRequest.Builder requestBuilder = GetTaskRequest.newBuilder();
        requestBuilder.setName("tasks/" + request.id());
        requestBuilder.setHistoryLength(request.historyLength());
        GetTaskRequest getTaskRequest = requestBuilder.build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/get", getTaskRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.task((TaskOrBuilder)stubWithMetadata.getTask(getTaskRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get task: ");
        }
    }

    public Task cancelTask(TaskIdParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        CancelTaskRequest cancelTaskRequest = CancelTaskRequest.newBuilder().setName("tasks/" + request.id()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/cancel", cancelTaskRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.task((TaskOrBuilder)stubWithMetadata.cancelTask(cancelTaskRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to cancel task: ");
        }
    }

    public TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        String configId = request.pushNotificationConfig().id();
        CreateTaskPushNotificationConfigRequest grpcRequest = CreateTaskPushNotificationConfigRequest.newBuilder().setParent("tasks/" + request.taskId()).setConfig(ProtoUtils.ToProto.taskPushNotificationConfig((TaskPushNotificationConfig)request)).setConfigId(configId != null ? configId : request.taskId()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/set", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)stubWithMetadata.createTaskPushNotificationConfig(grpcRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to create task push notification config: ");
        }
    }

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskPushNotificationConfigRequest grpcRequest = GetTaskPushNotificationConfigRequest.newBuilder().setName(this.getTaskPushNotificationConfigName(request)).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/get", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)stubWithMetadata.getTaskPushNotificationConfig(grpcRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get task push notification config: ");
        }
    }

    public List<TaskPushNotificationConfig> listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTaskPushNotificationConfigRequest grpcRequest = ListTaskPushNotificationConfigRequest.newBuilder().setParent("tasks/" + request.id()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/list", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return stubWithMetadata.listTaskPushNotificationConfig(grpcRequest).getConfigsList().stream().map(ProtoUtils.FromProto::taskPushNotificationConfig).collect(Collectors.toList());
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to list task push notification config: ");
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        DeleteTaskPushNotificationConfigRequest grpcRequest = DeleteTaskPushNotificationConfigRequest.newBuilder().setName(this.getTaskPushNotificationConfigName(request.id(), request.pushNotificationConfigId())).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/delete", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            stubWithMetadata.deleteTaskPushNotificationConfig(grpcRequest);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to delete task push notification config: ");
        }
    }

    public void resubscribe(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        TaskSubscriptionRequest grpcRequest = TaskSubscriptionRequest.newBuilder().setName("tasks/" + request.id()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/resubscribe", grpcRequest, this.agentCard, context);
        EventStreamObserver streamObserver = new EventStreamObserver(eventConsumer, errorConsumer);
        try {
            A2AServiceGrpc.A2AServiceStub stubWithMetadata = this.createAsyncStubWithMetadata(context, payloadAndHeaders);
            stubWithMetadata.taskSubscription(grpcRequest, (StreamObserver)streamObserver);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to resubscribe task push notification config: ");
        }
    }

    public AgentCard getAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        return this.agentCard;
    }

    public void close() {
    }

    private SendMessageRequest createGrpcSendMessageRequest(MessageSendParams messageSendParams, @Nullable ClientCallContext context) {
        SendMessageRequest.Builder builder = SendMessageRequest.newBuilder();
        builder.setRequest(ProtoUtils.ToProto.message((Message)messageSendParams.message()));
        if (messageSendParams.configuration() != null) {
            builder.setConfiguration(ProtoUtils.ToProto.messageSendConfiguration((MessageSendConfiguration)messageSendParams.configuration()));
        }
        if (messageSendParams.metadata() != null) {
            builder.setMetadata(ProtoUtils.ToProto.struct((Map)messageSendParams.metadata()));
        }
        return builder.build();
    }

    private Metadata createGrpcMetadata(@Nullable ClientCallContext context, @Nullable PayloadAndHeaders payloadAndHeaders) {
        String extensionsHeader;
        Metadata metadata = new Metadata();
        if (context != null && context.getHeaders() != null && (extensionsHeader = (String)context.getHeaders().get("X-A2A-Extensions")) != null) {
            metadata.put(EXTENSIONS_KEY, (Object)extensionsHeader);
        }
        if (payloadAndHeaders != null && payloadAndHeaders.getHeaders() != null) {
            for (Map.Entry headerEntry : payloadAndHeaders.getHeaders().entrySet()) {
                String headerName = (String)headerEntry.getKey();
                String headerValue = (String)headerEntry.getValue();
                if (headerValue == null) continue;
                if ("Authorization".equals(headerName)) {
                    metadata.put(AUTHORIZATION_METADATA_KEY, (Object)headerValue);
                    continue;
                }
                Metadata.Key metadataKey = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                metadata.put(metadataKey, (Object)headerValue);
            }
        }
        return metadata;
    }

    private A2AServiceGrpc.A2AServiceBlockingV2Stub createBlockingStubWithMetadata(@Nullable ClientCallContext context, PayloadAndHeaders payloadAndHeaders) {
        Metadata metadata = this.createGrpcMetadata(context, payloadAndHeaders);
        return (A2AServiceGrpc.A2AServiceBlockingV2Stub)this.blockingStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
    }

    private A2AServiceGrpc.A2AServiceStub createAsyncStubWithMetadata(@Nullable ClientCallContext context, PayloadAndHeaders payloadAndHeaders) {
        Metadata metadata = this.createGrpcMetadata(context, payloadAndHeaders);
        return (A2AServiceGrpc.A2AServiceStub)this.asyncStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
    }

    private String getTaskPushNotificationConfigName(GetTaskPushNotificationConfigParams params) {
        return this.getTaskPushNotificationConfigName(params.id(), params.pushNotificationConfigId());
    }

    private String getTaskPushNotificationConfigName(String taskId, @Nullable String pushNotificationConfigId) {
        StringBuilder name = new StringBuilder();
        name.append("tasks/");
        name.append(taskId);
        if (pushNotificationConfigId != null) {
            name.append("/pushNotificationConfigs/");
            name.append(pushNotificationConfigId);
        }
        return name.toString();
    }

    private PayloadAndHeaders applyInterceptors(String methodName, Object payload, AgentCard agentCard, @Nullable ClientCallContext clientCallContext) {
        PayloadAndHeaders payloadAndHeaders = new PayloadAndHeaders(payload, clientCallContext != null ? clientCallContext.getHeaders() : null);
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (ClientCallInterceptor interceptor : this.interceptors) {
                payloadAndHeaders = interceptor.intercept(methodName, payloadAndHeaders.getPayload(), payloadAndHeaders.getHeaders(), agentCard, clientCallContext);
            }
        }
        return payloadAndHeaders;
    }
}

