/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.taskstore.database.jpa;

import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.spec.Task;
import io.a2a.spec.TaskState;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

@Entity
@Table(name="a2a_tasks")
public class JpaTask {
    @Id
    @Column(name="task_id")
    private String id;
    @Column(name="context_id")
    private String contextId;
    @Column(name="state")
    private String state;
    @Column(name="status_timestamp")
    private Instant statusTimestamp;
    @Column(name="task_data", columnDefinition="TEXT", nullable=false)
    private String taskJson;
    @Column(name="finalized_at")
    private Instant finalizedAt;
    @Transient
    private Task task;

    public JpaTask() {
    }

    public JpaTask(String id, String taskJson) {
        this.id = id;
        this.taskJson = taskJson;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Instant getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public void setStatusTimestamp(Instant statusTimestamp) {
        this.statusTimestamp = statusTimestamp;
    }

    public String getTaskJson() {
        return this.taskJson;
    }

    public void setTaskJson(String taskJson) {
        this.taskJson = taskJson;
    }

    public Instant getFinalizedAt() {
        return this.finalizedAt;
    }

    public void setFinalizedAt(Instant finalizedAt, boolean isFinalState) {
        if (this.finalizedAt == null && isFinalState) {
            this.finalizedAt = finalizedAt;
        }
    }

    public Task getTask() throws JsonProcessingException {
        if (this.task == null) {
            this.task = (Task)JsonUtil.fromJson((String)this.taskJson, Task.class);
        }
        return this.task;
    }

    public void setTask(Task task) throws JsonProcessingException {
        this.taskJson = JsonUtil.toJson((Object)task);
        if (this.id == null) {
            this.id = task.id();
        }
        this.task = task;
        this.updateDenormalizedFields(task);
        this.updateFinalizedTimestamp(task);
    }

    static JpaTask createFromTask(Task task) throws JsonProcessingException {
        String json = JsonUtil.toJson((Object)task);
        JpaTask jpaTask = new JpaTask(task.id(), json);
        jpaTask.task = task;
        jpaTask.updateDenormalizedFields(task);
        jpaTask.updateFinalizedTimestamp(task);
        return jpaTask;
    }

    private void updateDenormalizedFields(Task task) {
        this.contextId = task.contextId();
        TaskState taskState = task.status().state();
        this.state = taskState.name();
        this.statusTimestamp = task.status().timestamp().toInstant().truncatedTo(ChronoUnit.MILLIS);
    }

    private void updateFinalizedTimestamp(Task task) {
        this.setFinalizedAt(Instant.now(), task.status().state().isFinal());
    }
}

