/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.taskstore.database.jpa;

import io.a2a.extras.common.events.TaskFinalizedEvent;
import io.a2a.extras.taskstore.database.jpa.JpaTask;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.server.config.A2AConfigProvider;
import io.a2a.server.tasks.TaskStateProvider;
import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.Task;
import io.a2a.util.PageToken;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.transaction.Transactional;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=50)
public class JpaDatabaseTaskStore
implements TaskStore,
TaskStateProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaDatabaseTaskStore.class);
    private static final String A2A_REPLICATION_GRACE_PERIOD_SECONDS = "a2a.replication.grace-period-seconds";
    @PersistenceContext(unitName="a2a-java")
    EntityManager em;
    @Inject
    Event<TaskFinalizedEvent> taskFinalizedEvent;
    @Inject
    A2AConfigProvider configProvider;
    long gracePeriodSeconds;

    @PostConstruct
    void initConfig() {
        this.gracePeriodSeconds = Long.parseLong(this.configProvider.getValue(A2A_REPLICATION_GRACE_PERIOD_SECONDS));
    }

    @Transactional
    public void save(Task task, boolean isReplicated) {
        LOGGER.debug("Saving task with ID: {} (replicated: {})", (Object)task.id(), (Object)isReplicated);
        try {
            JpaTask jpaTask = JpaTask.createFromTask(task);
            this.em.merge((Object)jpaTask);
            LOGGER.debug("Persisted/updated task with ID: {}", (Object)task.id());
            if (!isReplicated && task.status() != null && task.status().state() != null && task.status().state().isFinal()) {
                LOGGER.debug("Task {} is in final state, firing TaskFinalizedEvent with full Task", (Object)task.id());
                this.taskFinalizedEvent.fire((Object)new TaskFinalizedEvent(task.id(), (Object)task));
            } else if (isReplicated && task.status() != null && task.status().state() != null && task.status().state().isFinal()) {
                LOGGER.debug("Task {} is in final state but from replication - NOT firing TaskFinalizedEvent (prevents feedback loop)", (Object)task.id());
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize task with ID: {}", (Object)task.id(), (Object)e);
            throw new RuntimeException("Failed to serialize task with ID: " + task.id(), e);
        }
    }

    @Transactional
    public Task get(String taskId) {
        LOGGER.debug("Retrieving task with ID: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found with ID: {}", (Object)taskId);
            return null;
        }
        try {
            Task task = jpaTask.getTask();
            LOGGER.debug("Successfully retrieved task with ID: {}", (Object)taskId);
            return task;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}", (Object)taskId, (Object)e);
            throw new RuntimeException("Failed to deserialize task with ID: " + taskId, e);
        }
    }

    @Transactional
    public void delete(String taskId) {
        LOGGER.debug("Deleting task with ID: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask != null) {
            this.em.remove((Object)jpaTask);
            LOGGER.debug("Successfully deleted task with ID: {}", (Object)taskId);
        } else {
            LOGGER.debug("Task not found for deletion with ID: {}", (Object)taskId);
        }
    }

    @Transactional
    public boolean isTaskActive(String taskId) {
        LOGGER.debug("Checking if task is active: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found, considering inactive: {}", (Object)taskId);
            return false;
        }
        try {
            Task task = jpaTask.getTask();
            if (task.status() == null || task.status().state() == null || !task.status().state().isFinal()) {
                LOGGER.debug("Task is not in final state, considering active: {}", (Object)taskId);
                return true;
            }
            Instant finalizedAt = jpaTask.getFinalizedAt();
            if (finalizedAt == null) {
                LOGGER.warn("Task {} is in final state but has no finalizedAt timestamp, considering inactive", (Object)taskId);
                return false;
            }
            Instant gracePeriodEnd = finalizedAt.plus(Duration.ofSeconds(this.gracePeriodSeconds));
            Instant now = Instant.now();
            boolean withinGracePeriod = now.isBefore(gracePeriodEnd);
            LOGGER.debug("Task {} is final. FinalizedAt: {}, GracePeriodEnd: {}, Now: {}, Active: {}", new Object[]{taskId, finalizedAt, gracePeriodEnd, now, withinGracePeriod});
            return withinGracePeriod;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}, considering inactive", (Object)taskId, (Object)e);
            return false;
        }
    }

    @Transactional
    public boolean isTaskFinalized(String taskId) {
        LOGGER.debug("Checking if task is finalized: {}", (Object)taskId);
        JpaTask jpaTask = (JpaTask)this.em.find(JpaTask.class, (Object)taskId);
        if (jpaTask == null) {
            LOGGER.debug("Task not found, considering not finalized: {}", (Object)taskId);
            return false;
        }
        try {
            Task task = jpaTask.getTask();
            boolean isFinalized = task.status() != null && task.status().state() != null && task.status().state().isFinal();
            LOGGER.debug("Task {} finalization check: {}", (Object)taskId, (Object)isFinalized);
            return isFinalized;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to deserialize task with ID: {}, considering not finalized", (Object)taskId, (Object)e);
            return false;
        }
    }

    @Transactional
    public ListTasksResult list(ListTasksParams params) {
        boolean hasMore;
        LOGGER.debug("Listing tasks with params: contextId={}, status={}, pageSize={}, pageToken={}", new Object[]{params.contextId(), params.status(), params.pageSize(), params.pageToken()});
        PageToken pageToken = PageToken.fromString((String)params.pageToken());
        Instant tokenTimestamp = pageToken != null ? pageToken.timestamp() : null;
        String tokenId = pageToken != null ? pageToken.id() : null;
        StringBuilder queryBuilder = new StringBuilder("SELECT t FROM JpaTask t WHERE 1=1");
        StringBuilder countQueryBuilder = new StringBuilder("SELECT COUNT(t) FROM JpaTask t WHERE 1=1");
        if (params.contextId() != null) {
            queryBuilder.append(" AND t.contextId = :contextId");
            countQueryBuilder.append(" AND t.contextId = :contextId");
        }
        if (params.status() != null) {
            queryBuilder.append(" AND t.state = :state");
            countQueryBuilder.append(" AND t.state = :state");
        }
        if (params.statusTimestampAfter() != null) {
            queryBuilder.append(" AND t.statusTimestamp > :statusTimestampAfter");
            countQueryBuilder.append(" AND t.statusTimestamp > :statusTimestampAfter");
        }
        if (tokenTimestamp != null) {
            queryBuilder.append(" AND (t.statusTimestamp < :tokenTimestamp OR (t.statusTimestamp = :tokenTimestamp AND t.id > :tokenId))");
        }
        queryBuilder.append(" ORDER BY t.statusTimestamp DESC, t.id ASC");
        TypedQuery query = this.em.createQuery(queryBuilder.toString(), JpaTask.class);
        if (params.contextId() != null) {
            query.setParameter("contextId", (Object)params.contextId());
        }
        if (params.status() != null) {
            query.setParameter("state", (Object)params.status().name());
        }
        if (params.statusTimestampAfter() != null) {
            query.setParameter("statusTimestampAfter", (Object)params.statusTimestampAfter());
        }
        if (tokenTimestamp != null) {
            query.setParameter("tokenTimestamp", (Object)tokenTimestamp);
            query.setParameter("tokenId", (Object)tokenId);
        }
        int pageSize = params.getEffectivePageSize();
        query.setMaxResults(pageSize + 1);
        List jpaTasksPage = query.getResultList();
        boolean bl = hasMore = jpaTasksPage.size() > pageSize;
        if (hasMore) {
            jpaTasksPage = jpaTasksPage.subList(0, pageSize);
        }
        TypedQuery countQuery = this.em.createQuery(countQueryBuilder.toString(), Long.class);
        if (params.contextId() != null) {
            countQuery.setParameter("contextId", (Object)params.contextId());
        }
        if (params.status() != null) {
            countQuery.setParameter("state", (Object)params.status().name());
        }
        if (params.statusTimestampAfter() != null) {
            countQuery.setParameter("statusTimestampAfter", (Object)params.statusTimestampAfter());
        }
        int totalSize = ((Long)countQuery.getSingleResult()).intValue();
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (JpaTask jpaTask : jpaTasksPage) {
            try {
                tasks.add(jpaTask.getTask());
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Failed to deserialize task with ID: {}", (Object)jpaTask.getId(), (Object)e);
                throw new RuntimeException("Failed to deserialize task with ID: " + jpaTask.getId(), e);
            }
        }
        String nextPageToken = null;
        if (hasMore && !tasks.isEmpty()) {
            Task lastTask = (Task)tasks.get(tasks.size() - 1);
            Instant timestamp = lastTask.status().timestamp().toInstant();
            nextPageToken = new PageToken(timestamp, lastTask.id()).toString();
        }
        int historyLength = params.getEffectiveHistoryLength();
        boolean includeArtifacts = params.shouldIncludeArtifacts();
        List<Task> transformedTasks = tasks.stream().map(task -> this.transformTask((Task)task, historyLength, includeArtifacts)).toList();
        LOGGER.debug("Returning {} tasks out of {} total", (Object)transformedTasks.size(), (Object)totalSize);
        return new ListTasksResult(transformedTasks, totalSize, transformedTasks.size(), nextPageToken);
    }

    private Task transformTask(Task task, int historyLength, boolean includeArtifacts) {
        List artifacts;
        List history = task.history();
        if (historyLength == 0) {
            history = List.of();
        } else if (historyLength > 0 && history != null && history.size() > historyLength) {
            history = history.subList(history.size() - historyLength, history.size());
        }
        List list = artifacts = includeArtifacts ? task.artifacts() : List.of();
        if (history == task.history() && artifacts == task.artifacts()) {
            return task;
        }
        return Task.builder((Task)task).artifacts(artifacts).history(history).build();
    }
}

