/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.contract;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tron.trident.abi.datatypes.Type;
import org.tron.trident.core.ApiWrapper;
import org.tron.trident.core.contract.ContractConstructor;
import org.tron.trident.core.contract.ContractFunction;
import org.tron.trident.core.exceptions.ContractCreateException;
import org.tron.trident.core.transaction.TransactionBuilder;
import org.tron.trident.proto.Common;
import org.tron.trident.proto.Contract;

public class Contract {
    protected ApiWrapper wrapper;
    protected ByteString originAddr = ByteString.EMPTY;
    protected ByteString cntrAddr = ByteString.EMPTY;
    protected Common.SmartContract.ABI abi;
    protected ByteString bytecode;
    protected long callValue = 0L;
    protected long consumeUserResourcePercent = 100L;
    protected String name = "";
    protected long originEnergyLimit = 1L;
    protected ByteString codeHash = ByteString.EMPTY;
    protected ByteString trxHash = ByteString.EMPTY;
    protected int version = 0;
    protected ByteString ownerAddr = ByteString.EMPTY;
    protected List<ContractFunction> functions = new ArrayList<ContractFunction>();
    protected ContractConstructor constructor = null;

    public Contract(Contract cntr, String ownerAddr, ApiWrapper wrapper) {
        this.originAddr = cntr.getOriginAddr();
        this.cntrAddr = cntr.getCntrAddr();
        this.abi = cntr.getAbi();
        this.bytecode = cntr.getBytecode();
        this.callValue = cntr.getCallValue();
        this.consumeUserResourcePercent = cntr.getConsumeUserResourcePercent();
        this.name = cntr.getName();
        this.originEnergyLimit = cntr.getOriginEnergyLimit();
        this.codeHash = cntr.getCodeHash();
        this.trxHash = cntr.getTrxHash();
        this.ownerAddr = ApiWrapper.parseAddress(ownerAddr);
        this.wrapper = wrapper;
    }

    public Contract(ByteString cntrAddr, Common.SmartContract.ABI abi, ByteString bytecode, long consumeUserResourcePercent, String name, long originEnergyLimit) {
        this.cntrAddr = cntrAddr;
        this.abi = abi;
        this.bytecode = bytecode;
        this.consumeUserResourcePercent = consumeUserResourcePercent;
        this.name = name;
        this.originEnergyLimit = originEnergyLimit;
    }

    public Contract(Builder builder) {
        this.originAddr = builder.originAddr;
        this.cntrAddr = builder.cntrAddr;
        this.abi = builder.abi;
        this.bytecode = builder.bytecode;
        this.callValue = builder.callValue;
        this.consumeUserResourcePercent = builder.consumeUserResourcePercent;
        this.name = builder.name;
        this.originEnergyLimit = builder.originEnergyLimit;
        this.codeHash = builder.codeHash;
        this.trxHash = builder.trxHash;
        this.version = builder.version;
        this.ownerAddr = builder.ownerAddr;
        this.abiToFunctions();
    }

    public void setAbi(String abiString) throws Exception {
        Common.SmartContract.ABI.Builder builder = Common.SmartContract.ABI.newBuilder();
        Contract.loadAbiFromJson(abiString, builder);
        this.abi = builder.build();
    }

    public Contract.CreateSmartContract createSmartContract(List<Type<?>> buildParams) throws Exception {
        if (!this.cntrAddr.isEmpty()) {
            throw new ContractCreateException("This contract has already been deployed.");
        }
        if (!this.originAddr.equals((Object)this.ownerAddr)) {
            throw new ContractCreateException("Origin address and owner address mismatch.");
        }
        this.loadConstructor();
        if (null == this.constructor && !buildParams.isEmpty()) {
            throw new ContractCreateException("The contract does not have a constructor.");
        }
        if (!buildParams.isEmpty()) {
            this.constructor.encodeParameter(buildParams);
            this.setBytecode(this.getBytecode().concat(this.constructor.getBytecode()));
        }
        Contract.CreateSmartContract.Builder createSmartContractBuilder = Contract.CreateSmartContract.newBuilder();
        createSmartContractBuilder.setOwnerAddress(this.ownerAddr);
        createSmartContractBuilder.setNewContract(this.toProto());
        return createSmartContractBuilder.build();
    }

    protected void abiToFunctions() {
        int funcNum = this.abi.getEntrysCount();
        for (int i = 0; i < funcNum; ++i) {
            List<Common.SmartContract.ABI.Entry.Param> params;
            Common.SmartContract.ABI.Entry funcAbi = this.abi.getEntrysList().get(i);
            if (funcAbi.getTypeValue() != 2) continue;
            ContractFunction.Builder builder = new ContractFunction.Builder();
            builder.setName(funcAbi.getName());
            builder.setAbi(funcAbi);
            builder.setCntr(this);
            builder.setOwnerAddr(this.ownerAddr);
            if (0 != funcAbi.getInputsCount()) {
                params = funcAbi.getInputsList();
                builder.setInputParams(this.collectParams(params, 'p'));
                builder.setInputTypes(this.collectParams(params, 't'));
            }
            if (0 != funcAbi.getOutputsCount()) {
                params = funcAbi.getOutputsList();
                if (null != params.get(0).getName()) {
                    builder.setOutput(this.collectParams(params, 'p').get(0));
                }
                builder.setOutputType(this.collectParams(params, 't').get(0));
            }
            switch (funcAbi.getStateMutabilityValue()) {
                case 0: {
                    builder.setStateMutability("unknownmutabilitytype");
                    break;
                }
                case 1: {
                    builder.setStateMutability("pure");
                    break;
                }
                case 2: {
                    builder.setStateMutability("view");
                    break;
                }
                case 3: {
                    builder.setStateMutability("nonpayable");
                    break;
                }
                case 4: {
                    builder.setStateMutability("payable");
                    break;
                }
            }
            this.functions.add(builder.build());
        }
    }

    protected List<String> collectParams(List<Common.SmartContract.ABI.Entry.Param> params, char flag) {
        ArrayList<String> ret = new ArrayList<String>();
        switch (flag) {
            case 'p': {
                for (Common.SmartContract.ABI.Entry.Param p : params) {
                    ret.add(p.getName());
                }
                break;
            }
            case 't': {
                for (Common.SmartContract.ABI.Entry.Param p : params) {
                    ret.add(p.getType());
                }
                break;
            }
        }
        return ret;
    }

    public Common.SmartContract toProto() {
        return Common.SmartContract.newBuilder().setOriginAddress(this.originAddr).setContractAddress(this.cntrAddr).setAbi(this.abi).setBytecode(this.bytecode).setCallValue(this.callValue).setConsumeUserResourcePercent(this.consumeUserResourcePercent).setName(this.name).setOriginEnergyLimit(this.originEnergyLimit).setCodeHash(this.codeHash).setTrxHash(this.trxHash).setVersion(this.version).build();
    }

    public TransactionBuilder deploy() throws Exception {
        return this.deploy(Collections.emptyList());
    }

    public TransactionBuilder deploy(List<Type<?>> buildParams) throws Exception {
        Contract.CreateSmartContract createSmartContract = this.createSmartContract(buildParams);
        return new TransactionBuilder(this.wrapper.blockingStub.deployContract(createSmartContract).getTransaction());
    }

    protected void loadConstructor() {
        for (Common.SmartContract.ABI.Entry e : this.abi.getEntrysList()) {
            if (!e.getName().equals("")) continue;
            this.constructor = new ContractConstructor(e);
        }
    }

    public static void loadAbiFromJson(String abiString, Common.SmartContract.ABI.Builder builder) throws Exception {
        if (abiString == null || abiString.isEmpty()) {
            return;
        }
        if (!abiString.trim().startsWith("{")) {
            abiString = "{\"entrys\":" + abiString + "}";
        }
        JsonFormat.parser().ignoringUnknownFields().merge(abiString, (Message.Builder)builder);
    }

    public ApiWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(ApiWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void setOriginAddr(ByteString originAddr) {
        this.originAddr = originAddr;
    }

    public ByteString getOriginAddr() {
        return this.originAddr;
    }

    public void setCntrAddr(ByteString cntrAddr) {
        this.cntrAddr = cntrAddr;
    }

    public ByteString getCntrAddr() {
        return this.cntrAddr;
    }

    public Common.SmartContract.ABI getAbi() {
        return this.abi;
    }

    public void setBytecode(ByteString bytecode) {
        this.bytecode = bytecode;
    }

    public ByteString getBytecode() {
        return this.bytecode;
    }

    public void setCallValue(long callValue) {
        this.callValue = callValue;
    }

    public long getCallValue() {
        return this.callValue;
    }

    public void setConsumeUserResourcePercent(long consumeUserResourcePercent) {
        this.consumeUserResourcePercent = consumeUserResourcePercent;
    }

    public long getConsumeUserResourcePercent() {
        return this.consumeUserResourcePercent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOriginEnergyLimit(long originEnergyLimit) {
        this.originEnergyLimit = originEnergyLimit;
    }

    public long getOriginEnergyLimit() {
        return this.originEnergyLimit;
    }

    public void setCodeHash(ByteString codeHash) {
        this.codeHash = codeHash;
    }

    public ByteString getCodeHash() {
        return this.codeHash;
    }

    public void setTrxHash(ByteString trxHash) {
        this.trxHash = trxHash;
    }

    public ByteString getTrxHash() {
        return this.trxHash;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setOwnerAddr(ByteString ownerAddr) {
        this.ownerAddr = ownerAddr;
    }

    public ByteString getOwnerAddr() {
        return this.ownerAddr;
    }

    public void setFunctions(List<ContractFunction> functions) {
        this.functions = functions;
    }

    public List<ContractFunction> getFunctions() {
        return this.functions;
    }

    public ContractConstructor getConstructor() {
        return this.constructor;
    }

    public static class Builder {
        protected ByteString originAddr = ByteString.EMPTY;
        protected ByteString cntrAddr = ByteString.EMPTY;
        protected Common.SmartContract.ABI abi;
        protected ByteString bytecode;
        protected long callValue = 0L;
        protected long consumeUserResourcePercent = 100L;
        protected String name = "";
        protected long originEnergyLimit = 1L;
        protected ByteString codeHash = ByteString.EMPTY;
        protected ByteString trxHash = ByteString.EMPTY;
        protected int version = 0;
        protected ByteString ownerAddr = ByteString.EMPTY;

        public Builder setOriginAddr(ByteString originAddr) {
            this.originAddr = originAddr;
            return this;
        }

        public Builder setCntrAddr(ByteString cntrAddr) {
            this.cntrAddr = cntrAddr;
            return this;
        }

        public Builder setAbi(Common.SmartContract.ABI abi) {
            this.abi = abi;
            return this;
        }

        public Builder setAbi(String abiString) throws Exception {
            Common.SmartContract.ABI.Builder builder = Common.SmartContract.ABI.newBuilder();
            Contract.loadAbiFromJson(abiString, builder);
            this.abi = builder.build();
            return this;
        }

        public Builder setBytecode(ByteString bytecode) {
            this.bytecode = bytecode;
            return this;
        }

        public Builder setCallValue(long callValue) {
            this.callValue = callValue;
            return this;
        }

        public Builder setConsumeUserResourcePercent(long consumeUserResourcePercent) {
            this.consumeUserResourcePercent = consumeUserResourcePercent;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setOriginEnergyLimit(long originEnergyLimit) {
            this.originEnergyLimit = originEnergyLimit;
            return this;
        }

        public Builder setCodeHash(ByteString codeHash) {
            this.codeHash = codeHash;
            return this;
        }

        public Builder setTrxHash(ByteString trxHash) {
            this.trxHash = trxHash;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setOwnerAddr(ByteString ownerAddr) {
            this.ownerAddr = ownerAddr;
            return this;
        }

        public Contract build() {
            return new Contract(this);
        }
    }
}

