/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.io.IOException;
import org.mx.TypeUtils;
import org.mx.config.SystemConfig;

public class ConfigUtils {
    private static final SystemConfig config = SystemConfig.instance();

    private ConfigUtils() {
    }

    public static void loadConfig(String file) throws IOException {
        config.load(file);
    }

    public static void loadConfigs(String[] files) throws IOException {
        for (String file : files) {
            config.load(file);
        }
    }

    public static void cleanConfig() {
        config.clean();
    }

    public static void updateConfig(String key, String value) {
        config.setValue(key, value);
    }

    public static String getStringValue(String key, String defaultValue) {
        String value = config.getValue(key);
        return value == null ? defaultValue : value;
    }

    public static int getIntValue(String key, int defaultValue) {
        return ConfigUtils.getIntValue(key, TypeUtils.Radix.Decimal, defaultValue);
    }

    public static int getIntValue(String key, TypeUtils.Radix radix, int defaultValue) {
        return TypeUtils.string2Int(config.getValue(key), radix, defaultValue);
    }

    public static boolean getBooleanValue(String key, boolean defaultValue) {
        return TypeUtils.string2Boolean(config.getValue(key), defaultValue);
    }

    public static char getCharValue(String key, char defaultValue) {
        String value = config.getValue(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public static long getLongValue(String key, long defaultValue) {
        return ConfigUtils.getLongValue(key, TypeUtils.Radix.Decimal, defaultValue);
    }

    public static long getLongValue(String key, TypeUtils.Radix radix, long defaultValue) {
        return TypeUtils.string2Long(config.getValue(key), radix, defaultValue);
    }

    public static float getFloatValue(String key, float defaultValue) {
        return TypeUtils.string2Float(config.getValue(key), defaultValue);
    }

    public static double getDoubleValue(String key, double defaultValue) {
        return TypeUtils.string2Double(config.getValue(key), defaultValue);
    }
}

