/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.impactmetrics;

import io.getunleash.impactmetrics.CollectedMetric;
import io.getunleash.impactmetrics.Counter;
import io.getunleash.impactmetrics.CounterImpl;
import io.getunleash.impactmetrics.Gauge;
import io.getunleash.impactmetrics.GaugeImpl;
import io.getunleash.impactmetrics.ImpactMetricRegistry;
import io.getunleash.impactmetrics.ImpactMetricsDataSource;
import io.getunleash.impactmetrics.MetricOptions;
import io.getunleash.impactmetrics.MetricType;
import io.getunleash.impactmetrics.NumericMetricSample;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryMetricRegistry
implements ImpactMetricRegistry,
ImpactMetricsDataSource {
    private final Map<String, CounterImpl> counters = new ConcurrentHashMap<String, CounterImpl>();
    private final Map<String, GaugeImpl> gauges = new ConcurrentHashMap<String, GaugeImpl>();

    @Override
    public Counter counter(MetricOptions options) {
        return this.counters.computeIfAbsent(options.getName(), name -> new CounterImpl(options));
    }

    @Override
    public Gauge gauge(MetricOptions options) {
        return this.gauges.computeIfAbsent(options.getName(), name -> new GaugeImpl(options));
    }

    @Override
    public List<CollectedMetric> collect() {
        ArrayList<CollectedMetric> collected = new ArrayList<CollectedMetric>();
        this.counters.values().stream().map(CounterImpl::collect).filter(m -> !m.getSamples().isEmpty()).forEach(collected::add);
        this.gauges.values().stream().map(GaugeImpl::collect).filter(m -> !m.getSamples().isEmpty()).forEach(collected::add);
        return collected;
    }

    @Override
    public void restore(List<CollectedMetric> metrics) {
        for (CollectedMetric metric : metrics) {
            if (metric.getType() == MetricType.COUNTER) {
                Counter counter = this.counter(new MetricOptions(metric.getName(), metric.getHelp()));
                for (NumericMetricSample sample : metric.getSamples()) {
                    counter.inc(sample.getValue(), sample.getLabels());
                }
                continue;
            }
            if (metric.getType() != MetricType.GAUGE) continue;
            Gauge gauge = this.gauge(new MetricOptions(metric.getName(), metric.getHelp()));
            for (NumericMetricSample sample : metric.getSamples()) {
                gauge.set(sample.getValue(), sample.getLabels());
            }
        }
    }
}

