/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.impactmetrics;

import io.getunleash.impactmetrics.CollectedMetric;
import io.getunleash.impactmetrics.CounterImpl;
import io.getunleash.impactmetrics.Gauge;
import io.getunleash.impactmetrics.MetricOptions;
import io.getunleash.impactmetrics.MetricType;
import io.getunleash.impactmetrics.NumericMetricSample;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class GaugeImpl
implements Gauge {
    private final MetricOptions options;
    private final ConcurrentHashMap<String, Long> values = new ConcurrentHashMap();

    GaugeImpl(MetricOptions options) {
        this.options = options;
    }

    @Override
    public void set(long value) {
        this.set(value, null);
    }

    @Override
    public void set(long value, Map<String, String> labels) {
        String key = CounterImpl.getLabelKey(labels);
        this.values.put(key, value);
    }

    @Override
    public void inc() {
        this.inc(1L, null);
    }

    @Override
    public void inc(long value) {
        this.inc(value, null);
    }

    @Override
    public void inc(long value, Map<String, String> labels) {
        String key = CounterImpl.getLabelKey(labels);
        this.values.compute(key, (k, current) -> (current == null ? 0L : current) + value);
    }

    @Override
    public void dec() {
        this.dec(1L, null);
    }

    @Override
    public void dec(long value) {
        this.dec(value, null);
    }

    @Override
    public void dec(long value, Map<String, String> labels) {
        String key = CounterImpl.getLabelKey(labels);
        this.values.compute(key, (k, current) -> (current == null ? 0L : current) - value);
    }

    public CollectedMetric collect() {
        ArrayList<NumericMetricSample> samples = new ArrayList<NumericMetricSample>();
        for (String key : this.values.keySet()) {
            Long value = this.values.remove(key);
            if (value == null) continue;
            samples.add(new NumericMetricSample(CounterImpl.parseLabelKey(key), value));
        }
        return new CollectedMetric(this.options.getName(), this.options.getHelp(), MetricType.GAUGE, samples);
    }
}

