/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.impactmetrics;

import io.getunleash.impactmetrics.CollectedMetric;
import io.getunleash.impactmetrics.Counter;
import io.getunleash.impactmetrics.MetricOptions;
import io.getunleash.impactmetrics.MetricType;
import io.getunleash.impactmetrics.NumericMetricSample;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class CounterImpl
implements Counter {
    private final MetricOptions options;
    private final ConcurrentHashMap<String, Long> values = new ConcurrentHashMap();

    CounterImpl(MetricOptions options) {
        this.options = options;
    }

    @Override
    public void inc() {
        this.inc(1L, null);
    }

    @Override
    public void inc(long value) {
        this.inc(value, null);
    }

    @Override
    public void inc(long value, Map<String, String> labels) {
        String key = CounterImpl.getLabelKey(labels);
        this.values.compute(key, (k, current) -> (current == null ? 0L : current) + value);
    }

    public CollectedMetric collect() {
        ArrayList<NumericMetricSample> samples = new ArrayList<NumericMetricSample>();
        for (String key : this.values.keySet()) {
            Long value = this.values.remove(key);
            if (value == null) continue;
            samples.add(new NumericMetricSample(CounterImpl.parseLabelKey(key), value));
        }
        if (samples.isEmpty()) {
            samples.add(new NumericMetricSample(Collections.emptyMap(), 0L));
        }
        return new CollectedMetric(this.options.getName(), this.options.getHelp(), MetricType.COUNTER, samples);
    }

    static String getLabelKey(Map<String, String> labels) {
        if (labels == null || labels.isEmpty()) {
            return "";
        }
        return labels.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    static Map<String, String> parseLabelKey(String key) {
        if (key == null || key.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String pair : key.split(",")) {
            String[] parts = pair.split("=", 2);
            if (parts.length != 2) continue;
            labels.put(parts[0], parts[1]);
        }
        return labels;
    }
}

