/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.EvaluatedToggle;
import io.getunleash.FeatureDefinition;
import io.getunleash.MoreOperations;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.lang.Nullable;
import io.getunleash.variant.Variant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FakeUnleash
implements Unleash {
    private boolean enableAll = false;
    private boolean disableAll = false;
    private final Map<String, Queue<Predicate<UnleashContext>>> conditionalFeatures = new ConcurrentHashMap<String, Queue<Predicate<UnleashContext>>>();
    private final Map<String, Boolean> excludedFeatures = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> features = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Variant> variants = new ConcurrentHashMap<String, Variant>();

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        if (this.enableAll) {
            return this.excludedFeatures.getOrDefault(toggleName, true);
        }
        if (this.disableAll) {
            return this.excludedFeatures.getOrDefault(toggleName, false);
        }
        Boolean unconditionallyEnabled = this.features.get(toggleName);
        if (unconditionallyEnabled != null) {
            return unconditionallyEnabled;
        }
        Queue<Predicate<UnleashContext>> conditionalFeaturePredicates = this.conditionalFeatures.get(toggleName);
        if (conditionalFeaturePredicates == null) {
            return fallbackAction.test(toggleName, context);
        }
        return conditionalFeaturePredicates.stream().anyMatch(conditionalFeaturePredicate -> conditionalFeaturePredicate.test(context));
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        Variant variant;
        if (this.isEnabled(toggleName, context) && (variant = this.variants.get(toggleName)) != null) {
            return variant;
        }
        return defaultValue;
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, UnleashContext.builder().build(), defaultValue);
    }

    @Override
    public MoreOperations more() {
        return new FakeMore();
    }

    public void enableAll() {
        this.disableAll = false;
        this.enableAll = true;
        this.features.clear();
        this.excludedFeatures.clear();
        this.conditionalFeatures.clear();
    }

    public void enableAllExcept(String ... excludedFeatures) {
        this.enableAll();
        for (String toggle : excludedFeatures) {
            this.excludedFeatures.put(toggle, false);
        }
    }

    public void disableAll() {
        this.disableAll = true;
        this.enableAll = false;
        this.features.clear();
        this.excludedFeatures.clear();
        this.conditionalFeatures.clear();
    }

    public void disableAllExcept(String ... excludedFeatures) {
        this.disableAll();
        for (String toggle : excludedFeatures) {
            this.excludedFeatures.put(toggle, true);
        }
    }

    public void resetAll() {
        this.disableAll = false;
        this.enableAll = false;
        this.excludedFeatures.clear();
        this.features.clear();
        this.conditionalFeatures.clear();
        this.variants.clear();
    }

    public void enable(String ... features) {
        for (String name : features) {
            this.conditionalFeatures.remove(name);
            this.features.put(name, true);
        }
    }

    public void disable(String ... features) {
        for (String name : features) {
            this.conditionalFeatures.remove(name);
            this.features.put(name, false);
        }
    }

    public void reset(String ... features) {
        for (String name : features) {
            this.conditionalFeatures.remove(name);
            this.features.remove(name);
        }
    }

    public void conditionallyEnable(Predicate<UnleashContext> contextMatcher, String ... features) {
        for (String name : features) {
            this.features.remove(name);
            this.conditionalFeatures.computeIfAbsent(name, ignored -> new LinkedBlockingQueue()).add(contextMatcher);
        }
    }

    public void setVariant(String toggleName, Variant variant) {
        this.variants.put(toggleName, variant);
    }

    public class FakeMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return Stream.concat(FakeUnleash.this.features.keySet().stream(), FakeUnleash.this.conditionalFeatures.keySet().stream()).distinct().collect(Collectors.toList());
        }

        @Override
        public Optional<FeatureDefinition> getFeatureToggleDefinition(String toggleName) {
            if (FakeUnleash.this.conditionalFeatures.containsKey(toggleName) || FakeUnleash.this.features.containsKey(toggleName)) {
                return Optional.of(new FeatureDefinition(toggleName, Optional.of("experiment"), "default", true));
            }
            return Optional.empty();
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(null);
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(@Nullable UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> new EvaluatedToggle((String)toggleName, FakeUnleash.this.isEnabled((String)toggleName), FakeUnleash.this.getVariant((String)toggleName))).collect(Collectors.toList());
        }
    }
}

