/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.log.android.file;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.core.content.FileProvider;
import io.getstream.log.CompositeStreamLogger;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.android.AndroidStreamLogger;
import io.getstream.log.android.file.StreamLogFileManager;
import io.getstream.log.android.file.impl.LifecycleAwareLogFileManager;
import io.getstream.log.file.FileStreamLogger;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\n*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/getstream/log/android/file/StreamLogFileProvider;", "Landroidx/core/content/FileProvider;", "()V", "application", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "onCreate", "", "getSupportVersionCode", "", "Landroid/content/pm/PackageInfo;", "getVersionCode", "Landroid/content/Context;", "getVersionName", "", "stream-log-android-file_release"})
public final class StreamLogFileProvider
extends FileProvider {
    private final Application getApplication() {
        Context context = this.getContext();
        return context instanceof Application ? (Application)context : null;
    }

    public boolean onCreate() {
        block1: {
            Context context = this.getContext();
            if (context == null) {
                return super.onCreate();
            }
            Context context2 = context;
            File file = context2.getFilesDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.filesDir");
            File file2 = context2.getExternalFilesDir(null);
            FileStreamLogger.Config.App app = new FileStreamLogger.Config.App(this.getVersionCode(context2), this.getVersionName(context2));
            String string = "%s %s";
            Object[] objectArray = new Object[]{Build.MANUFACTURER, Build.DEVICE};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            FileStreamLogger.Config fileLoggerConfig = new FileStreamLogger.Config(0, file, file2, app, new FileStreamLogger.Config.Device(string2, Build.VERSION.SDK_INT), 1, null);
            FileStreamLogger fileLogger = new FileStreamLogger(fileLoggerConfig);
            AndroidStreamLogger androidLogger = new AndroidStreamLogger(0, 1, null);
            StreamLogger[] streamLoggerArray = new StreamLogger[]{(StreamLogger)androidLogger, fileLogger};
            CompositeStreamLogger compositeLogger = new CompositeStreamLogger(streamLoggerArray);
            LifecycleAwareLogFileManager fileManager = new LifecycleAwareLogFileManager(fileLogger);
            StreamLog.install((StreamLogger)((StreamLogger)compositeLogger));
            StreamLog.setValidator(StreamLogFileProvider::onCreate$lambda$0);
            StreamLogFileManager.INSTANCE.init(fileManager, fileManager);
            Application application = this.getApplication();
            if (application == null) break block1;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)fileManager);
        }
        return super.onCreate();
    }

    private final String getVersionName(Context $this$getVersionName) {
        String string;
        try {
            String string2;
            PackageManager packageManager = $this$getVersionName.getPackageManager();
            if ((packageManager != null && (packageManager = packageManager.getPackageInfo($this$getVersionName.getPackageName(), 0)) != null ? packageManager.versionName : (string2 = null)) == null) {
                string2 = "";
            }
            string = string2;
        }
        catch (PackageManager.NameNotFoundException _) {
            string = "";
        }
        return string;
    }

    private final long getVersionCode(Context $this$getVersionCode) {
        long l;
        try {
            PackageManager packageManager = $this$getVersionCode.getPackageManager();
            l = packageManager != null && (packageManager = packageManager.getPackageInfo($this$getVersionCode.getPackageName(), 0)) != null ? this.getSupportVersionCode((PackageInfo)packageManager) : -1L;
        }
        catch (PackageManager.NameNotFoundException _) {
            l = -1L;
        }
        return l;
    }

    private final long getSupportVersionCode(PackageInfo $this$getSupportVersionCode) {
        return Build.VERSION.SDK_INT >= 28 ? $this$getSupportVersionCode.getLongVersionCode() : (long)$this$getSupportVersionCode.versionCode;
    }

    private static final boolean onCreate$lambda$0(Priority priority, String string) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
        return true;
    }
}

