/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import io.getstream.chat.java.services.framework.UserToken;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;

class UserCall<T>
implements Call<T> {
    private final Retrofit retrofit;
    private final UserToken token;
    private final Call<T> delegate;
    private final Type responseType;
    private volatile boolean executed;
    private volatile okhttp3.Call rawCall;

    UserCall(Retrofit retrofit, UserToken token, Call<T> delegate, Type responseType) {
        this.retrofit = retrofit;
        this.token = token;
        this.delegate = delegate;
        this.responseType = responseType;
    }

    private okhttp3.Call createRawCall() {
        return this.retrofit.callFactory().newCall(this.request());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public retrofit2.Response<T> execute() throws IOException {
        okhttp3.Call call;
        UserCall userCall = this;
        synchronized (userCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall = this.createRawCall();
        }
        Response rawResponse = call.execute();
        return this.parseResponse(rawResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(final @NotNull Callback<T> callback) {
        okhttp3.Call call;
        UserCall userCall = this;
        synchronized (userCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall = this.createRawCall();
        }
        call.enqueue(new okhttp3.Callback(){

            public void onResponse(@NotNull okhttp3.Call call, @NotNull Response rawResponse) {
                retrofit2.Response response;
                try {
                    response = UserCall.this.parseResponse(rawResponse);
                }
                catch (Throwable t) {
                    this.callFailure(t);
                    return;
                }
                this.callSuccess(response);
            }

            public void onFailure(@NotNull okhttp3.Call call, @NotNull IOException e) {
                this.callFailure(e);
            }

            private void callSuccess(retrofit2.Response<T> response) {
                try {
                    callback.onResponse((Call)UserCall.this, response);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void callFailure(Throwable t) {
                try {
                    callback.onFailure((Call)UserCall.this, t);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private retrofit2.Response<T> parseResponse(Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                ResponseBody bufferedBody = UserCall.bufferResponseBody(rawBody);
                retrofit2.Response response = retrofit2.Response.error((ResponseBody)bufferedBody, (Response)rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code == 204 || code == 205) {
            rawBody.close();
            return retrofit2.Response.success(null, (Response)rawResponse);
        }
        try {
            Converter converter = this.retrofit.responseBodyConverter(this.responseType, new Annotation[0]);
            Object body = converter.convert((Object)rawBody);
            return retrofit2.Response.success((Object)body, (Response)rawResponse);
        }
        catch (RuntimeException e) {
            rawBody.close();
            throw e;
        }
    }

    private static ResponseBody bufferResponseBody(ResponseBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.source().readAll((Sink)buffer);
        return ResponseBody.create((byte[])buffer.readByteArray(), (MediaType)body.contentType());
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void cancel() {
        if (this.rawCall != null) {
            this.rawCall.cancel();
        }
    }

    public boolean isCanceled() {
        return this.rawCall != null && this.rawCall.isCanceled();
    }

    @NotNull
    public Call<T> clone() {
        return new UserCall<T>(this.retrofit, this.token, this.delegate.clone(), this.responseType);
    }

    @NotNull
    public Request request() {
        Request original = this.delegate.request();
        return original.newBuilder().tag(UserToken.class, (Object)this.token).build();
    }

    @NotNull
    public Timeout timeout() {
        return this.rawCall != null ? this.rawCall.timeout() : Timeout.NONE;
    }

    private static final class NoContentResponseBody
    extends ResponseBody {
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

