/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.SharedLocationService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class SharedLocation {
    @JsonProperty(value="channel_cid")
    private String channelCid;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="created_by_device_id")
    private String createdByDeviceId;
    @JsonProperty(value="end_at")
    private Date endAt;
    @JsonProperty(value="latitude")
    private Double latitude;
    @JsonProperty(value="longitude")
    private Double longitude;
    @JsonProperty(value="message_id")
    private String messageId;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="user_id")
    private String userId;

    @NotNull
    public static UpdateLocationRequestData.UpdateLocationRequest updateLocation() {
        return new UpdateLocationRequestData.UpdateLocationRequest();
    }

    @NotNull
    public static GetLocationsRequestData.GetLocationsRequest getLocations() {
        return new GetLocationsRequestData.GetLocationsRequest();
    }

    public String getChannelCid() {
        return this.channelCid;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedByDeviceId() {
        return this.createdByDeviceId;
    }

    public Date getEndAt() {
        return this.endAt;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="channel_cid")
    public void setChannelCid(String channelCid) {
        this.channelCid = channelCid;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="created_by_device_id")
    public void setCreatedByDeviceId(String createdByDeviceId) {
        this.createdByDeviceId = createdByDeviceId;
    }

    @JsonProperty(value="end_at")
    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="user_id")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharedLocation)) {
            return false;
        }
        SharedLocation other = (SharedLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        String this$channelCid = this.getChannelCid();
        String other$channelCid = other.getChannelCid();
        if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdByDeviceId = this.getCreatedByDeviceId();
        String other$createdByDeviceId = other.getCreatedByDeviceId();
        if (this$createdByDeviceId == null ? other$createdByDeviceId != null : !this$createdByDeviceId.equals(other$createdByDeviceId)) {
            return false;
        }
        Date this$endAt = this.getEndAt();
        Date other$endAt = other.getEndAt();
        if (this$endAt == null ? other$endAt != null : !((Object)this$endAt).equals(other$endAt)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SharedLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        String $channelCid = this.getChannelCid();
        result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdByDeviceId = this.getCreatedByDeviceId();
        result = result * 59 + ($createdByDeviceId == null ? 43 : $createdByDeviceId.hashCode());
        Date $endAt = this.getEndAt();
        result = result * 59 + ($endAt == null ? 43 : ((Object)$endAt).hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }

    public String toString() {
        return "SharedLocation(channelCid=" + this.getChannelCid() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", createdByDeviceId=" + this.getCreatedByDeviceId() + ", endAt=" + String.valueOf(this.getEndAt()) + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", messageId=" + this.getMessageId() + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", userId=" + this.getUserId() + ")";
    }

    public static class GetLocationsRequestData {
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetLocationsRequestData)) {
                return false;
            }
            GetLocationsRequestData other = (GetLocationsRequestData)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetLocationsRequestData;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public static class GetLocationsRequest
        extends StreamRequest<ActiveLiveLocationsResponse> {
            private String userId;

            public GetLocationsRequest userId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            protected Call<ActiveLiveLocationsResponse> generateCall(Client client) {
                return client.create(SharedLocationService.class).getLiveLocations(this.userId);
            }
        }
    }

    public static class UpdateLocationRequestData {
        @JsonProperty(value="request")
        @NotNull
        private SharedLocationRequest request;

        public UpdateLocationRequestData() {
        }

        public UpdateLocationRequestData(SharedLocationRequest request) {
            this.request = request;
        }

        public SharedLocationRequest getRequest() {
            return this.request;
        }

        public void setRequest(SharedLocationRequest request) {
            this.request = request;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateLocationRequestData)) {
                return false;
            }
            UpdateLocationRequestData other = (UpdateLocationRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SharedLocationRequest this$request = this.getRequest();
            SharedLocationRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateLocationRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SharedLocationRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            return result;
        }

        public static class UpdateLocationRequest
        extends StreamRequest<SharedLocationResponse> {
            private SharedLocationRequest request;
            private String userId;

            public UpdateLocationRequest() {
            }

            public UpdateLocationRequest(SharedLocationRequest request) {
                this.request = request;
            }

            public UpdateLocationRequest request(SharedLocationRequest request) {
                this.request = request;
                return this;
            }

            public UpdateLocationRequest userId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            protected Call<SharedLocationResponse> generateCall(Client client) {
                return client.create(SharedLocationService.class).updateLiveLocation(this.userId, this.request);
            }

            public SharedLocationRequest getRequest() {
                return this.request;
            }

            public String getUserId() {
                return this.userId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UpdateLocationRequest)) {
                    return false;
                }
                UpdateLocationRequest other = (UpdateLocationRequest)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                SharedLocationRequest this$request = this.getRequest();
                SharedLocationRequest other$request = other.getRequest();
                if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                    return false;
                }
                String this$userId = this.getUserId();
                String other$userId = other.getUserId();
                return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof UpdateLocationRequest;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                SharedLocationRequest $request = this.getRequest();
                result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
                String $userId = this.getUserId();
                result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
                return result;
            }
        }
    }

    public static class ActiveLiveLocationsResponse
    extends StreamResponseObject {
        @JsonProperty(value="active_live_locations")
        private List<SharedLocation> activeLiveLocations;

        public List<SharedLocation> getActiveLiveLocations() {
            return this.activeLiveLocations;
        }

        @JsonProperty(value="active_live_locations")
        public void setActiveLiveLocations(List<SharedLocation> activeLiveLocations) {
            this.activeLiveLocations = activeLiveLocations;
        }

        @Override
        public String toString() {
            return "SharedLocation.ActiveLiveLocationsResponse(activeLiveLocations=" + String.valueOf(this.getActiveLiveLocations()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActiveLiveLocationsResponse)) {
                return false;
            }
            ActiveLiveLocationsResponse other = (ActiveLiveLocationsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<SharedLocation> this$activeLiveLocations = this.getActiveLiveLocations();
            List<SharedLocation> other$activeLiveLocations = other.getActiveLiveLocations();
            return !(this$activeLiveLocations == null ? other$activeLiveLocations != null : !((Object)this$activeLiveLocations).equals(other$activeLiveLocations));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ActiveLiveLocationsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<SharedLocation> $activeLiveLocations = this.getActiveLiveLocations();
            result = result * 59 + ($activeLiveLocations == null ? 43 : ((Object)$activeLiveLocations).hashCode());
            return result;
        }
    }

    public static class SharedLocationResponse
    extends StreamResponseObject {
        @JsonProperty(value="created_by_device_id")
        private String createdByDeviceId;
        @JsonProperty(value="end_at")
        private String endAt;
        @JsonProperty(value="latitude")
        private Double latitude;
        @JsonProperty(value="longitude")
        private Double longitude;

        public String getCreatedByDeviceId() {
            return this.createdByDeviceId;
        }

        public String getEndAt() {
            return this.endAt;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        @JsonProperty(value="created_by_device_id")
        public void setCreatedByDeviceId(String createdByDeviceId) {
            this.createdByDeviceId = createdByDeviceId;
        }

        @JsonProperty(value="end_at")
        public void setEndAt(String endAt) {
            this.endAt = endAt;
        }

        @JsonProperty(value="latitude")
        public void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @JsonProperty(value="longitude")
        public void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public String toString() {
            return "SharedLocation.SharedLocationResponse(createdByDeviceId=" + this.getCreatedByDeviceId() + ", endAt=" + this.getEndAt() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SharedLocationResponse)) {
                return false;
            }
            SharedLocationResponse other = (SharedLocationResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Double this$latitude = this.getLatitude();
            Double other$latitude = other.getLatitude();
            if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
                return false;
            }
            Double this$longitude = this.getLongitude();
            Double other$longitude = other.getLongitude();
            if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
                return false;
            }
            String this$createdByDeviceId = this.getCreatedByDeviceId();
            String other$createdByDeviceId = other.getCreatedByDeviceId();
            if (this$createdByDeviceId == null ? other$createdByDeviceId != null : !this$createdByDeviceId.equals(other$createdByDeviceId)) {
                return false;
            }
            String this$endAt = this.getEndAt();
            String other$endAt = other.getEndAt();
            return !(this$endAt == null ? other$endAt != null : !this$endAt.equals(other$endAt));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof SharedLocationResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Double $latitude = this.getLatitude();
            result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
            Double $longitude = this.getLongitude();
            result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
            String $createdByDeviceId = this.getCreatedByDeviceId();
            result = result * 59 + ($createdByDeviceId == null ? 43 : $createdByDeviceId.hashCode());
            String $endAt = this.getEndAt();
            result = result * 59 + ($endAt == null ? 43 : $endAt.hashCode());
            return result;
        }
    }

    public static class SharedLocationRequest {
        @JsonProperty(value="message_id")
        private String messageId;
        @JsonProperty(value="created_by_device_id")
        private String createdByDeviceId;
        @JsonProperty(value="end_at")
        @Nullable
        private String endAt;
        @JsonProperty(value="latitude")
        @Nullable
        private Double latitude;
        @JsonProperty(value="longitude")
        @Nullable
        private Double longitude;
        @JsonProperty(value="user_id")
        private String userId;

        public String getMessageId() {
            return this.messageId;
        }

        public String getCreatedByDeviceId() {
            return this.createdByDeviceId;
        }

        @Nullable
        public String getEndAt() {
            return this.endAt;
        }

        @Nullable
        public Double getLatitude() {
            return this.latitude;
        }

        @Nullable
        public Double getLongitude() {
            return this.longitude;
        }

        public String getUserId() {
            return this.userId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="created_by_device_id")
        public void setCreatedByDeviceId(String createdByDeviceId) {
            this.createdByDeviceId = createdByDeviceId;
        }

        @JsonProperty(value="end_at")
        public void setEndAt(@Nullable String endAt) {
            this.endAt = endAt;
        }

        @JsonProperty(value="latitude")
        public void setLatitude(@Nullable Double latitude) {
            this.latitude = latitude;
        }

        @JsonProperty(value="longitude")
        public void setLongitude(@Nullable Double longitude) {
            this.longitude = longitude;
        }

        @JsonProperty(value="user_id")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SharedLocationRequest)) {
                return false;
            }
            SharedLocationRequest other = (SharedLocationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$latitude = this.getLatitude();
            Double other$latitude = other.getLatitude();
            if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
                return false;
            }
            Double this$longitude = this.getLongitude();
            Double other$longitude = other.getLongitude();
            if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
                return false;
            }
            String this$messageId = this.getMessageId();
            String other$messageId = other.getMessageId();
            if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
                return false;
            }
            String this$createdByDeviceId = this.getCreatedByDeviceId();
            String other$createdByDeviceId = other.getCreatedByDeviceId();
            if (this$createdByDeviceId == null ? other$createdByDeviceId != null : !this$createdByDeviceId.equals(other$createdByDeviceId)) {
                return false;
            }
            String this$endAt = this.getEndAt();
            String other$endAt = other.getEndAt();
            if (this$endAt == null ? other$endAt != null : !this$endAt.equals(other$endAt)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SharedLocationRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $latitude = this.getLatitude();
            result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
            Double $longitude = this.getLongitude();
            result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
            String $messageId = this.getMessageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            String $createdByDeviceId = this.getCreatedByDeviceId();
            result = result * 59 + ($createdByDeviceId == null ? 43 : $createdByDeviceId.hashCode());
            String $endAt = this.getEndAt();
            result = result * 59 + ($endAt == null ? 43 : $endAt.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        public String toString() {
            return "SharedLocation.SharedLocationRequest(messageId=" + this.getMessageId() + ", createdByDeviceId=" + this.getCreatedByDeviceId() + ", endAt=" + this.getEndAt() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", userId=" + this.getUserId() + ")";
        }
    }
}

