/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.ChannelType;
import io.getstream.chat.java.models.DeleteStrategy;
import io.getstream.chat.java.models.Event;
import io.getstream.chat.java.models.Language;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.MessagePaginationParameters;
import io.getstream.chat.java.models.PaginationParameters;
import io.getstream.chat.java.models.SharedLocation;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ChannelService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Channel {
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="type")
    @NotNull
    private String type;
    @JsonProperty(value="cid")
    @NotNull
    private String cId;
    @JsonProperty(value="team")
    @NotNull
    private String team;
    @JsonProperty(value="config")
    @NotNull
    private ChannelType.ChannelTypeWithCommands config;
    @JsonProperty(value="created_by")
    @Nullable
    private User createdBy;
    @JsonProperty(value="frozen")
    @NotNull
    private Boolean frozen;
    @JsonProperty(value="member_count")
    @NotNull
    private Integer memberCount;
    @JsonProperty(value="members")
    @Nullable
    private List<ChannelMember> members;
    @JsonProperty(value="messages")
    @Nullable
    private List<Message> messages;
    @JsonProperty(value="message_count")
    @Nullable
    private Integer messageCount;
    @JsonProperty(value="read")
    @Nullable
    private List<ChannelRead> read;
    @JsonProperty(value="created_at")
    @NotNull
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @NotNull
    private Date updatedAt;
    @JsonProperty(value="deleted_at")
    @Nullable
    private Date deletedAt;
    @JsonProperty(value="last_message_at")
    @Nullable
    private Date lastMessageAt;
    @JsonProperty(value="truncated_by_id")
    @Nullable
    private String truncatedById;
    @JsonProperty(value="truncated_by")
    @Nullable
    private User truncatedBy;
    @JsonProperty(value="filter_tags")
    @Nullable
    private List<String> filterTags;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static ChannelGetRequestData.ChannelGetRequest getOrCreate(@NotNull String type, @NotNull String id) {
        return new ChannelGetRequestData.ChannelGetRequest(type, id);
    }

    @NotNull
    public static ChannelGetRequestData.ChannelGetRequest getOrCreate(@NotNull String type) {
        return new ChannelGetRequestData.ChannelGetRequest(type, null);
    }

    @NotNull
    public static ChannelUpdateRequestData.ChannelUpdateRequest update(@NotNull String type, @NotNull String id) {
        return new ChannelUpdateRequestData.ChannelUpdateRequest(type, id);
    }

    @NotNull
    public static ChannelDeleteRequest delete(@NotNull String type, @NotNull String id) {
        return new ChannelDeleteRequest(type, id);
    }

    @NotNull
    public static ChannelDeleteManyRequest deleteMany(@NotNull List<String> cids) {
        return new ChannelDeleteManyRequest(cids);
    }

    @NotNull
    public static ChannelListRequestData.ChannelListRequest list() {
        return new ChannelListRequestData.ChannelListRequest();
    }

    @NotNull
    public static ChannelTruncateRequestData.ChannelTruncateRequest truncate(@NotNull String type, @NotNull String id) {
        return new ChannelTruncateRequestData.ChannelTruncateRequest(type, id);
    }

    @NotNull
    public static ChannelQueryMembersRequestData.ChannelQueryMembersRequest queryMembers() {
        return new ChannelQueryMembersRequestData.ChannelQueryMembersRequest();
    }

    @NotNull
    public static ChannelExportRequestData.ChannelExportRequest export() {
        return new ChannelExportRequestData.ChannelExportRequest();
    }

    @NotNull
    public static ChannelExportStatusRequest exportStatus(String taskId) {
        return new ChannelExportStatusRequest(taskId);
    }

    @NotNull
    public static ChannelHideRequestData.ChannelHideRequest hide(@NotNull String type, @NotNull String id) {
        return new ChannelHideRequestData.ChannelHideRequest(type, id);
    }

    @NotNull
    public static ChannelMarkAllReadRequestData.ChannelMarkAllReadRequest markAllRead() {
        return new ChannelMarkAllReadRequestData.ChannelMarkAllReadRequest();
    }

    @NotNull
    public static ChannelMarkReadRequestData.ChannelMarkReadRequest markRead(@NotNull String type, @NotNull String id) {
        return new ChannelMarkReadRequestData.ChannelMarkReadRequest(type, id);
    }

    @NotNull
    public static ChannelMuteRequestData.ChannelMuteRequest mute() {
        return new ChannelMuteRequestData.ChannelMuteRequest();
    }

    @NotNull
    public static ChannelShowRequestData.ChannelShowRequest show(@NotNull String type, @NotNull String id) {
        return new ChannelShowRequestData.ChannelShowRequest(type, id);
    }

    @NotNull
    public static ChannelUnMuteRequestData.ChannelUnMuteRequest unmute() {
        return new ChannelUnMuteRequestData.ChannelUnMuteRequest();
    }

    @NotNull
    public static ChannelPartialUpdateRequestData.ChannelPartialUpdateRequest partialUpdate(@NotNull String type, @NotNull String id) {
        return new ChannelPartialUpdateRequestData.ChannelPartialUpdateRequest(type, id);
    }

    @NotNull
    public static AssignRoleRequestData.AssignRoleRequest assignRoles(@NotNull String type, @NotNull String id) {
        return new AssignRoleRequestData.AssignRoleRequest(type, id);
    }

    @NotNull
    public static ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest updateMemberPartial(@NotNull String type, @NotNull String id, @NotNull String userId) {
        return new ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest(type, id, userId);
    }

    @NotNull
    public static ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest pin(@NotNull String type, @NotNull String id, @NotNull String userId) {
        return new ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest(type, id, userId).setValue("pinned", true);
    }

    @NotNull
    public static ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest unpin(@NotNull String type, @NotNull String id, @NotNull String userId) {
        return new ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest(type, id, userId).setValue("pinned", false);
    }

    @NotNull
    public static ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest archive(@NotNull String type, @NotNull String id, @NotNull String userId) {
        return new ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest(type, id, userId).setValue("archived", true);
    }

    @NotNull
    public static ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest unarchive(@NotNull String type, @NotNull String id, @NotNull String userId) {
        return new ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest(type, id, userId).setValue("archived", false);
    }

    @NotNull
    public static MarkDeliveredRequestData.MarkDeliveredRequest markDelivered() {
        return new MarkDeliveredRequestData.MarkDeliveredRequest();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public String getCId() {
        return this.cId;
    }

    @NotNull
    public String getTeam() {
        return this.team;
    }

    @NotNull
    public ChannelType.ChannelTypeWithCommands getConfig() {
        return this.config;
    }

    @Nullable
    public User getCreatedBy() {
        return this.createdBy;
    }

    @NotNull
    public Boolean getFrozen() {
        return this.frozen;
    }

    @NotNull
    public Integer getMemberCount() {
        return this.memberCount;
    }

    @Nullable
    public List<ChannelMember> getMembers() {
        return this.members;
    }

    @Nullable
    public List<Message> getMessages() {
        return this.messages;
    }

    @Nullable
    public Integer getMessageCount() {
        return this.messageCount;
    }

    @Nullable
    public List<ChannelRead> getRead() {
        return this.read;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Nullable
    public Date getLastMessageAt() {
        return this.lastMessageAt;
    }

    @Nullable
    public String getTruncatedById() {
        return this.truncatedById;
    }

    @Nullable
    public User getTruncatedBy() {
        return this.truncatedBy;
    }

    @Nullable
    public List<String> getFilterTags() {
        return this.filterTags;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="type")
    public void setType(@NotNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="cid")
    public void setCId(@NotNull String cId) {
        if (cId == null) {
            throw new NullPointerException("cId is marked non-null but is null");
        }
        this.cId = cId;
    }

    @JsonProperty(value="team")
    public void setTeam(@NotNull String team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.team = team;
    }

    @JsonProperty(value="config")
    public void setConfig(@NotNull ChannelType.ChannelTypeWithCommands config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    @JsonProperty(value="created_by")
    public void setCreatedBy(@Nullable User createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="frozen")
    public void setFrozen(@NotNull Boolean frozen) {
        if (frozen == null) {
            throw new NullPointerException("frozen is marked non-null but is null");
        }
        this.frozen = frozen;
    }

    @JsonProperty(value="member_count")
    public void setMemberCount(@NotNull Integer memberCount) {
        if (memberCount == null) {
            throw new NullPointerException("memberCount is marked non-null but is null");
        }
        this.memberCount = memberCount;
    }

    @JsonProperty(value="members")
    public void setMembers(@Nullable List<ChannelMember> members) {
        this.members = members;
    }

    @JsonProperty(value="messages")
    public void setMessages(@Nullable List<Message> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="message_count")
    public void setMessageCount(@Nullable Integer messageCount) {
        this.messageCount = messageCount;
    }

    @JsonProperty(value="read")
    public void setRead(@Nullable List<ChannelRead> read) {
        this.read = read;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@NotNull Date createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@NotNull Date updatedAt) {
        if (updatedAt == null) {
            throw new NullPointerException("updatedAt is marked non-null but is null");
        }
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="deleted_at")
    public void setDeletedAt(@Nullable Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    @JsonProperty(value="last_message_at")
    public void setLastMessageAt(@Nullable Date lastMessageAt) {
        this.lastMessageAt = lastMessageAt;
    }

    @JsonProperty(value="truncated_by_id")
    public void setTruncatedById(@Nullable String truncatedById) {
        this.truncatedById = truncatedById;
    }

    @JsonProperty(value="truncated_by")
    public void setTruncatedBy(@Nullable User truncatedBy) {
        this.truncatedBy = truncatedBy;
    }

    @JsonProperty(value="filter_tags")
    public void setFilterTags(@Nullable List<String> filterTags) {
        this.filterTags = filterTags;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$frozen = this.getFrozen();
        Boolean other$frozen = other.getFrozen();
        if (this$frozen == null ? other$frozen != null : !((Object)this$frozen).equals(other$frozen)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        Integer this$messageCount = this.getMessageCount();
        Integer other$messageCount = other.getMessageCount();
        if (this$messageCount == null ? other$messageCount != null : !((Object)this$messageCount).equals(other$messageCount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$cId = this.getCId();
        String other$cId = other.getCId();
        if (this$cId == null ? other$cId != null : !this$cId.equals(other$cId)) {
            return false;
        }
        String this$team = this.getTeam();
        String other$team = other.getTeam();
        if (this$team == null ? other$team != null : !this$team.equals(other$team)) {
            return false;
        }
        ChannelType.ChannelTypeWithCommands this$config = this.getConfig();
        ChannelType.ChannelTypeWithCommands other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        User this$createdBy = this.getCreatedBy();
        User other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        List<ChannelMember> this$members = this.getMembers();
        List<ChannelMember> other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<ChannelRead> this$read = this.getRead();
        List<ChannelRead> other$read = other.getRead();
        if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Date this$deletedAt = this.getDeletedAt();
        Date other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        Date this$lastMessageAt = this.getLastMessageAt();
        Date other$lastMessageAt = other.getLastMessageAt();
        if (this$lastMessageAt == null ? other$lastMessageAt != null : !((Object)this$lastMessageAt).equals(other$lastMessageAt)) {
            return false;
        }
        String this$truncatedById = this.getTruncatedById();
        String other$truncatedById = other.getTruncatedById();
        if (this$truncatedById == null ? other$truncatedById != null : !this$truncatedById.equals(other$truncatedById)) {
            return false;
        }
        User this$truncatedBy = this.getTruncatedBy();
        User other$truncatedBy = other.getTruncatedBy();
        if (this$truncatedBy == null ? other$truncatedBy != null : !((Object)this$truncatedBy).equals(other$truncatedBy)) {
            return false;
        }
        List<String> this$filterTags = this.getFilterTags();
        List<String> other$filterTags = other.getFilterTags();
        if (this$filterTags == null ? other$filterTags != null : !((Object)this$filterTags).equals(other$filterTags)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Channel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $frozen = this.getFrozen();
        result = result * 59 + ($frozen == null ? 43 : ((Object)$frozen).hashCode());
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        Integer $messageCount = this.getMessageCount();
        result = result * 59 + ($messageCount == null ? 43 : ((Object)$messageCount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $cId = this.getCId();
        result = result * 59 + ($cId == null ? 43 : $cId.hashCode());
        String $team = this.getTeam();
        result = result * 59 + ($team == null ? 43 : $team.hashCode());
        ChannelType.ChannelTypeWithCommands $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        User $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        List<ChannelMember> $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<ChannelRead> $read = this.getRead();
        result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Date $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        Date $lastMessageAt = this.getLastMessageAt();
        result = result * 59 + ($lastMessageAt == null ? 43 : ((Object)$lastMessageAt).hashCode());
        String $truncatedById = this.getTruncatedById();
        result = result * 59 + ($truncatedById == null ? 43 : $truncatedById.hashCode());
        User $truncatedBy = this.getTruncatedBy();
        result = result * 59 + ($truncatedBy == null ? 43 : ((Object)$truncatedBy).hashCode());
        List<String> $filterTags = this.getFilterTags();
        result = result * 59 + ($filterTags == null ? 43 : ((Object)$filterTags).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Channel(id=" + this.getId() + ", type=" + this.getType() + ", cId=" + this.getCId() + ", team=" + this.getTeam() + ", config=" + String.valueOf(this.getConfig()) + ", createdBy=" + String.valueOf(this.getCreatedBy()) + ", frozen=" + this.getFrozen() + ", memberCount=" + this.getMemberCount() + ", members=" + String.valueOf(this.getMembers()) + ", messages=" + String.valueOf(this.getMessages()) + ", messageCount=" + this.getMessageCount() + ", read=" + String.valueOf(this.getRead()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", lastMessageAt=" + String.valueOf(this.getLastMessageAt()) + ", truncatedById=" + this.getTruncatedById() + ", truncatedBy=" + String.valueOf(this.getTruncatedBy()) + ", filterTags=" + String.valueOf(this.getFilterTags()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ")";
    }

    public static class LatestDeliveredMessage {
        @JsonProperty(value="cid")
        @NotNull
        private String cid;
        @JsonProperty(value="id")
        @NotNull
        private String messageId;

        @NotNull
        public String getCid() {
            return this.cid;
        }

        @NotNull
        public String getMessageId() {
            return this.messageId;
        }

        @JsonProperty(value="cid")
        public void setCid(@NotNull String cid) {
            if (cid == null) {
                throw new NullPointerException("cid is marked non-null but is null");
            }
            this.cid = cid;
        }

        @JsonProperty(value="id")
        public void setMessageId(@NotNull String messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LatestDeliveredMessage)) {
                return false;
            }
            LatestDeliveredMessage other = (LatestDeliveredMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cid = this.getCid();
            String other$cid = other.getCid();
            if (this$cid == null ? other$cid != null : !this$cid.equals(other$cid)) {
                return false;
            }
            String this$messageId = this.getMessageId();
            String other$messageId = other.getMessageId();
            return !(this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LatestDeliveredMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cid = this.getCid();
            result = result * 59 + ($cid == null ? 43 : $cid.hashCode());
            String $messageId = this.getMessageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            return result;
        }

        public String toString() {
            return "Channel.LatestDeliveredMessage(cid=" + this.getCid() + ", messageId=" + this.getMessageId() + ")";
        }

        public LatestDeliveredMessage() {
        }

        public LatestDeliveredMessage(@NotNull String cid, @NotNull String messageId) {
            if (cid == null) {
                throw new NullPointerException("cid is marked non-null but is null");
            }
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.cid = cid;
            this.messageId = messageId;
        }
    }

    public static class ChannelPartialUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @NotNull
        private Channel channel;
        @JsonProperty(value="members")
        @NotNull
        private List<ChannelMember> members;

        @NotNull
        public Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @JsonProperty(value="channel")
        public void setChannel(@NotNull Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
        }

        @JsonProperty(value="members")
        public void setMembers(@NotNull List<ChannelMember> members) {
            if (members == null) {
                throw new NullPointerException("members is marked non-null but is null");
            }
            this.members = members;
        }

        @Override
        public String toString() {
            return "Channel.ChannelPartialUpdateResponse(channel=" + String.valueOf(this.getChannel()) + ", members=" + String.valueOf(this.getMembers()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelPartialUpdateResponse)) {
                return false;
            }
            ChannelPartialUpdateResponse other = (ChannelPartialUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelPartialUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }
    }

    public static class ChannelPinResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_mute")
        @Nullable
        private User.ChannelMute channelMute;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<User.ChannelMute> channelMutes;
        @JsonProperty(value="own_user")
        @Nullable
        private User.OwnUser ownUser;

        @Nullable
        public User.ChannelMute getChannelMute() {
            return this.channelMute;
        }

        @Nullable
        public List<User.ChannelMute> getChannelMutes() {
            return this.channelMutes;
        }

        @Nullable
        public User.OwnUser getOwnUser() {
            return this.ownUser;
        }

        @JsonProperty(value="channel_mute")
        public void setChannelMute(@Nullable User.ChannelMute channelMute) {
            this.channelMute = channelMute;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<User.ChannelMute> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="own_user")
        public void setOwnUser(@Nullable User.OwnUser ownUser) {
            this.ownUser = ownUser;
        }

        @Override
        public String toString() {
            return "Channel.ChannelPinResponse(channelMute=" + String.valueOf(this.getChannelMute()) + ", channelMutes=" + String.valueOf(this.getChannelMutes()) + ", ownUser=" + String.valueOf(this.getOwnUser()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelPinResponse)) {
                return false;
            }
            ChannelPinResponse other = (ChannelPinResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User.ChannelMute this$channelMute = this.getChannelMute();
            User.ChannelMute other$channelMute = other.getChannelMute();
            if (this$channelMute == null ? other$channelMute != null : !((Object)this$channelMute).equals(other$channelMute)) {
                return false;
            }
            List<User.ChannelMute> this$channelMutes = this.getChannelMutes();
            List<User.ChannelMute> other$channelMutes = other.getChannelMutes();
            if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
                return false;
            }
            User.OwnUser this$ownUser = this.getOwnUser();
            User.OwnUser other$ownUser = other.getOwnUser();
            return !(this$ownUser == null ? other$ownUser != null : !((Object)this$ownUser).equals(other$ownUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelPinResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User.ChannelMute $channelMute = this.getChannelMute();
            result = result * 59 + ($channelMute == null ? 43 : ((Object)$channelMute).hashCode());
            List<User.ChannelMute> $channelMutes = this.getChannelMutes();
            result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
            User.OwnUser $ownUser = this.getOwnUser();
            result = result * 59 + ($ownUser == null ? 43 : ((Object)$ownUser).hashCode());
            return result;
        }
    }

    public static class ChannelUnMuteResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_mute")
        @Nullable
        private User.ChannelMute channelMute;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<User.ChannelMute> channelMutes;
        @JsonProperty(value="own_user")
        @Nullable
        private User.OwnUser ownUser;

        @Nullable
        public User.ChannelMute getChannelMute() {
            return this.channelMute;
        }

        @Nullable
        public List<User.ChannelMute> getChannelMutes() {
            return this.channelMutes;
        }

        @Nullable
        public User.OwnUser getOwnUser() {
            return this.ownUser;
        }

        @JsonProperty(value="channel_mute")
        public void setChannelMute(@Nullable User.ChannelMute channelMute) {
            this.channelMute = channelMute;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<User.ChannelMute> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="own_user")
        public void setOwnUser(@Nullable User.OwnUser ownUser) {
            this.ownUser = ownUser;
        }

        @Override
        public String toString() {
            return "Channel.ChannelUnMuteResponse(channelMute=" + String.valueOf(this.getChannelMute()) + ", channelMutes=" + String.valueOf(this.getChannelMutes()) + ", ownUser=" + String.valueOf(this.getOwnUser()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelUnMuteResponse)) {
                return false;
            }
            ChannelUnMuteResponse other = (ChannelUnMuteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User.ChannelMute this$channelMute = this.getChannelMute();
            User.ChannelMute other$channelMute = other.getChannelMute();
            if (this$channelMute == null ? other$channelMute != null : !((Object)this$channelMute).equals(other$channelMute)) {
                return false;
            }
            List<User.ChannelMute> this$channelMutes = this.getChannelMutes();
            List<User.ChannelMute> other$channelMutes = other.getChannelMutes();
            if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
                return false;
            }
            User.OwnUser this$ownUser = this.getOwnUser();
            User.OwnUser other$ownUser = other.getOwnUser();
            return !(this$ownUser == null ? other$ownUser != null : !((Object)this$ownUser).equals(other$ownUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelUnMuteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User.ChannelMute $channelMute = this.getChannelMute();
            result = result * 59 + ($channelMute == null ? 43 : ((Object)$channelMute).hashCode());
            List<User.ChannelMute> $channelMutes = this.getChannelMutes();
            result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
            User.OwnUser $ownUser = this.getOwnUser();
            result = result * 59 + ($ownUser == null ? 43 : ((Object)$ownUser).hashCode());
            return result;
        }
    }

    public static class ChannelMuteResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_mute")
        @Nullable
        private User.ChannelMute channelMute;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<User.ChannelMute> channelMutes;
        @JsonProperty(value="own_user")
        @Nullable
        private User.OwnUser ownUser;

        @Nullable
        public User.ChannelMute getChannelMute() {
            return this.channelMute;
        }

        @Nullable
        public List<User.ChannelMute> getChannelMutes() {
            return this.channelMutes;
        }

        @Nullable
        public User.OwnUser getOwnUser() {
            return this.ownUser;
        }

        @JsonProperty(value="channel_mute")
        public void setChannelMute(@Nullable User.ChannelMute channelMute) {
            this.channelMute = channelMute;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<User.ChannelMute> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="own_user")
        public void setOwnUser(@Nullable User.OwnUser ownUser) {
            this.ownUser = ownUser;
        }

        @Override
        public String toString() {
            return "Channel.ChannelMuteResponse(channelMute=" + String.valueOf(this.getChannelMute()) + ", channelMutes=" + String.valueOf(this.getChannelMutes()) + ", ownUser=" + String.valueOf(this.getOwnUser()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMuteResponse)) {
                return false;
            }
            ChannelMuteResponse other = (ChannelMuteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User.ChannelMute this$channelMute = this.getChannelMute();
            User.ChannelMute other$channelMute = other.getChannelMute();
            if (this$channelMute == null ? other$channelMute != null : !((Object)this$channelMute).equals(other$channelMute)) {
                return false;
            }
            List<User.ChannelMute> this$channelMutes = this.getChannelMutes();
            List<User.ChannelMute> other$channelMutes = other.getChannelMutes();
            if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
                return false;
            }
            User.OwnUser this$ownUser = this.getOwnUser();
            User.OwnUser other$ownUser = other.getOwnUser();
            return !(this$ownUser == null ? other$ownUser != null : !((Object)this$ownUser).equals(other$ownUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelMuteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User.ChannelMute $channelMute = this.getChannelMute();
            result = result * 59 + ($channelMute == null ? 43 : ((Object)$channelMute).hashCode());
            List<User.ChannelMute> $channelMutes = this.getChannelMutes();
            result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
            User.OwnUser $ownUser = this.getOwnUser();
            result = result * 59 + ($ownUser == null ? 43 : ((Object)$ownUser).hashCode());
            return result;
        }
    }

    public static class ChannelMarkReadResponse
    extends StreamResponseObject {
        @JsonProperty(value="event")
        @Nullable
        private Event event;

        @Nullable
        public Event getEvent() {
            return this.event;
        }

        @JsonProperty(value="event")
        public void setEvent(@Nullable Event event) {
            this.event = event;
        }

        @Override
        public String toString() {
            return "Channel.ChannelMarkReadResponse(event=" + String.valueOf(this.getEvent()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMarkReadResponse)) {
                return false;
            }
            ChannelMarkReadResponse other = (ChannelMarkReadResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelMarkReadResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            return result;
        }
    }

    public static class ChannelExportStatusResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        @NotNull
        private String taskId;
        @JsonProperty(value="status")
        @NotNull
        private Status status;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;
        @JsonProperty(value="result")
        @Nullable
        private ExportChannelsResult result;
        @JsonProperty(value="error")
        @Nullable
        private ErrorResult error;

        @NotNull
        public String getTaskId() {
            return this.taskId;
        }

        @NotNull
        public Status getStatus() {
            return this.status;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @Nullable
        public ExportChannelsResult getResult() {
            return this.result;
        }

        @Nullable
        public ErrorResult getError() {
            return this.error;
        }

        @JsonProperty(value="task_id")
        public void setTaskId(@NotNull String taskId) {
            if (taskId == null) {
                throw new NullPointerException("taskId is marked non-null but is null");
            }
            this.taskId = taskId;
        }

        @JsonProperty(value="status")
        public void setStatus(@NotNull Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @JsonProperty(value="result")
        public void setResult(@Nullable ExportChannelsResult result) {
            this.result = result;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable ErrorResult error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "Channel.ChannelExportStatusResponse(taskId=" + this.getTaskId() + ", status=" + String.valueOf((Object)this.getStatus()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", duration=" + this.getDuration() + ", result=" + String.valueOf(this.getResult()) + ", error=" + String.valueOf(this.getError()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportStatusResponse)) {
                return false;
            }
            ChannelExportStatusResponse other = (ChannelExportStatusResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            ExportChannelsResult this$result = this.getResult();
            ExportChannelsResult other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
                return false;
            }
            ErrorResult this$error = this.getError();
            ErrorResult other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportStatusResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            ExportChannelsResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            ErrorResult $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        public static class ErrorResult {
            @JsonProperty(value="type")
            @Nullable
            private String type;
            @JsonProperty(value="description")
            @Nullable
            private String description;
            @JsonProperty(value="stacktrace")
            @Nullable
            private String stacktrace;
            @JsonProperty(value="version")
            @Nullable
            private String version;

            @Nullable
            public String getType() {
                return this.type;
            }

            @Nullable
            public String getDescription() {
                return this.description;
            }

            @Nullable
            public String getStacktrace() {
                return this.stacktrace;
            }

            @Nullable
            public String getVersion() {
                return this.version;
            }

            @JsonProperty(value="type")
            public void setType(@Nullable String type) {
                this.type = type;
            }

            @JsonProperty(value="description")
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @JsonProperty(value="stacktrace")
            public void setStacktrace(@Nullable String stacktrace) {
                this.stacktrace = stacktrace;
            }

            @JsonProperty(value="version")
            public void setVersion(@Nullable String version) {
                this.version = version;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ErrorResult)) {
                    return false;
                }
                ErrorResult other = (ErrorResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$stacktrace = this.getStacktrace();
                String other$stacktrace = other.getStacktrace();
                if (this$stacktrace == null ? other$stacktrace != null : !this$stacktrace.equals(other$stacktrace)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ErrorResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $stacktrace = this.getStacktrace();
                result = result * 59 + ($stacktrace == null ? 43 : $stacktrace.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            public String toString() {
                return "Channel.ChannelExportStatusResponse.ErrorResult(type=" + this.getType() + ", description=" + this.getDescription() + ", stacktrace=" + this.getStacktrace() + ", version=" + this.getVersion() + ")";
            }
        }

        public static class ExportChannelsResult {
            @JsonProperty(value="url")
            @NotNull
            private String url;
            @JsonProperty(value="path")
            @NotNull
            private String path;
            @JsonProperty(value="s3_bucket_name")
            @NotNull
            private String s3BucketName;

            @NotNull
            public String getUrl() {
                return this.url;
            }

            @NotNull
            public String getPath() {
                return this.path;
            }

            @NotNull
            public String getS3BucketName() {
                return this.s3BucketName;
            }

            @JsonProperty(value="url")
            public void setUrl(@NotNull String url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                this.url = url;
            }

            @JsonProperty(value="path")
            public void setPath(@NotNull String path) {
                if (path == null) {
                    throw new NullPointerException("path is marked non-null but is null");
                }
                this.path = path;
            }

            @JsonProperty(value="s3_bucket_name")
            public void setS3BucketName(@NotNull String s3BucketName) {
                if (s3BucketName == null) {
                    throw new NullPointerException("s3BucketName is marked non-null but is null");
                }
                this.s3BucketName = s3BucketName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExportChannelsResult)) {
                    return false;
                }
                ExportChannelsResult other = (ExportChannelsResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                    return false;
                }
                String this$s3BucketName = this.getS3BucketName();
                String other$s3BucketName = other.getS3BucketName();
                return !(this$s3BucketName == null ? other$s3BucketName != null : !this$s3BucketName.equals(other$s3BucketName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ExportChannelsResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                String $s3BucketName = this.getS3BucketName();
                result = result * 59 + ($s3BucketName == null ? 43 : $s3BucketName.hashCode());
                return result;
            }

            public String toString() {
                return "Channel.ChannelExportStatusResponse.ExportChannelsResult(url=" + this.getUrl() + ", path=" + this.getPath() + ", s3BucketName=" + this.getS3BucketName() + ")";
            }
        }

        public static enum Status {
            WAITING,
            PENDING,
            RUNNING,
            COMPLETED,
            FAILED,
            UNKNOWN;

        }
    }

    public static class ChannelExportResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        @NotNull
        private String taskId;

        @NotNull
        public String getTaskId() {
            return this.taskId;
        }

        @JsonProperty(value="task_id")
        public void setTaskId(@NotNull String taskId) {
            if (taskId == null) {
                throw new NullPointerException("taskId is marked non-null but is null");
            }
            this.taskId = taskId;
        }

        @Override
        public String toString() {
            return "Channel.ChannelExportResponse(taskId=" + this.getTaskId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportResponse)) {
                return false;
            }
            ChannelExportResponse other = (ChannelExportResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }
    }

    public static class ChannelQueryMembersResponse
    extends StreamResponseObject {
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMember> members;

        @Nullable
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMember> members) {
            this.members = members;
        }

        @Override
        public String toString() {
            return "Channel.ChannelQueryMembersResponse(members=" + String.valueOf(this.getMembers()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelQueryMembersResponse)) {
                return false;
            }
            ChannelQueryMembersResponse other = (ChannelQueryMembersResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelQueryMembersResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }
    }

    public static class ChannelTruncateResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return "Channel.ChannelTruncateResponse(channel=" + String.valueOf(this.getChannel()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTruncateResponse)) {
                return false;
            }
            ChannelTruncateResponse other = (ChannelTruncateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTruncateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            return result;
        }
    }

    public static class ChannelListResponse
    extends StreamResponseObject {
        @JsonProperty(value="channels")
        @Nullable
        private List<ChannelGetResponse> channels;

        @Nullable
        public List<ChannelGetResponse> getChannels() {
            return this.channels;
        }

        @JsonProperty(value="channels")
        public void setChannels(@Nullable List<ChannelGetResponse> channels) {
            this.channels = channels;
        }

        @Override
        public String toString() {
            return "Channel.ChannelListResponse(channels=" + String.valueOf(this.getChannels()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelListResponse)) {
                return false;
            }
            ChannelListResponse other = (ChannelListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<ChannelGetResponse> this$channels = this.getChannels();
            List<ChannelGetResponse> other$channels = other.getChannels();
            return !(this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<ChannelGetResponse> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            return result;
        }
    }

    public static class ChannelDeleteManyResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        private String taskId;

        @JsonProperty(value="task_id")
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public String toString() {
            return "Channel.ChannelDeleteManyResponse(taskId=" + this.getTaskId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelDeleteManyResponse)) {
                return false;
            }
            ChannelDeleteManyResponse other = (ChannelDeleteManyResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelDeleteManyResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }

        public String getTaskId() {
            return this.taskId;
        }
    }

    public static class ChannelDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return "Channel.ChannelDeleteResponse(channel=" + String.valueOf(this.getChannel()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelDeleteResponse)) {
                return false;
            }
            ChannelDeleteResponse other = (ChannelDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            return result;
        }
    }

    public static class ChannelUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="message")
        @Nullable
        private Message message;
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMember> members;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public Message getMessage() {
            return this.message;
        }

        @Nullable
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable Message message) {
            this.message = message;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMember> members) {
            this.members = members;
        }

        @Override
        public String toString() {
            return "Channel.ChannelUpdateResponse(channel=" + String.valueOf(this.getChannel()) + ", message=" + String.valueOf(this.getMessage()) + ", members=" + String.valueOf(this.getMembers()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelUpdateResponse)) {
                return false;
            }
            ChannelUpdateResponse other = (ChannelUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }
    }

    public static class ChannelGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="messages")
        @Nullable
        private List<Message> messages;
        @JsonProperty(value="pinned_messages")
        @Nullable
        private List<Message> pinnedMessages;
        @JsonProperty(value="pending_messages")
        @Nullable
        private List<Message> pendingMessages;
        @JsonProperty(value="watcher_count")
        @Nullable
        private Integer watcher_count;
        @JsonProperty(value="watchers")
        @Nullable
        private List<User> watchers;
        @JsonProperty(value="read")
        @Nullable
        private List<ChannelRead> read;
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMember> members;
        @JsonProperty(value="membership")
        @Nullable
        private ChannelMember membership;
        @JsonProperty(value="hidden")
        @Nullable
        private Boolean hidden;
        @JsonProperty(value="hide_messages_before")
        @Nullable
        private Date hideMessagesBefore;
        @JsonProperty(value="active_live_locations")
        @Nullable
        private List<SharedLocation> activeLiveLocations;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public List<Message> getMessages() {
            return this.messages;
        }

        @Nullable
        public List<Message> getPinnedMessages() {
            return this.pinnedMessages;
        }

        @Nullable
        public List<Message> getPendingMessages() {
            return this.pendingMessages;
        }

        @Nullable
        public Integer getWatcher_count() {
            return this.watcher_count;
        }

        @Nullable
        public List<User> getWatchers() {
            return this.watchers;
        }

        @Nullable
        public List<ChannelRead> getRead() {
            return this.read;
        }

        @Nullable
        public List<ChannelMember> getMembers() {
            return this.members;
        }

        @Nullable
        public ChannelMember getMembership() {
            return this.membership;
        }

        @Nullable
        public Boolean getHidden() {
            return this.hidden;
        }

        @Nullable
        public Date getHideMessagesBefore() {
            return this.hideMessagesBefore;
        }

        @Nullable
        public List<SharedLocation> getActiveLiveLocations() {
            return this.activeLiveLocations;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="messages")
        public void setMessages(@Nullable List<Message> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="pinned_messages")
        public void setPinnedMessages(@Nullable List<Message> pinnedMessages) {
            this.pinnedMessages = pinnedMessages;
        }

        @JsonProperty(value="pending_messages")
        public void setPendingMessages(@Nullable List<Message> pendingMessages) {
            this.pendingMessages = pendingMessages;
        }

        @JsonProperty(value="watcher_count")
        public void setWatcher_count(@Nullable Integer watcher_count) {
            this.watcher_count = watcher_count;
        }

        @JsonProperty(value="watchers")
        public void setWatchers(@Nullable List<User> watchers) {
            this.watchers = watchers;
        }

        @JsonProperty(value="read")
        public void setRead(@Nullable List<ChannelRead> read) {
            this.read = read;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMember> members) {
            this.members = members;
        }

        @JsonProperty(value="membership")
        public void setMembership(@Nullable ChannelMember membership) {
            this.membership = membership;
        }

        @JsonProperty(value="hidden")
        public void setHidden(@Nullable Boolean hidden) {
            this.hidden = hidden;
        }

        @JsonProperty(value="hide_messages_before")
        public void setHideMessagesBefore(@Nullable Date hideMessagesBefore) {
            this.hideMessagesBefore = hideMessagesBefore;
        }

        @JsonProperty(value="active_live_locations")
        public void setActiveLiveLocations(@Nullable List<SharedLocation> activeLiveLocations) {
            this.activeLiveLocations = activeLiveLocations;
        }

        @Override
        public String toString() {
            return "Channel.ChannelGetResponse(channel=" + String.valueOf(this.getChannel()) + ", messages=" + String.valueOf(this.getMessages()) + ", pinnedMessages=" + String.valueOf(this.getPinnedMessages()) + ", pendingMessages=" + String.valueOf(this.getPendingMessages()) + ", watcher_count=" + this.getWatcher_count() + ", watchers=" + String.valueOf(this.getWatchers()) + ", read=" + String.valueOf(this.getRead()) + ", members=" + String.valueOf(this.getMembers()) + ", membership=" + String.valueOf(this.getMembership()) + ", hidden=" + this.getHidden() + ", hideMessagesBefore=" + String.valueOf(this.getHideMessagesBefore()) + ", activeLiveLocations=" + String.valueOf(this.getActiveLiveLocations()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelGetResponse)) {
                return false;
            }
            ChannelGetResponse other = (ChannelGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$watcher_count = this.getWatcher_count();
            Integer other$watcher_count = other.getWatcher_count();
            if (this$watcher_count == null ? other$watcher_count != null : !((Object)this$watcher_count).equals(other$watcher_count)) {
                return false;
            }
            Boolean this$hidden = this.getHidden();
            Boolean other$hidden = other.getHidden();
            if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            List<Message> this$pinnedMessages = this.getPinnedMessages();
            List<Message> other$pinnedMessages = other.getPinnedMessages();
            if (this$pinnedMessages == null ? other$pinnedMessages != null : !((Object)this$pinnedMessages).equals(other$pinnedMessages)) {
                return false;
            }
            List<Message> this$pendingMessages = this.getPendingMessages();
            List<Message> other$pendingMessages = other.getPendingMessages();
            if (this$pendingMessages == null ? other$pendingMessages != null : !((Object)this$pendingMessages).equals(other$pendingMessages)) {
                return false;
            }
            List<User> this$watchers = this.getWatchers();
            List<User> other$watchers = other.getWatchers();
            if (this$watchers == null ? other$watchers != null : !((Object)this$watchers).equals(other$watchers)) {
                return false;
            }
            List<ChannelRead> this$read = this.getRead();
            List<ChannelRead> other$read = other.getRead();
            if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
                return false;
            }
            List<ChannelMember> this$members = this.getMembers();
            List<ChannelMember> other$members = other.getMembers();
            if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
                return false;
            }
            ChannelMember this$membership = this.getMembership();
            ChannelMember other$membership = other.getMembership();
            if (this$membership == null ? other$membership != null : !((Object)this$membership).equals(other$membership)) {
                return false;
            }
            Date this$hideMessagesBefore = this.getHideMessagesBefore();
            Date other$hideMessagesBefore = other.getHideMessagesBefore();
            if (this$hideMessagesBefore == null ? other$hideMessagesBefore != null : !((Object)this$hideMessagesBefore).equals(other$hideMessagesBefore)) {
                return false;
            }
            List<SharedLocation> this$activeLiveLocations = this.getActiveLiveLocations();
            List<SharedLocation> other$activeLiveLocations = other.getActiveLiveLocations();
            return !(this$activeLiveLocations == null ? other$activeLiveLocations != null : !((Object)this$activeLiveLocations).equals(other$activeLiveLocations));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $watcher_count = this.getWatcher_count();
            result = result * 59 + ($watcher_count == null ? 43 : ((Object)$watcher_count).hashCode());
            Boolean $hidden = this.getHidden();
            result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            List<Message> $pinnedMessages = this.getPinnedMessages();
            result = result * 59 + ($pinnedMessages == null ? 43 : ((Object)$pinnedMessages).hashCode());
            List<Message> $pendingMessages = this.getPendingMessages();
            result = result * 59 + ($pendingMessages == null ? 43 : ((Object)$pendingMessages).hashCode());
            List<User> $watchers = this.getWatchers();
            result = result * 59 + ($watchers == null ? 43 : ((Object)$watchers).hashCode());
            List<ChannelRead> $read = this.getRead();
            result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
            List<ChannelMember> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            ChannelMember $membership = this.getMembership();
            result = result * 59 + ($membership == null ? 43 : ((Object)$membership).hashCode());
            Date $hideMessagesBefore = this.getHideMessagesBefore();
            result = result * 59 + ($hideMessagesBefore == null ? 43 : ((Object)$hideMessagesBefore).hashCode());
            List<SharedLocation> $activeLiveLocations = this.getActiveLiveLocations();
            result = result * 59 + ($activeLiveLocations == null ? 43 : ((Object)$activeLiveLocations).hashCode());
            return result;
        }
    }

    public static class ChannelMemberResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_member")
        @Nullable
        private ChannelMember member;

        @Nullable
        public ChannelMember getMember() {
            return this.member;
        }

        @JsonProperty(value="channel_member")
        public void setMember(@Nullable ChannelMember member) {
            this.member = member;
        }

        @Override
        public String toString() {
            return "Channel.ChannelMemberResponse(member=" + String.valueOf(this.getMember()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMemberResponse)) {
                return false;
            }
            ChannelMemberResponse other = (ChannelMemberResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ChannelMember this$member = this.getMember();
            ChannelMember other$member = other.getMember();
            return !(this$member == null ? other$member != null : !((Object)this$member).equals(other$member));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelMemberResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ChannelMember $member = this.getMember();
            result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
            return result;
        }
    }

    public static class MarkDeliveredRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="latest_delivered_messages")
        @Nullable
        private List<LatestDeliveredMessage> latestDeliveredMessages;

        MarkDeliveredRequestData(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable List<LatestDeliveredMessage> latestDeliveredMessages) {
            this.userId = userId;
            this.user = user;
            this.latestDeliveredMessages = latestDeliveredMessages;
        }

        public static class MarkDeliveredRequest
        extends StreamRequest<StreamResponseObject> {
            private String userId;
            private User.UserRequestObject user;
            private List<LatestDeliveredMessage> latestDeliveredMessages;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).markDelivered(this.internalBuild(), this.userId);
            }

            MarkDeliveredRequest() {
            }

            @JsonProperty(value="user_id")
            public MarkDeliveredRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public MarkDeliveredRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="latest_delivered_messages")
            public MarkDeliveredRequest latestDeliveredMessages(@Nullable List<LatestDeliveredMessage> latestDeliveredMessages) {
                this.latestDeliveredMessages = latestDeliveredMessages;
                return this;
            }

            public MarkDeliveredRequestData internalBuild() {
                return new MarkDeliveredRequestData(this.userId, this.user, this.latestDeliveredMessages);
            }

            public String toString() {
                return "Channel.MarkDeliveredRequestData.MarkDeliveredRequest(userId=" + this.userId + ", user=" + String.valueOf(this.user) + ", latestDeliveredMessages=" + String.valueOf(this.latestDeliveredMessages) + ")";
            }
        }
    }

    public static class ChannelMemberPartialUpdateRequestData {
        @JsonProperty(value="set")
        @Nullable
        private Map<String, Object> setValues;
        @JsonProperty(value="unset")
        @Nullable
        private List<String> unsetValues;

        ChannelMemberPartialUpdateRequestData(@Nullable Map<String, Object> setValues, @Nullable List<String> unsetValues) {
            this.setValues = setValues;
            this.unsetValues = unsetValues;
        }

        @Nullable
        public Map<String, Object> getSetValues() {
            return this.setValues;
        }

        @Nullable
        public List<String> getUnsetValues() {
            return this.unsetValues;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMemberPartialUpdateRequestData)) {
                return false;
            }
            ChannelMemberPartialUpdateRequestData other = (ChannelMemberPartialUpdateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$setValues = this.getSetValues();
            Map<String, Object> other$setValues = other.getSetValues();
            if (this$setValues == null ? other$setValues != null : !((Object)this$setValues).equals(other$setValues)) {
                return false;
            }
            List<String> this$unsetValues = this.getUnsetValues();
            List<String> other$unsetValues = other.getUnsetValues();
            return !(this$unsetValues == null ? other$unsetValues != null : !((Object)this$unsetValues).equals(other$unsetValues));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMemberPartialUpdateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $setValues = this.getSetValues();
            result = result * 59 + ($setValues == null ? 43 : ((Object)$setValues).hashCode());
            List<String> $unsetValues = this.getUnsetValues();
            result = result * 59 + ($unsetValues == null ? 43 : ((Object)$unsetValues).hashCode());
            return result;
        }

        public static class ChannelMemberPartialUpdateRequest
        extends StreamRequest<ChannelMemberResponse> {
            private ArrayList<String> setValues$key;
            private ArrayList<Object> setValues$value;
            private ArrayList<String> unsetValues;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;
            @NotNull
            private String userId;

            private ChannelMemberPartialUpdateRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String userId) {
                this.channelType = channelType;
                this.channelId = channelId;
                this.userId = userId;
            }

            @Override
            protected Call<ChannelMemberResponse> generateCall(Client client) {
                return client.create(ChannelService.class).updateMemberPartial(this.channelType, this.channelId, this.userId, this.internalBuild());
            }

            public ChannelMemberPartialUpdateRequest setValue(String setValueKey, Object setValueValue) {
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                this.setValues$key.add(setValueKey);
                this.setValues$value.add(setValueValue);
                return this;
            }

            @JsonProperty(value="set")
            public ChannelMemberPartialUpdateRequest setValues(Map<? extends String, ? extends Object> setValues) {
                if (setValues == null) {
                    throw new NullPointerException("setValues cannot be null");
                }
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : setValues.entrySet()) {
                    this.setValues$key.add($lombokEntry.getKey());
                    this.setValues$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelMemberPartialUpdateRequest clearSetValues() {
                if (this.setValues$key != null) {
                    this.setValues$key.clear();
                    this.setValues$value.clear();
                }
                return this;
            }

            public ChannelMemberPartialUpdateRequest unsetValue(String unsetValue) {
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.add(unsetValue);
                return this;
            }

            @JsonProperty(value="unset")
            public ChannelMemberPartialUpdateRequest unsetValues(Collection<? extends String> unsetValues) {
                if (unsetValues == null) {
                    throw new NullPointerException("unsetValues cannot be null");
                }
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.addAll(unsetValues);
                return this;
            }

            public ChannelMemberPartialUpdateRequest clearUnsetValues() {
                if (this.unsetValues != null) {
                    this.unsetValues.clear();
                }
                return this;
            }

            public ChannelMemberPartialUpdateRequestData internalBuild() {
                List<String> unsetValues;
                Map<String, Object> setValues;
                switch (this.setValues$key == null ? 0 : this.setValues$key.size()) {
                    case 0: {
                        setValues = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        setValues = Collections.singletonMap(this.setValues$key.get(0), this.setValues$value.get(0));
                        break;
                    }
                    default: {
                        setValues = new LinkedHashMap(this.setValues$key.size() < 0x40000000 ? 1 + this.setValues$key.size() + (this.setValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.setValues$key.size(); ++$i) {
                            setValues.put(this.setValues$key.get($i), this.setValues$value.get($i));
                        }
                        setValues = Collections.unmodifiableMap(setValues);
                    }
                }
                switch (this.unsetValues == null ? 0 : this.unsetValues.size()) {
                    case 0: {
                        unsetValues = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        unsetValues = Collections.singletonList(this.unsetValues.get(0));
                        break;
                    }
                    default: {
                        unsetValues = Collections.unmodifiableList(new ArrayList<String>(this.unsetValues));
                    }
                }
                return new ChannelMemberPartialUpdateRequestData(setValues, unsetValues);
            }

            public String toString() {
                return "Channel.ChannelMemberPartialUpdateRequestData.ChannelMemberPartialUpdateRequest(setValues$key=" + String.valueOf(this.setValues$key) + ", setValues$value=" + String.valueOf(this.setValues$value) + ", unsetValues=" + String.valueOf(this.unsetValues) + ")";
            }
        }
    }

    public static class ChannelPartialUpdateRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="set")
        @Nullable
        private Map<String, Object> setValues;
        @JsonProperty(value="unset")
        @Nullable
        private List<String> unsetValues;

        ChannelPartialUpdateRequestData(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Map<String, Object> setValues, @Nullable List<String> unsetValues) {
            this.userId = userId;
            this.user = user;
            this.setValues = setValues;
            this.unsetValues = unsetValues;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        @Nullable
        public Map<String, Object> getSetValues() {
            return this.setValues;
        }

        @Nullable
        public List<String> getUnsetValues() {
            return this.unsetValues;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelPartialUpdateRequestData)) {
                return false;
            }
            ChannelPartialUpdateRequestData other = (ChannelPartialUpdateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Map<String, Object> this$setValues = this.getSetValues();
            Map<String, Object> other$setValues = other.getSetValues();
            if (this$setValues == null ? other$setValues != null : !((Object)this$setValues).equals(other$setValues)) {
                return false;
            }
            List<String> this$unsetValues = this.getUnsetValues();
            List<String> other$unsetValues = other.getUnsetValues();
            return !(this$unsetValues == null ? other$unsetValues != null : !((Object)this$unsetValues).equals(other$unsetValues));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelPartialUpdateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Map<String, Object> $setValues = this.getSetValues();
            result = result * 59 + ($setValues == null ? 43 : ((Object)$setValues).hashCode());
            List<String> $unsetValues = this.getUnsetValues();
            result = result * 59 + ($unsetValues == null ? 43 : ((Object)$unsetValues).hashCode());
            return result;
        }

        public static class ChannelPartialUpdateRequest
        extends StreamRequest<ChannelPartialUpdateResponse> {
            private String userId;
            private User.UserRequestObject user;
            private ArrayList<String> setValues$key;
            private ArrayList<Object> setValues$value;
            private ArrayList<String> unsetValues;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelPartialUpdateRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<ChannelPartialUpdateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).partialUpdate(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public ChannelPartialUpdateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelPartialUpdateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelPartialUpdateRequest setValue(String setValueKey, Object setValueValue) {
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                this.setValues$key.add(setValueKey);
                this.setValues$value.add(setValueValue);
                return this;
            }

            @JsonProperty(value="set")
            public ChannelPartialUpdateRequest setValues(Map<? extends String, ? extends Object> setValues) {
                if (setValues == null) {
                    throw new NullPointerException("setValues cannot be null");
                }
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : setValues.entrySet()) {
                    this.setValues$key.add($lombokEntry.getKey());
                    this.setValues$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelPartialUpdateRequest clearSetValues() {
                if (this.setValues$key != null) {
                    this.setValues$key.clear();
                    this.setValues$value.clear();
                }
                return this;
            }

            public ChannelPartialUpdateRequest unsetValue(String unsetValue) {
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.add(unsetValue);
                return this;
            }

            @JsonProperty(value="unset")
            public ChannelPartialUpdateRequest unsetValues(Collection<? extends String> unsetValues) {
                if (unsetValues == null) {
                    throw new NullPointerException("unsetValues cannot be null");
                }
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.addAll(unsetValues);
                return this;
            }

            public ChannelPartialUpdateRequest clearUnsetValues() {
                if (this.unsetValues != null) {
                    this.unsetValues.clear();
                }
                return this;
            }

            public ChannelPartialUpdateRequestData internalBuild() {
                List<String> unsetValues;
                Map<String, Object> setValues;
                switch (this.setValues$key == null ? 0 : this.setValues$key.size()) {
                    case 0: {
                        setValues = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        setValues = Collections.singletonMap(this.setValues$key.get(0), this.setValues$value.get(0));
                        break;
                    }
                    default: {
                        setValues = new LinkedHashMap(this.setValues$key.size() < 0x40000000 ? 1 + this.setValues$key.size() + (this.setValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.setValues$key.size(); ++$i) {
                            setValues.put(this.setValues$key.get($i), this.setValues$value.get($i));
                        }
                        setValues = Collections.unmodifiableMap(setValues);
                    }
                }
                switch (this.unsetValues == null ? 0 : this.unsetValues.size()) {
                    case 0: {
                        unsetValues = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        unsetValues = Collections.singletonList(this.unsetValues.get(0));
                        break;
                    }
                    default: {
                        unsetValues = Collections.unmodifiableList(new ArrayList<String>(this.unsetValues));
                    }
                }
                return new ChannelPartialUpdateRequestData(this.userId, this.user, setValues, unsetValues);
            }

            public String toString() {
                return "Channel.ChannelPartialUpdateRequestData.ChannelPartialUpdateRequest(userId=" + this.userId + ", user=" + String.valueOf(this.user) + ", setValues$key=" + String.valueOf(this.setValues$key) + ", setValues$value=" + String.valueOf(this.setValues$value) + ", unsetValues=" + String.valueOf(this.unsetValues) + ")";
            }
        }
    }

    public static class ChannelUnMuteRequestData {
        @JsonProperty(value="channel_cid")
        @Nullable
        private String channelCid;
        @JsonProperty(value="channel_cids")
        @Nullable
        private List<String> channelCids;
        @JsonProperty(value="expiration")
        @Nullable
        private Integer expiration;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelUnMuteRequestData(@Nullable String channelCid, @Nullable List<String> channelCids, @Nullable Integer expiration, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.channelCid = channelCid;
            this.channelCids = channelCids;
            this.expiration = expiration;
            this.userId = userId;
            this.user = user;
        }

        public static class ChannelUnMuteRequest
        extends StreamRequest<ChannelUnMuteResponse> {
            private String channelCid;
            private List<String> channelCids;
            private Integer expiration;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<ChannelUnMuteResponse> generateCall(Client client) {
                return client.create(ChannelService.class).unmute(this.internalBuild());
            }

            ChannelUnMuteRequest() {
            }

            @JsonProperty(value="channel_cid")
            public ChannelUnMuteRequest channelCid(@Nullable String channelCid) {
                this.channelCid = channelCid;
                return this;
            }

            @JsonProperty(value="channel_cids")
            public ChannelUnMuteRequest channelCids(@Nullable List<String> channelCids) {
                this.channelCids = channelCids;
                return this;
            }

            @JsonProperty(value="expiration")
            public ChannelUnMuteRequest expiration(@Nullable Integer expiration) {
                this.expiration = expiration;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelUnMuteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelUnMuteRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelUnMuteRequestData internalBuild() {
                return new ChannelUnMuteRequestData(this.channelCid, this.channelCids, this.expiration, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelUnMuteRequestData.ChannelUnMuteRequest(channelCid=" + this.channelCid + ", channelCids=" + String.valueOf(this.channelCids) + ", expiration=" + this.expiration + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelShowRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelShowRequestData(@Nullable String userId, @Nullable User.UserRequestObject user) {
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelShowRequestData)) {
                return false;
            }
            ChannelShowRequestData other = (ChannelShowRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelShowRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelShowRequest
        extends StreamRequest<StreamResponseObject> {
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelShowRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).show(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public ChannelShowRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelShowRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelShowRequestData internalBuild() {
                return new ChannelShowRequestData(this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelShowRequestData.ChannelShowRequest(userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelMuteRequestData {
        @JsonProperty(value="channel_cid")
        @Nullable
        private String channelCid;
        @JsonProperty(value="channel_cids")
        @Nullable
        private List<String> channelCids;
        @JsonProperty(value="expiration")
        @Nullable
        private Long expiration;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelMuteRequestData(@Nullable String channelCid, @Nullable List<String> channelCids, @Nullable Long expiration, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.channelCid = channelCid;
            this.channelCids = channelCids;
            this.expiration = expiration;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public String getChannelCid() {
            return this.channelCid;
        }

        @Nullable
        public List<String> getChannelCids() {
            return this.channelCids;
        }

        @Nullable
        public Long getExpiration() {
            return this.expiration;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMuteRequestData)) {
                return false;
            }
            ChannelMuteRequestData other = (ChannelMuteRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$expiration = this.getExpiration();
            Long other$expiration = other.getExpiration();
            if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
                return false;
            }
            String this$channelCid = this.getChannelCid();
            String other$channelCid = other.getChannelCid();
            if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
                return false;
            }
            List<String> this$channelCids = this.getChannelCids();
            List<String> other$channelCids = other.getChannelCids();
            if (this$channelCids == null ? other$channelCids != null : !((Object)this$channelCids).equals(other$channelCids)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMuteRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $expiration = this.getExpiration();
            result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
            String $channelCid = this.getChannelCid();
            result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
            List<String> $channelCids = this.getChannelCids();
            result = result * 59 + ($channelCids == null ? 43 : ((Object)$channelCids).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelMuteRequest
        extends StreamRequest<ChannelMuteResponse> {
            private String channelCid;
            private List<String> channelCids;
            private Long expiration;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<ChannelMuteResponse> generateCall(Client client) {
                return client.create(ChannelService.class).mute(this.internalBuild());
            }

            ChannelMuteRequest() {
            }

            @JsonProperty(value="channel_cid")
            public ChannelMuteRequest channelCid(@Nullable String channelCid) {
                this.channelCid = channelCid;
                return this;
            }

            @JsonProperty(value="channel_cids")
            public ChannelMuteRequest channelCids(@Nullable List<String> channelCids) {
                this.channelCids = channelCids;
                return this;
            }

            @JsonProperty(value="expiration")
            public ChannelMuteRequest expiration(@Nullable Long expiration) {
                this.expiration = expiration;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelMuteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMuteRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelMuteRequestData internalBuild() {
                return new ChannelMuteRequestData(this.channelCid, this.channelCids, this.expiration, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelMuteRequestData.ChannelMuteRequest(channelCid=" + this.channelCid + ", channelCids=" + String.valueOf(this.channelCids) + ", expiration=" + this.expiration + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelMarkReadRequestData {
        @JsonProperty(value="message_id")
        @Nullable
        private String messageId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelMarkReadRequestData(@Nullable String messageId, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.messageId = messageId;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public String getMessageId() {
            return this.messageId;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMarkReadRequestData)) {
                return false;
            }
            ChannelMarkReadRequestData other = (ChannelMarkReadRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$messageId = this.getMessageId();
            String other$messageId = other.getMessageId();
            if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMarkReadRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $messageId = this.getMessageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelMarkReadRequest
        extends StreamRequest<ChannelMarkReadResponse> {
            private String messageId;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelMarkReadRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<ChannelMarkReadResponse> generateCall(Client client) {
                return client.create(ChannelService.class).markRead(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="message_id")
            public ChannelMarkReadRequest messageId(@Nullable String messageId) {
                this.messageId = messageId;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelMarkReadRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMarkReadRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelMarkReadRequestData internalBuild() {
                return new ChannelMarkReadRequestData(this.messageId, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelMarkReadRequestData.ChannelMarkReadRequest(messageId=" + this.messageId + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelMarkAllReadRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelMarkAllReadRequestData(@Nullable String userId, @Nullable User.UserRequestObject user) {
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMarkAllReadRequestData)) {
                return false;
            }
            ChannelMarkAllReadRequestData other = (ChannelMarkAllReadRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMarkAllReadRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelMarkAllReadRequest
        extends StreamRequest<StreamResponseObject> {
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).markAllRead(this.internalBuild());
            }

            ChannelMarkAllReadRequest() {
            }

            @JsonProperty(value="user_id")
            public ChannelMarkAllReadRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMarkAllReadRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelMarkAllReadRequestData internalBuild() {
                return new ChannelMarkAllReadRequestData(this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelMarkAllReadRequestData.ChannelMarkAllReadRequest(userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelHideRequestData {
        @JsonProperty(value="clear_history")
        @Nullable
        private Boolean clearHistory;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelHideRequestData(@Nullable Boolean clearHistory, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.clearHistory = clearHistory;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public Boolean getClearHistory() {
            return this.clearHistory;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelHideRequestData)) {
                return false;
            }
            ChannelHideRequestData other = (ChannelHideRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$clearHistory = this.getClearHistory();
            Boolean other$clearHistory = other.getClearHistory();
            if (this$clearHistory == null ? other$clearHistory != null : !((Object)this$clearHistory).equals(other$clearHistory)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelHideRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $clearHistory = this.getClearHistory();
            result = result * 59 + ($clearHistory == null ? 43 : ((Object)$clearHistory).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelHideRequest
        extends StreamRequest<StreamResponseObject> {
            private Boolean clearHistory;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelHideRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(ChannelService.class).hide(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="clear_history")
            public ChannelHideRequest clearHistory(@Nullable Boolean clearHistory) {
                this.clearHistory = clearHistory;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelHideRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelHideRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelHideRequestData internalBuild() {
                return new ChannelHideRequestData(this.clearHistory, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelHideRequestData.ChannelHideRequest(clearHistory=" + this.clearHistory + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelExportStatusRequest
    extends StreamRequest<ChannelExportStatusResponse> {
        @NotNull
        private String id;

        @Override
        protected Call<ChannelExportStatusResponse> generateCall(Client client) {
            return client.create(ChannelService.class).exportStatus(this.id);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportStatusRequest)) {
                return false;
            }
            ChannelExportStatusRequest other = (ChannelExportStatusRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportStatusRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public ChannelExportStatusRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class ChannelExportRequestData {
        @JsonProperty(value="channels")
        @Nullable
        private List<ChannelExportRequestObject> channels;
        @JsonProperty(value="version")
        @Nullable
        private String version;
        @JsonProperty(value="clear_deleted_message_text")
        @Nullable
        private Boolean clearDeletedMessageText;
        @JsonProperty(value="include_truncated_messages")
        @Nullable
        private Boolean includeTruncatedMessages;
        @JsonProperty(value="export_users")
        @Nullable
        private Boolean exportUsers;

        ChannelExportRequestData(@Nullable List<ChannelExportRequestObject> channels, @Nullable String version, @Nullable Boolean clearDeletedMessageText, @Nullable Boolean includeTruncatedMessages, @Nullable Boolean exportUsers) {
            this.channels = channels;
            this.version = version;
            this.clearDeletedMessageText = clearDeletedMessageText;
            this.includeTruncatedMessages = includeTruncatedMessages;
            this.exportUsers = exportUsers;
        }

        @Nullable
        public List<ChannelExportRequestObject> getChannels() {
            return this.channels;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Nullable
        public Boolean getClearDeletedMessageText() {
            return this.clearDeletedMessageText;
        }

        @Nullable
        public Boolean getIncludeTruncatedMessages() {
            return this.includeTruncatedMessages;
        }

        @Nullable
        public Boolean getExportUsers() {
            return this.exportUsers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportRequestData)) {
                return false;
            }
            ChannelExportRequestData other = (ChannelExportRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$clearDeletedMessageText = this.getClearDeletedMessageText();
            Boolean other$clearDeletedMessageText = other.getClearDeletedMessageText();
            if (this$clearDeletedMessageText == null ? other$clearDeletedMessageText != null : !((Object)this$clearDeletedMessageText).equals(other$clearDeletedMessageText)) {
                return false;
            }
            Boolean this$includeTruncatedMessages = this.getIncludeTruncatedMessages();
            Boolean other$includeTruncatedMessages = other.getIncludeTruncatedMessages();
            if (this$includeTruncatedMessages == null ? other$includeTruncatedMessages != null : !((Object)this$includeTruncatedMessages).equals(other$includeTruncatedMessages)) {
                return false;
            }
            Boolean this$exportUsers = this.getExportUsers();
            Boolean other$exportUsers = other.getExportUsers();
            if (this$exportUsers == null ? other$exportUsers != null : !((Object)this$exportUsers).equals(other$exportUsers)) {
                return false;
            }
            List<ChannelExportRequestObject> this$channels = this.getChannels();
            List<ChannelExportRequestObject> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $clearDeletedMessageText = this.getClearDeletedMessageText();
            result = result * 59 + ($clearDeletedMessageText == null ? 43 : ((Object)$clearDeletedMessageText).hashCode());
            Boolean $includeTruncatedMessages = this.getIncludeTruncatedMessages();
            result = result * 59 + ($includeTruncatedMessages == null ? 43 : ((Object)$includeTruncatedMessages).hashCode());
            Boolean $exportUsers = this.getExportUsers();
            result = result * 59 + ($exportUsers == null ? 43 : ((Object)$exportUsers).hashCode());
            List<ChannelExportRequestObject> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public static class ChannelExportRequest
        extends StreamRequest<ChannelExportResponse> {
            private ArrayList<ChannelExportRequestObject> channels;
            private String version;
            private Boolean clearDeletedMessageText;
            private Boolean includeTruncatedMessages;
            private Boolean exportUsers;

            @Override
            protected Call<ChannelExportResponse> generateCall(Client client) {
                return client.create(ChannelService.class).export(this.internalBuild());
            }

            ChannelExportRequest() {
            }

            public ChannelExportRequest channel(ChannelExportRequestObject channel) {
                if (this.channels == null) {
                    this.channels = new ArrayList();
                }
                this.channels.add(channel);
                return this;
            }

            @JsonProperty(value="channels")
            public ChannelExportRequest channels(Collection<? extends ChannelExportRequestObject> channels) {
                if (channels == null) {
                    throw new NullPointerException("channels cannot be null");
                }
                if (this.channels == null) {
                    this.channels = new ArrayList();
                }
                this.channels.addAll(channels);
                return this;
            }

            public ChannelExportRequest clearChannels() {
                if (this.channels != null) {
                    this.channels.clear();
                }
                return this;
            }

            @JsonProperty(value="version")
            public ChannelExportRequest version(@Nullable String version) {
                this.version = version;
                return this;
            }

            @JsonProperty(value="clear_deleted_message_text")
            public ChannelExportRequest clearDeletedMessageText(@Nullable Boolean clearDeletedMessageText) {
                this.clearDeletedMessageText = clearDeletedMessageText;
                return this;
            }

            @JsonProperty(value="include_truncated_messages")
            public ChannelExportRequest includeTruncatedMessages(@Nullable Boolean includeTruncatedMessages) {
                this.includeTruncatedMessages = includeTruncatedMessages;
                return this;
            }

            @JsonProperty(value="export_users")
            public ChannelExportRequest exportUsers(@Nullable Boolean exportUsers) {
                this.exportUsers = exportUsers;
                return this;
            }

            public ChannelExportRequestData internalBuild() {
                List<ChannelExportRequestObject> channels;
                switch (this.channels == null ? 0 : this.channels.size()) {
                    case 0: {
                        channels = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        channels = Collections.singletonList(this.channels.get(0));
                        break;
                    }
                    default: {
                        channels = Collections.unmodifiableList(new ArrayList<ChannelExportRequestObject>(this.channels));
                    }
                }
                return new ChannelExportRequestData(channels, this.version, this.clearDeletedMessageText, this.includeTruncatedMessages, this.exportUsers);
            }

            public String toString() {
                return "Channel.ChannelExportRequestData.ChannelExportRequest(channels=" + String.valueOf(this.channels) + ", version=" + this.version + ", clearDeletedMessageText=" + this.clearDeletedMessageText + ", includeTruncatedMessages=" + this.includeTruncatedMessages + ", exportUsers=" + this.exportUsers + ")";
            }
        }
    }

    public static class ChannelQueryMembersRequestData {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="members")
        @Nullable
        private ChannelMemberRequestObject members;
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id_gte")
        @Nullable
        private String userIdGte;
        @JsonProperty(value="user_id_gt")
        @Nullable
        private String userIdGt;
        @JsonProperty(value="user_id_lte")
        @Nullable
        private String userIdLte;
        @JsonProperty(value="user_id_lt")
        @Nullable
        private String userIdLt;
        @JsonProperty(value="created_at_after_or_equal")
        @Nullable
        private Date createdAtAfterOrEqual;
        @JsonProperty(value="created_at_after")
        @Nullable
        private Date createdAtAfter;
        @JsonProperty(value="created_at_before_or_equal")
        @Nullable
        private Date createdAtBeforeOrEqual;
        @JsonProperty(value="created_at_before")
        @Nullable
        private Date createdAtBefore;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelQueryMembersRequestData(@Nullable String type, @Nullable String id, @Nullable ChannelMemberRequestObject members, @Nullable Map<String, Object> filterConditions, @Nullable List<Sort> sorts, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userIdGte, @Nullable String userIdGt, @Nullable String userIdLte, @Nullable String userIdLt, @Nullable Date createdAtAfterOrEqual, @Nullable Date createdAtAfter, @Nullable Date createdAtBeforeOrEqual, @Nullable Date createdAtBefore, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.type = type;
            this.id = id;
            this.members = members;
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.limit = limit;
            this.offset = offset;
            this.userIdGte = userIdGte;
            this.userIdGt = userIdGt;
            this.userIdLte = userIdLte;
            this.userIdLt = userIdLt;
            this.createdAtAfterOrEqual = createdAtAfterOrEqual;
            this.createdAtAfter = createdAtAfter;
            this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
            this.createdAtBefore = createdAtBefore;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public ChannelMemberRequestObject getMembers() {
            return this.members;
        }

        @Nullable
        public Map<String, Object> getFilterConditions() {
            return this.filterConditions;
        }

        @Nullable
        public List<Sort> getSorts() {
            return this.sorts;
        }

        @Nullable
        public Integer getLimit() {
            return this.limit;
        }

        @Nullable
        public Integer getOffset() {
            return this.offset;
        }

        @Nullable
        public String getUserIdGte() {
            return this.userIdGte;
        }

        @Nullable
        public String getUserIdGt() {
            return this.userIdGt;
        }

        @Nullable
        public String getUserIdLte() {
            return this.userIdLte;
        }

        @Nullable
        public String getUserIdLt() {
            return this.userIdLt;
        }

        @Nullable
        public Date getCreatedAtAfterOrEqual() {
            return this.createdAtAfterOrEqual;
        }

        @Nullable
        public Date getCreatedAtAfter() {
            return this.createdAtAfter;
        }

        @Nullable
        public Date getCreatedAtBeforeOrEqual() {
            return this.createdAtBeforeOrEqual;
        }

        @Nullable
        public Date getCreatedAtBefore() {
            return this.createdAtBefore;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelQueryMembersRequestData)) {
                return false;
            }
            ChannelQueryMembersRequestData other = (ChannelQueryMembersRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$limit = this.getLimit();
            Integer other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            Integer this$offset = this.getOffset();
            Integer other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ChannelMemberRequestObject this$members = this.getMembers();
            ChannelMemberRequestObject other$members = other.getMembers();
            if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
                return false;
            }
            Map<String, Object> this$filterConditions = this.getFilterConditions();
            Map<String, Object> other$filterConditions = other.getFilterConditions();
            if (this$filterConditions == null ? other$filterConditions != null : !((Object)this$filterConditions).equals(other$filterConditions)) {
                return false;
            }
            List<Sort> this$sorts = this.getSorts();
            List<Sort> other$sorts = other.getSorts();
            if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
                return false;
            }
            String this$userIdGte = this.getUserIdGte();
            String other$userIdGte = other.getUserIdGte();
            if (this$userIdGte == null ? other$userIdGte != null : !this$userIdGte.equals(other$userIdGte)) {
                return false;
            }
            String this$userIdGt = this.getUserIdGt();
            String other$userIdGt = other.getUserIdGt();
            if (this$userIdGt == null ? other$userIdGt != null : !this$userIdGt.equals(other$userIdGt)) {
                return false;
            }
            String this$userIdLte = this.getUserIdLte();
            String other$userIdLte = other.getUserIdLte();
            if (this$userIdLte == null ? other$userIdLte != null : !this$userIdLte.equals(other$userIdLte)) {
                return false;
            }
            String this$userIdLt = this.getUserIdLt();
            String other$userIdLt = other.getUserIdLt();
            if (this$userIdLt == null ? other$userIdLt != null : !this$userIdLt.equals(other$userIdLt)) {
                return false;
            }
            Date this$createdAtAfterOrEqual = this.getCreatedAtAfterOrEqual();
            Date other$createdAtAfterOrEqual = other.getCreatedAtAfterOrEqual();
            if (this$createdAtAfterOrEqual == null ? other$createdAtAfterOrEqual != null : !((Object)this$createdAtAfterOrEqual).equals(other$createdAtAfterOrEqual)) {
                return false;
            }
            Date this$createdAtAfter = this.getCreatedAtAfter();
            Date other$createdAtAfter = other.getCreatedAtAfter();
            if (this$createdAtAfter == null ? other$createdAtAfter != null : !((Object)this$createdAtAfter).equals(other$createdAtAfter)) {
                return false;
            }
            Date this$createdAtBeforeOrEqual = this.getCreatedAtBeforeOrEqual();
            Date other$createdAtBeforeOrEqual = other.getCreatedAtBeforeOrEqual();
            if (this$createdAtBeforeOrEqual == null ? other$createdAtBeforeOrEqual != null : !((Object)this$createdAtBeforeOrEqual).equals(other$createdAtBeforeOrEqual)) {
                return false;
            }
            Date this$createdAtBefore = this.getCreatedAtBefore();
            Date other$createdAtBefore = other.getCreatedAtBefore();
            if (this$createdAtBefore == null ? other$createdAtBefore != null : !((Object)this$createdAtBefore).equals(other$createdAtBefore)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelQueryMembersRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            Integer $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ChannelMemberRequestObject $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            Map<String, Object> $filterConditions = this.getFilterConditions();
            result = result * 59 + ($filterConditions == null ? 43 : ((Object)$filterConditions).hashCode());
            List<Sort> $sorts = this.getSorts();
            result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
            String $userIdGte = this.getUserIdGte();
            result = result * 59 + ($userIdGte == null ? 43 : $userIdGte.hashCode());
            String $userIdGt = this.getUserIdGt();
            result = result * 59 + ($userIdGt == null ? 43 : $userIdGt.hashCode());
            String $userIdLte = this.getUserIdLte();
            result = result * 59 + ($userIdLte == null ? 43 : $userIdLte.hashCode());
            String $userIdLt = this.getUserIdLt();
            result = result * 59 + ($userIdLt == null ? 43 : $userIdLt.hashCode());
            Date $createdAtAfterOrEqual = this.getCreatedAtAfterOrEqual();
            result = result * 59 + ($createdAtAfterOrEqual == null ? 43 : ((Object)$createdAtAfterOrEqual).hashCode());
            Date $createdAtAfter = this.getCreatedAtAfter();
            result = result * 59 + ($createdAtAfter == null ? 43 : ((Object)$createdAtAfter).hashCode());
            Date $createdAtBeforeOrEqual = this.getCreatedAtBeforeOrEqual();
            result = result * 59 + ($createdAtBeforeOrEqual == null ? 43 : ((Object)$createdAtBeforeOrEqual).hashCode());
            Date $createdAtBefore = this.getCreatedAtBefore();
            result = result * 59 + ($createdAtBefore == null ? 43 : ((Object)$createdAtBefore).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelQueryMembersRequest
        extends StreamRequest<ChannelQueryMembersResponse> {
            private String type;
            private String id;
            private ChannelMemberRequestObject members;
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Sort> sorts;
            private Integer limit;
            private Integer offset;
            private String userIdGte;
            private String userIdGt;
            private String userIdLte;
            private String userIdLt;
            private Date createdAtAfterOrEqual;
            private Date createdAtAfter;
            private Date createdAtBeforeOrEqual;
            private Date createdAtBefore;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<ChannelQueryMembersResponse> generateCall(Client client) {
                return client.create(ChannelService.class).queryMembers(this.internalBuild());
            }

            ChannelQueryMembersRequest() {
            }

            @JsonProperty(value="type")
            public ChannelQueryMembersRequest type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="id")
            public ChannelQueryMembersRequest id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="members")
            public ChannelQueryMembersRequest members(@Nullable ChannelMemberRequestObject members) {
                this.members = members;
                return this;
            }

            public ChannelQueryMembersRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public ChannelQueryMembersRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelQueryMembersRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public ChannelQueryMembersRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public ChannelQueryMembersRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public ChannelQueryMembersRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public ChannelQueryMembersRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public ChannelQueryMembersRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id_gte")
            public ChannelQueryMembersRequest userIdGte(@Nullable String userIdGte) {
                this.userIdGte = userIdGte;
                return this;
            }

            @JsonProperty(value="user_id_gt")
            public ChannelQueryMembersRequest userIdGt(@Nullable String userIdGt) {
                this.userIdGt = userIdGt;
                return this;
            }

            @JsonProperty(value="user_id_lte")
            public ChannelQueryMembersRequest userIdLte(@Nullable String userIdLte) {
                this.userIdLte = userIdLte;
                return this;
            }

            @JsonProperty(value="user_id_lt")
            public ChannelQueryMembersRequest userIdLt(@Nullable String userIdLt) {
                this.userIdLt = userIdLt;
                return this;
            }

            @JsonProperty(value="created_at_after_or_equal")
            public ChannelQueryMembersRequest createdAtAfterOrEqual(@Nullable Date createdAtAfterOrEqual) {
                this.createdAtAfterOrEqual = createdAtAfterOrEqual;
                return this;
            }

            @JsonProperty(value="created_at_after")
            public ChannelQueryMembersRequest createdAtAfter(@Nullable Date createdAtAfter) {
                this.createdAtAfter = createdAtAfter;
                return this;
            }

            @JsonProperty(value="created_at_before_or_equal")
            public ChannelQueryMembersRequest createdAtBeforeOrEqual(@Nullable Date createdAtBeforeOrEqual) {
                this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
                return this;
            }

            @JsonProperty(value="created_at_before")
            public ChannelQueryMembersRequest createdAtBefore(@Nullable Date createdAtBefore) {
                this.createdAtBefore = createdAtBefore;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelQueryMembersRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelQueryMembersRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelQueryMembersRequestData internalBuild() {
                List<Sort> sorts;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new ChannelQueryMembersRequestData(this.type, this.id, this.members, filterConditions, sorts, this.limit, this.offset, this.userIdGte, this.userIdGt, this.userIdLte, this.userIdLt, this.createdAtAfterOrEqual, this.createdAtAfter, this.createdAtBeforeOrEqual, this.createdAtBefore, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelQueryMembersRequestData.ChannelQueryMembersRequest(type=" + this.type + ", id=" + this.id + ", members=" + String.valueOf(this.members) + ", filterConditions$key=" + String.valueOf(this.filterConditions$key) + ", filterConditions$value=" + String.valueOf(this.filterConditions$value) + ", sorts=" + String.valueOf(this.sorts) + ", limit=" + this.limit + ", offset=" + this.offset + ", userIdGte=" + this.userIdGte + ", userIdGt=" + this.userIdGt + ", userIdLte=" + this.userIdLte + ", userIdLt=" + this.userIdLt + ", createdAtAfterOrEqual=" + String.valueOf(this.createdAtAfterOrEqual) + ", createdAtAfter=" + String.valueOf(this.createdAtAfter) + ", createdAtBeforeOrEqual=" + String.valueOf(this.createdAtBeforeOrEqual) + ", createdAtBefore=" + String.valueOf(this.createdAtBefore) + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelTruncateRequestData {
        @JsonProperty(value="hard_delete")
        @Nullable
        private boolean hardDelete;
        @JsonProperty(value="skip_push")
        @Nullable
        private boolean skipPush;
        @JsonProperty(value="truncated_at")
        @Nullable
        private Date truncatedAt;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelTruncateRequestData(@Nullable boolean hardDelete, @Nullable boolean skipPush, @Nullable Date truncatedAt, @Nullable Message.MessageRequestObject message, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.hardDelete = hardDelete;
            this.skipPush = skipPush;
            this.truncatedAt = truncatedAt;
            this.message = message;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public boolean isHardDelete() {
            return this.hardDelete;
        }

        @Nullable
        public boolean isSkipPush() {
            return this.skipPush;
        }

        @Nullable
        public Date getTruncatedAt() {
            return this.truncatedAt;
        }

        @Nullable
        public Message.MessageRequestObject getMessage() {
            return this.message;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTruncateRequestData)) {
                return false;
            }
            ChannelTruncateRequestData other = (ChannelTruncateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHardDelete() != other.isHardDelete()) {
                return false;
            }
            if (this.isSkipPush() != other.isSkipPush()) {
                return false;
            }
            Date this$truncatedAt = this.getTruncatedAt();
            Date other$truncatedAt = other.getTruncatedAt();
            if (this$truncatedAt == null ? other$truncatedAt != null : !((Object)this$truncatedAt).equals(other$truncatedAt)) {
                return false;
            }
            Message.MessageRequestObject this$message = this.getMessage();
            Message.MessageRequestObject other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelTruncateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHardDelete() ? 79 : 97);
            result = result * 59 + (this.isSkipPush() ? 79 : 97);
            Date $truncatedAt = this.getTruncatedAt();
            result = result * 59 + ($truncatedAt == null ? 43 : ((Object)$truncatedAt).hashCode());
            Message.MessageRequestObject $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelTruncateRequest
        extends StreamRequest<ChannelTruncateResponse> {
            private boolean hardDelete;
            private boolean skipPush;
            private Date truncatedAt;
            private Message.MessageRequestObject message;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelTruncateRequest(@NotNull String channelType, @Nullable String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelTruncateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).truncate(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="hard_delete")
            public ChannelTruncateRequest hardDelete(@Nullable boolean hardDelete) {
                this.hardDelete = hardDelete;
                return this;
            }

            @JsonProperty(value="skip_push")
            public ChannelTruncateRequest skipPush(@Nullable boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            @JsonProperty(value="truncated_at")
            public ChannelTruncateRequest truncatedAt(@Nullable Date truncatedAt) {
                this.truncatedAt = truncatedAt;
                return this;
            }

            @JsonProperty(value="message")
            public ChannelTruncateRequest message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelTruncateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelTruncateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelTruncateRequestData internalBuild() {
                return new ChannelTruncateRequestData(this.hardDelete, this.skipPush, this.truncatedAt, this.message, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelTruncateRequestData.ChannelTruncateRequest(hardDelete=" + this.hardDelete + ", skipPush=" + this.skipPush + ", truncatedAt=" + String.valueOf(this.truncatedAt) + ", message=" + String.valueOf(this.message) + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelListRequestData {
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="watch")
        @Nullable
        private Boolean watch;
        @JsonProperty(value="state")
        @Nullable
        private Boolean state;
        @JsonProperty(value="presence")
        @Nullable
        private Boolean presence;
        @JsonProperty(value="message_limit")
        @Nullable
        private Integer messageLimit;
        @JsonProperty(value="member_limit")
        @Nullable
        private Integer memberLimit;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="connection_id")
        @Nullable
        private String connectionId;

        ChannelListRequestData(@Nullable Map<String, Object> filterConditions, @Nullable List<Sort> sorts, @Nullable Boolean watch, @Nullable Boolean state, @Nullable Boolean presence, @Nullable Integer messageLimit, @Nullable Integer memberLimit, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userId, @Nullable User.UserRequestObject user, @Nullable String connectionId) {
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.watch = watch;
            this.state = state;
            this.presence = presence;
            this.messageLimit = messageLimit;
            this.memberLimit = memberLimit;
            this.limit = limit;
            this.offset = offset;
            this.userId = userId;
            this.user = user;
            this.connectionId = connectionId;
        }

        @Nullable
        public Map<String, Object> getFilterConditions() {
            return this.filterConditions;
        }

        @Nullable
        public List<Sort> getSorts() {
            return this.sorts;
        }

        @Nullable
        public Boolean getWatch() {
            return this.watch;
        }

        @Nullable
        public Boolean getState() {
            return this.state;
        }

        @Nullable
        public Boolean getPresence() {
            return this.presence;
        }

        @Nullable
        public Integer getMessageLimit() {
            return this.messageLimit;
        }

        @Nullable
        public Integer getMemberLimit() {
            return this.memberLimit;
        }

        @Nullable
        public Integer getLimit() {
            return this.limit;
        }

        @Nullable
        public Integer getOffset() {
            return this.offset;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        @Nullable
        public String getConnectionId() {
            return this.connectionId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelListRequestData)) {
                return false;
            }
            ChannelListRequestData other = (ChannelListRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$watch = this.getWatch();
            Boolean other$watch = other.getWatch();
            if (this$watch == null ? other$watch != null : !((Object)this$watch).equals(other$watch)) {
                return false;
            }
            Boolean this$state = this.getState();
            Boolean other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            Boolean this$presence = this.getPresence();
            Boolean other$presence = other.getPresence();
            if (this$presence == null ? other$presence != null : !((Object)this$presence).equals(other$presence)) {
                return false;
            }
            Integer this$messageLimit = this.getMessageLimit();
            Integer other$messageLimit = other.getMessageLimit();
            if (this$messageLimit == null ? other$messageLimit != null : !((Object)this$messageLimit).equals(other$messageLimit)) {
                return false;
            }
            Integer this$memberLimit = this.getMemberLimit();
            Integer other$memberLimit = other.getMemberLimit();
            if (this$memberLimit == null ? other$memberLimit != null : !((Object)this$memberLimit).equals(other$memberLimit)) {
                return false;
            }
            Integer this$limit = this.getLimit();
            Integer other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            Integer this$offset = this.getOffset();
            Integer other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            Map<String, Object> this$filterConditions = this.getFilterConditions();
            Map<String, Object> other$filterConditions = other.getFilterConditions();
            if (this$filterConditions == null ? other$filterConditions != null : !((Object)this$filterConditions).equals(other$filterConditions)) {
                return false;
            }
            List<Sort> this$sorts = this.getSorts();
            List<Sort> other$sorts = other.getSorts();
            if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            String this$connectionId = this.getConnectionId();
            String other$connectionId = other.getConnectionId();
            return !(this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelListRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $watch = this.getWatch();
            result = result * 59 + ($watch == null ? 43 : ((Object)$watch).hashCode());
            Boolean $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            Boolean $presence = this.getPresence();
            result = result * 59 + ($presence == null ? 43 : ((Object)$presence).hashCode());
            Integer $messageLimit = this.getMessageLimit();
            result = result * 59 + ($messageLimit == null ? 43 : ((Object)$messageLimit).hashCode());
            Integer $memberLimit = this.getMemberLimit();
            result = result * 59 + ($memberLimit == null ? 43 : ((Object)$memberLimit).hashCode());
            Integer $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            Integer $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            Map<String, Object> $filterConditions = this.getFilterConditions();
            result = result * 59 + ($filterConditions == null ? 43 : ((Object)$filterConditions).hashCode());
            List<Sort> $sorts = this.getSorts();
            result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            String $connectionId = this.getConnectionId();
            result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
            return result;
        }

        public static class ChannelListRequest
        extends StreamRequest<ChannelListResponse> {
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Sort> sorts;
            private Boolean watch;
            private Boolean state;
            private Boolean presence;
            private Integer messageLimit;
            private Integer memberLimit;
            private Integer limit;
            private Integer offset;
            private String userId;
            private User.UserRequestObject user;
            private String connectionId;

            @Override
            protected Call<ChannelListResponse> generateCall(Client client) {
                return client.create(ChannelService.class).list(this.internalBuild());
            }

            ChannelListRequest() {
            }

            public ChannelListRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public ChannelListRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelListRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public ChannelListRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public ChannelListRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public ChannelListRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="watch")
            public ChannelListRequest watch(@Nullable Boolean watch) {
                this.watch = watch;
                return this;
            }

            @JsonProperty(value="state")
            public ChannelListRequest state(@Nullable Boolean state) {
                this.state = state;
                return this;
            }

            @JsonProperty(value="presence")
            public ChannelListRequest presence(@Nullable Boolean presence) {
                this.presence = presence;
                return this;
            }

            @JsonProperty(value="message_limit")
            public ChannelListRequest messageLimit(@Nullable Integer messageLimit) {
                this.messageLimit = messageLimit;
                return this;
            }

            @JsonProperty(value="member_limit")
            public ChannelListRequest memberLimit(@Nullable Integer memberLimit) {
                this.memberLimit = memberLimit;
                return this;
            }

            @JsonProperty(value="limit")
            public ChannelListRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public ChannelListRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelListRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelListRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="connection_id")
            public ChannelListRequest connectionId(@Nullable String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            public ChannelListRequestData internalBuild() {
                List<Sort> sorts;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new ChannelListRequestData(filterConditions, sorts, this.watch, this.state, this.presence, this.messageLimit, this.memberLimit, this.limit, this.offset, this.userId, this.user, this.connectionId);
            }

            public String toString() {
                return "Channel.ChannelListRequestData.ChannelListRequest(filterConditions$key=" + String.valueOf(this.filterConditions$key) + ", filterConditions$value=" + String.valueOf(this.filterConditions$value) + ", sorts=" + String.valueOf(this.sorts) + ", watch=" + this.watch + ", state=" + this.state + ", presence=" + this.presence + ", messageLimit=" + this.messageLimit + ", memberLimit=" + this.memberLimit + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ", connectionId=" + this.connectionId + ")";
            }
        }
    }

    public static class ChannelDeleteManyRequest
    extends StreamRequest<ChannelDeleteManyResponse> {
        @JsonProperty(value="cids")
        @NotNull
        private List<String> cids;
        @JsonProperty(value="hard_delete")
        private boolean hardDelete;

        public ChannelDeleteManyRequest setDeleteStrategy(DeleteStrategy strategy) {
            this.hardDelete = strategy == DeleteStrategy.HARD;
            return this;
        }

        @Override
        protected Call<ChannelDeleteManyResponse> generateCall(Client svcFactory) throws StreamException {
            return svcFactory.create(ChannelService.class).deleteMany(this);
        }

        @NotNull
        public List<String> getCids() {
            return this.cids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelDeleteManyRequest)) {
                return false;
            }
            ChannelDeleteManyRequest other = (ChannelDeleteManyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.hardDelete != other.hardDelete) {
                return false;
            }
            List<String> this$cids = this.getCids();
            List<String> other$cids = other.getCids();
            return !(this$cids == null ? other$cids != null : !((Object)this$cids).equals(other$cids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelDeleteManyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.hardDelete ? 79 : 97);
            List<String> $cids = this.getCids();
            result = result * 59 + ($cids == null ? 43 : ((Object)$cids).hashCode());
            return result;
        }

        public ChannelDeleteManyRequest(@NotNull List<String> cids) {
            if (cids == null) {
                throw new NullPointerException("cids is marked non-null but is null");
            }
            this.cids = cids;
        }
    }

    public static class ChannelDeleteRequest
    extends StreamRequest<ChannelDeleteResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;

        @Override
        protected Call<ChannelDeleteResponse> generateCall(Client client) {
            return client.create(ChannelService.class).delete(this.channelType, this.channelId);
        }

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelDeleteRequest)) {
                return false;
            }
            ChannelDeleteRequest other = (ChannelDeleteRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            return !(this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelDeleteRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            return result;
        }

        public ChannelDeleteRequest(@NotNull String channelType, @NotNull String channelId) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
        }
    }

    public static class AssignRoleRequestData {
        @JsonProperty(value="assign_roles")
        @Nullable
        private List<RoleAssignment> assignRoles;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;

        AssignRoleRequestData(@Nullable List<RoleAssignment> assignRoles, @Nullable Message.MessageRequestObject message) {
            this.assignRoles = assignRoles;
            this.message = message;
        }

        @Nullable
        public List<RoleAssignment> getAssignRoles() {
            return this.assignRoles;
        }

        @Nullable
        public Message.MessageRequestObject getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignRoleRequestData)) {
                return false;
            }
            AssignRoleRequestData other = (AssignRoleRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<RoleAssignment> this$assignRoles = this.getAssignRoles();
            List<RoleAssignment> other$assignRoles = other.getAssignRoles();
            if (this$assignRoles == null ? other$assignRoles != null : !((Object)this$assignRoles).equals(other$assignRoles)) {
                return false;
            }
            Message.MessageRequestObject this$message = this.getMessage();
            Message.MessageRequestObject other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssignRoleRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RoleAssignment> $assignRoles = this.getAssignRoles();
            result = result * 59 + ($assignRoles == null ? 43 : ((Object)$assignRoles).hashCode());
            Message.MessageRequestObject $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }

        public static class AssignRoleRequest
        extends StreamRequest<ChannelUpdateResponse> {
            private ArrayList<RoleAssignment> assignRoles;
            private Message.MessageRequestObject message;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private AssignRoleRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelUpdateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).assignRoles(this.channelType, this.channelId, this.internalBuild());
            }

            public AssignRoleRequest assignRole(RoleAssignment assignRole) {
                if (this.assignRoles == null) {
                    this.assignRoles = new ArrayList();
                }
                this.assignRoles.add(assignRole);
                return this;
            }

            @JsonProperty(value="assign_roles")
            public AssignRoleRequest assignRoles(Collection<? extends RoleAssignment> assignRoles) {
                if (assignRoles == null) {
                    throw new NullPointerException("assignRoles cannot be null");
                }
                if (this.assignRoles == null) {
                    this.assignRoles = new ArrayList();
                }
                this.assignRoles.addAll(assignRoles);
                return this;
            }

            public AssignRoleRequest clearAssignRoles() {
                if (this.assignRoles != null) {
                    this.assignRoles.clear();
                }
                return this;
            }

            @JsonProperty(value="message")
            public AssignRoleRequest message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            public AssignRoleRequestData internalBuild() {
                List<RoleAssignment> assignRoles;
                switch (this.assignRoles == null ? 0 : this.assignRoles.size()) {
                    case 0: {
                        assignRoles = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        assignRoles = Collections.singletonList(this.assignRoles.get(0));
                        break;
                    }
                    default: {
                        assignRoles = Collections.unmodifiableList(new ArrayList<RoleAssignment>(this.assignRoles));
                    }
                }
                return new AssignRoleRequestData(assignRoles, this.message);
            }

            public String toString() {
                return "Channel.AssignRoleRequestData.AssignRoleRequest(assignRoles=" + String.valueOf(this.assignRoles) + ", message=" + String.valueOf(this.message) + ")";
            }
        }
    }

    public static class ChannelUpdateRequestData {
        @JsonProperty(value="add_members")
        @Nullable
        private List<String> addMembers;
        @JsonProperty(value="remove_members")
        @Nullable
        private List<String> removeMembers;
        @JsonProperty(value="add_moderators")
        @Nullable
        private List<String> addModerators;
        @JsonProperty(value="demote_moderators")
        @Nullable
        private List<String> demoteModerators;
        @JsonProperty(value="invites")
        @Nullable
        private List<String> invites;
        @JsonProperty(value="add_filter_tags")
        @Nullable
        private List<String> addFilterTags;
        @JsonProperty(value="remove_filter_tags")
        @Nullable
        private List<String> removeFilterTags;
        @JsonProperty(value="cooldown")
        @Nullable
        private Integer cooldown;
        @JsonProperty(value="accept_invite")
        @Nullable
        private Boolean acceptInvite;
        @JsonProperty(value="reject_invite")
        @Nullable
        private Boolean rejectInvite;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;
        @JsonProperty(value="skip_push")
        @Nullable
        private Boolean skipPush;
        @JsonProperty(value="hide_history")
        @Nullable
        private Boolean hideHistory;
        @JsonProperty(value="hide_history_before")
        @Nullable
        private Date hideHistoryBefore;
        @JsonProperty(value="data")
        @Nullable
        private ChannelRequestObject data;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        ChannelUpdateRequestData(@Nullable List<String> addMembers, @Nullable List<String> removeMembers, @Nullable List<String> addModerators, @Nullable List<String> demoteModerators, @Nullable List<String> invites, @Nullable List<String> addFilterTags, @Nullable List<String> removeFilterTags, @Nullable Integer cooldown, @Nullable Boolean acceptInvite, @Nullable Boolean rejectInvite, @Nullable Message.MessageRequestObject message, @Nullable Boolean skipPush, @Nullable Boolean hideHistory, @Nullable Date hideHistoryBefore, @Nullable ChannelRequestObject data, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.addMembers = addMembers;
            this.removeMembers = removeMembers;
            this.addModerators = addModerators;
            this.demoteModerators = demoteModerators;
            this.invites = invites;
            this.addFilterTags = addFilterTags;
            this.removeFilterTags = removeFilterTags;
            this.cooldown = cooldown;
            this.acceptInvite = acceptInvite;
            this.rejectInvite = rejectInvite;
            this.message = message;
            this.skipPush = skipPush;
            this.hideHistory = hideHistory;
            this.hideHistoryBefore = hideHistoryBefore;
            this.data = data;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public List<String> getAddMembers() {
            return this.addMembers;
        }

        @Nullable
        public List<String> getRemoveMembers() {
            return this.removeMembers;
        }

        @Nullable
        public List<String> getAddModerators() {
            return this.addModerators;
        }

        @Nullable
        public List<String> getDemoteModerators() {
            return this.demoteModerators;
        }

        @Nullable
        public List<String> getInvites() {
            return this.invites;
        }

        @Nullable
        public List<String> getAddFilterTags() {
            return this.addFilterTags;
        }

        @Nullable
        public List<String> getRemoveFilterTags() {
            return this.removeFilterTags;
        }

        @Nullable
        public Integer getCooldown() {
            return this.cooldown;
        }

        @Nullable
        public Boolean getAcceptInvite() {
            return this.acceptInvite;
        }

        @Nullable
        public Boolean getRejectInvite() {
            return this.rejectInvite;
        }

        @Nullable
        public Message.MessageRequestObject getMessage() {
            return this.message;
        }

        @Nullable
        public Boolean getSkipPush() {
            return this.skipPush;
        }

        @Nullable
        public Boolean getHideHistory() {
            return this.hideHistory;
        }

        @Nullable
        public Date getHideHistoryBefore() {
            return this.hideHistoryBefore;
        }

        @Nullable
        public ChannelRequestObject getData() {
            return this.data;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelUpdateRequestData)) {
                return false;
            }
            ChannelUpdateRequestData other = (ChannelUpdateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$cooldown = this.getCooldown();
            Integer other$cooldown = other.getCooldown();
            if (this$cooldown == null ? other$cooldown != null : !((Object)this$cooldown).equals(other$cooldown)) {
                return false;
            }
            Boolean this$acceptInvite = this.getAcceptInvite();
            Boolean other$acceptInvite = other.getAcceptInvite();
            if (this$acceptInvite == null ? other$acceptInvite != null : !((Object)this$acceptInvite).equals(other$acceptInvite)) {
                return false;
            }
            Boolean this$rejectInvite = this.getRejectInvite();
            Boolean other$rejectInvite = other.getRejectInvite();
            if (this$rejectInvite == null ? other$rejectInvite != null : !((Object)this$rejectInvite).equals(other$rejectInvite)) {
                return false;
            }
            Boolean this$skipPush = this.getSkipPush();
            Boolean other$skipPush = other.getSkipPush();
            if (this$skipPush == null ? other$skipPush != null : !((Object)this$skipPush).equals(other$skipPush)) {
                return false;
            }
            Boolean this$hideHistory = this.getHideHistory();
            Boolean other$hideHistory = other.getHideHistory();
            if (this$hideHistory == null ? other$hideHistory != null : !((Object)this$hideHistory).equals(other$hideHistory)) {
                return false;
            }
            List<String> this$addMembers = this.getAddMembers();
            List<String> other$addMembers = other.getAddMembers();
            if (this$addMembers == null ? other$addMembers != null : !((Object)this$addMembers).equals(other$addMembers)) {
                return false;
            }
            List<String> this$removeMembers = this.getRemoveMembers();
            List<String> other$removeMembers = other.getRemoveMembers();
            if (this$removeMembers == null ? other$removeMembers != null : !((Object)this$removeMembers).equals(other$removeMembers)) {
                return false;
            }
            List<String> this$addModerators = this.getAddModerators();
            List<String> other$addModerators = other.getAddModerators();
            if (this$addModerators == null ? other$addModerators != null : !((Object)this$addModerators).equals(other$addModerators)) {
                return false;
            }
            List<String> this$demoteModerators = this.getDemoteModerators();
            List<String> other$demoteModerators = other.getDemoteModerators();
            if (this$demoteModerators == null ? other$demoteModerators != null : !((Object)this$demoteModerators).equals(other$demoteModerators)) {
                return false;
            }
            List<String> this$invites = this.getInvites();
            List<String> other$invites = other.getInvites();
            if (this$invites == null ? other$invites != null : !((Object)this$invites).equals(other$invites)) {
                return false;
            }
            List<String> this$addFilterTags = this.getAddFilterTags();
            List<String> other$addFilterTags = other.getAddFilterTags();
            if (this$addFilterTags == null ? other$addFilterTags != null : !((Object)this$addFilterTags).equals(other$addFilterTags)) {
                return false;
            }
            List<String> this$removeFilterTags = this.getRemoveFilterTags();
            List<String> other$removeFilterTags = other.getRemoveFilterTags();
            if (this$removeFilterTags == null ? other$removeFilterTags != null : !((Object)this$removeFilterTags).equals(other$removeFilterTags)) {
                return false;
            }
            Message.MessageRequestObject this$message = this.getMessage();
            Message.MessageRequestObject other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Date this$hideHistoryBefore = this.getHideHistoryBefore();
            Date other$hideHistoryBefore = other.getHideHistoryBefore();
            if (this$hideHistoryBefore == null ? other$hideHistoryBefore != null : !((Object)this$hideHistoryBefore).equals(other$hideHistoryBefore)) {
                return false;
            }
            ChannelRequestObject this$data = this.getData();
            ChannelRequestObject other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelUpdateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $cooldown = this.getCooldown();
            result = result * 59 + ($cooldown == null ? 43 : ((Object)$cooldown).hashCode());
            Boolean $acceptInvite = this.getAcceptInvite();
            result = result * 59 + ($acceptInvite == null ? 43 : ((Object)$acceptInvite).hashCode());
            Boolean $rejectInvite = this.getRejectInvite();
            result = result * 59 + ($rejectInvite == null ? 43 : ((Object)$rejectInvite).hashCode());
            Boolean $skipPush = this.getSkipPush();
            result = result * 59 + ($skipPush == null ? 43 : ((Object)$skipPush).hashCode());
            Boolean $hideHistory = this.getHideHistory();
            result = result * 59 + ($hideHistory == null ? 43 : ((Object)$hideHistory).hashCode());
            List<String> $addMembers = this.getAddMembers();
            result = result * 59 + ($addMembers == null ? 43 : ((Object)$addMembers).hashCode());
            List<String> $removeMembers = this.getRemoveMembers();
            result = result * 59 + ($removeMembers == null ? 43 : ((Object)$removeMembers).hashCode());
            List<String> $addModerators = this.getAddModerators();
            result = result * 59 + ($addModerators == null ? 43 : ((Object)$addModerators).hashCode());
            List<String> $demoteModerators = this.getDemoteModerators();
            result = result * 59 + ($demoteModerators == null ? 43 : ((Object)$demoteModerators).hashCode());
            List<String> $invites = this.getInvites();
            result = result * 59 + ($invites == null ? 43 : ((Object)$invites).hashCode());
            List<String> $addFilterTags = this.getAddFilterTags();
            result = result * 59 + ($addFilterTags == null ? 43 : ((Object)$addFilterTags).hashCode());
            List<String> $removeFilterTags = this.getRemoveFilterTags();
            result = result * 59 + ($removeFilterTags == null ? 43 : ((Object)$removeFilterTags).hashCode());
            Message.MessageRequestObject $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Date $hideHistoryBefore = this.getHideHistoryBefore();
            result = result * 59 + ($hideHistoryBefore == null ? 43 : ((Object)$hideHistoryBefore).hashCode());
            ChannelRequestObject $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class ChannelUpdateRequest
        extends StreamRequest<ChannelUpdateResponse> {
            private ArrayList<String> addMembers;
            private ArrayList<String> removeMembers;
            private ArrayList<String> addModerators;
            private ArrayList<String> demoteModerators;
            private ArrayList<String> invites;
            private ArrayList<String> addFilterTags;
            private ArrayList<String> removeFilterTags;
            private Integer cooldown;
            private Boolean acceptInvite;
            private Boolean rejectInvite;
            private Message.MessageRequestObject message;
            private Boolean skipPush;
            private Boolean hideHistory;
            private Date hideHistoryBefore;
            private ChannelRequestObject data;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private ChannelUpdateRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelUpdateResponse> generateCall(Client client) {
                return client.create(ChannelService.class).update(this.channelType, this.channelId, this.internalBuild());
            }

            public ChannelUpdateRequest addMember(String addMember) {
                if (this.addMembers == null) {
                    this.addMembers = new ArrayList();
                }
                this.addMembers.add(addMember);
                return this;
            }

            @JsonProperty(value="add_members")
            public ChannelUpdateRequest addMembers(Collection<? extends String> addMembers) {
                if (addMembers == null) {
                    throw new NullPointerException("addMembers cannot be null");
                }
                if (this.addMembers == null) {
                    this.addMembers = new ArrayList();
                }
                this.addMembers.addAll(addMembers);
                return this;
            }

            public ChannelUpdateRequest clearAddMembers() {
                if (this.addMembers != null) {
                    this.addMembers.clear();
                }
                return this;
            }

            public ChannelUpdateRequest removeMember(String removeMember) {
                if (this.removeMembers == null) {
                    this.removeMembers = new ArrayList();
                }
                this.removeMembers.add(removeMember);
                return this;
            }

            @JsonProperty(value="remove_members")
            public ChannelUpdateRequest removeMembers(Collection<? extends String> removeMembers) {
                if (removeMembers == null) {
                    throw new NullPointerException("removeMembers cannot be null");
                }
                if (this.removeMembers == null) {
                    this.removeMembers = new ArrayList();
                }
                this.removeMembers.addAll(removeMembers);
                return this;
            }

            public ChannelUpdateRequest clearRemoveMembers() {
                if (this.removeMembers != null) {
                    this.removeMembers.clear();
                }
                return this;
            }

            public ChannelUpdateRequest addModerator(String addModerator) {
                if (this.addModerators == null) {
                    this.addModerators = new ArrayList();
                }
                this.addModerators.add(addModerator);
                return this;
            }

            @JsonProperty(value="add_moderators")
            public ChannelUpdateRequest addModerators(Collection<? extends String> addModerators) {
                if (addModerators == null) {
                    throw new NullPointerException("addModerators cannot be null");
                }
                if (this.addModerators == null) {
                    this.addModerators = new ArrayList();
                }
                this.addModerators.addAll(addModerators);
                return this;
            }

            public ChannelUpdateRequest clearAddModerators() {
                if (this.addModerators != null) {
                    this.addModerators.clear();
                }
                return this;
            }

            public ChannelUpdateRequest demoteModerator(String demoteModerator) {
                if (this.demoteModerators == null) {
                    this.demoteModerators = new ArrayList();
                }
                this.demoteModerators.add(demoteModerator);
                return this;
            }

            @JsonProperty(value="demote_moderators")
            public ChannelUpdateRequest demoteModerators(Collection<? extends String> demoteModerators) {
                if (demoteModerators == null) {
                    throw new NullPointerException("demoteModerators cannot be null");
                }
                if (this.demoteModerators == null) {
                    this.demoteModerators = new ArrayList();
                }
                this.demoteModerators.addAll(demoteModerators);
                return this;
            }

            public ChannelUpdateRequest clearDemoteModerators() {
                if (this.demoteModerators != null) {
                    this.demoteModerators.clear();
                }
                return this;
            }

            public ChannelUpdateRequest invite(String invite) {
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.add(invite);
                return this;
            }

            @JsonProperty(value="invites")
            public ChannelUpdateRequest invites(Collection<? extends String> invites) {
                if (invites == null) {
                    throw new NullPointerException("invites cannot be null");
                }
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.addAll(invites);
                return this;
            }

            public ChannelUpdateRequest clearInvites() {
                if (this.invites != null) {
                    this.invites.clear();
                }
                return this;
            }

            public ChannelUpdateRequest addFilterTag(String addFilterTag) {
                if (this.addFilterTags == null) {
                    this.addFilterTags = new ArrayList();
                }
                this.addFilterTags.add(addFilterTag);
                return this;
            }

            @JsonProperty(value="add_filter_tags")
            public ChannelUpdateRequest addFilterTags(Collection<? extends String> addFilterTags) {
                if (addFilterTags == null) {
                    throw new NullPointerException("addFilterTags cannot be null");
                }
                if (this.addFilterTags == null) {
                    this.addFilterTags = new ArrayList();
                }
                this.addFilterTags.addAll(addFilterTags);
                return this;
            }

            public ChannelUpdateRequest clearAddFilterTags() {
                if (this.addFilterTags != null) {
                    this.addFilterTags.clear();
                }
                return this;
            }

            public ChannelUpdateRequest removeFilterTag(String removeFilterTag) {
                if (this.removeFilterTags == null) {
                    this.removeFilterTags = new ArrayList();
                }
                this.removeFilterTags.add(removeFilterTag);
                return this;
            }

            @JsonProperty(value="remove_filter_tags")
            public ChannelUpdateRequest removeFilterTags(Collection<? extends String> removeFilterTags) {
                if (removeFilterTags == null) {
                    throw new NullPointerException("removeFilterTags cannot be null");
                }
                if (this.removeFilterTags == null) {
                    this.removeFilterTags = new ArrayList();
                }
                this.removeFilterTags.addAll(removeFilterTags);
                return this;
            }

            public ChannelUpdateRequest clearRemoveFilterTags() {
                if (this.removeFilterTags != null) {
                    this.removeFilterTags.clear();
                }
                return this;
            }

            @JsonProperty(value="cooldown")
            public ChannelUpdateRequest cooldown(@Nullable Integer cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            @JsonProperty(value="accept_invite")
            public ChannelUpdateRequest acceptInvite(@Nullable Boolean acceptInvite) {
                this.acceptInvite = acceptInvite;
                return this;
            }

            @JsonProperty(value="reject_invite")
            public ChannelUpdateRequest rejectInvite(@Nullable Boolean rejectInvite) {
                this.rejectInvite = rejectInvite;
                return this;
            }

            @JsonProperty(value="message")
            public ChannelUpdateRequest message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="skip_push")
            public ChannelUpdateRequest skipPush(@Nullable Boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            @JsonProperty(value="hide_history")
            public ChannelUpdateRequest hideHistory(@Nullable Boolean hideHistory) {
                this.hideHistory = hideHistory;
                return this;
            }

            @JsonProperty(value="hide_history_before")
            public ChannelUpdateRequest hideHistoryBefore(@Nullable Date hideHistoryBefore) {
                this.hideHistoryBefore = hideHistoryBefore;
                return this;
            }

            @JsonProperty(value="data")
            public ChannelUpdateRequest data(@Nullable ChannelRequestObject data) {
                this.data = data;
                return this;
            }

            @JsonProperty(value="user_id")
            public ChannelUpdateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelUpdateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public ChannelUpdateRequestData internalBuild() {
                List<String> removeFilterTags;
                List<String> addFilterTags;
                List<String> invites;
                List<String> demoteModerators;
                List<String> addModerators;
                List<String> removeMembers;
                List<String> addMembers;
                switch (this.addMembers == null ? 0 : this.addMembers.size()) {
                    case 0: {
                        addMembers = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        addMembers = Collections.singletonList(this.addMembers.get(0));
                        break;
                    }
                    default: {
                        addMembers = Collections.unmodifiableList(new ArrayList<String>(this.addMembers));
                    }
                }
                switch (this.removeMembers == null ? 0 : this.removeMembers.size()) {
                    case 0: {
                        removeMembers = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        removeMembers = Collections.singletonList(this.removeMembers.get(0));
                        break;
                    }
                    default: {
                        removeMembers = Collections.unmodifiableList(new ArrayList<String>(this.removeMembers));
                    }
                }
                switch (this.addModerators == null ? 0 : this.addModerators.size()) {
                    case 0: {
                        addModerators = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        addModerators = Collections.singletonList(this.addModerators.get(0));
                        break;
                    }
                    default: {
                        addModerators = Collections.unmodifiableList(new ArrayList<String>(this.addModerators));
                    }
                }
                switch (this.demoteModerators == null ? 0 : this.demoteModerators.size()) {
                    case 0: {
                        demoteModerators = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        demoteModerators = Collections.singletonList(this.demoteModerators.get(0));
                        break;
                    }
                    default: {
                        demoteModerators = Collections.unmodifiableList(new ArrayList<String>(this.demoteModerators));
                    }
                }
                switch (this.invites == null ? 0 : this.invites.size()) {
                    case 0: {
                        invites = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        invites = Collections.singletonList(this.invites.get(0));
                        break;
                    }
                    default: {
                        invites = Collections.unmodifiableList(new ArrayList<String>(this.invites));
                    }
                }
                switch (this.addFilterTags == null ? 0 : this.addFilterTags.size()) {
                    case 0: {
                        addFilterTags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        addFilterTags = Collections.singletonList(this.addFilterTags.get(0));
                        break;
                    }
                    default: {
                        addFilterTags = Collections.unmodifiableList(new ArrayList<String>(this.addFilterTags));
                    }
                }
                switch (this.removeFilterTags == null ? 0 : this.removeFilterTags.size()) {
                    case 0: {
                        removeFilterTags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        removeFilterTags = Collections.singletonList(this.removeFilterTags.get(0));
                        break;
                    }
                    default: {
                        removeFilterTags = Collections.unmodifiableList(new ArrayList<String>(this.removeFilterTags));
                    }
                }
                return new ChannelUpdateRequestData(addMembers, removeMembers, addModerators, demoteModerators, invites, addFilterTags, removeFilterTags, this.cooldown, this.acceptInvite, this.rejectInvite, this.message, this.skipPush, this.hideHistory, this.hideHistoryBefore, this.data, this.userId, this.user);
            }

            public String toString() {
                return "Channel.ChannelUpdateRequestData.ChannelUpdateRequest(addMembers=" + String.valueOf(this.addMembers) + ", removeMembers=" + String.valueOf(this.removeMembers) + ", addModerators=" + String.valueOf(this.addModerators) + ", demoteModerators=" + String.valueOf(this.demoteModerators) + ", invites=" + String.valueOf(this.invites) + ", addFilterTags=" + String.valueOf(this.addFilterTags) + ", removeFilterTags=" + String.valueOf(this.removeFilterTags) + ", cooldown=" + this.cooldown + ", acceptInvite=" + this.acceptInvite + ", rejectInvite=" + this.rejectInvite + ", message=" + String.valueOf(this.message) + ", skipPush=" + this.skipPush + ", hideHistory=" + this.hideHistory + ", hideHistoryBefore=" + String.valueOf(this.hideHistoryBefore) + ", data=" + String.valueOf(this.data) + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class ChannelGetRequestData {
        @JsonProperty(value="connection_id")
        @Nullable
        private String connectionId;
        @JsonProperty(value="data")
        @Nullable
        private ChannelRequestObject data;
        @JsonProperty(value="watch")
        @Nullable
        private Boolean watch;
        @JsonProperty(value="state")
        @Nullable
        private Boolean state;
        @JsonProperty(value="presence")
        @Nullable
        private Boolean presence;
        @JsonProperty(value="messages")
        @Nullable
        private MessagePaginationParameters messages;
        @JsonProperty(value="members")
        @Nullable
        private PaginationParameters members;
        @JsonProperty(value="watchers")
        @Nullable
        private PaginationParameters watchers;

        ChannelGetRequestData(@Nullable String connectionId, @Nullable ChannelRequestObject data, @Nullable Boolean watch, @Nullable Boolean state, @Nullable Boolean presence, @Nullable MessagePaginationParameters messages, @Nullable PaginationParameters members, @Nullable PaginationParameters watchers) {
            this.connectionId = connectionId;
            this.data = data;
            this.watch = watch;
            this.state = state;
            this.presence = presence;
            this.messages = messages;
            this.members = members;
            this.watchers = watchers;
        }

        @Nullable
        public String getConnectionId() {
            return this.connectionId;
        }

        @Nullable
        public ChannelRequestObject getData() {
            return this.data;
        }

        @Nullable
        public Boolean getWatch() {
            return this.watch;
        }

        @Nullable
        public Boolean getState() {
            return this.state;
        }

        @Nullable
        public Boolean getPresence() {
            return this.presence;
        }

        @Nullable
        public MessagePaginationParameters getMessages() {
            return this.messages;
        }

        @Nullable
        public PaginationParameters getMembers() {
            return this.members;
        }

        @Nullable
        public PaginationParameters getWatchers() {
            return this.watchers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelGetRequestData)) {
                return false;
            }
            ChannelGetRequestData other = (ChannelGetRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$watch = this.getWatch();
            Boolean other$watch = other.getWatch();
            if (this$watch == null ? other$watch != null : !((Object)this$watch).equals(other$watch)) {
                return false;
            }
            Boolean this$state = this.getState();
            Boolean other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            Boolean this$presence = this.getPresence();
            Boolean other$presence = other.getPresence();
            if (this$presence == null ? other$presence != null : !((Object)this$presence).equals(other$presence)) {
                return false;
            }
            String this$connectionId = this.getConnectionId();
            String other$connectionId = other.getConnectionId();
            if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
                return false;
            }
            ChannelRequestObject this$data = this.getData();
            ChannelRequestObject other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            MessagePaginationParameters this$messages = this.getMessages();
            MessagePaginationParameters other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            PaginationParameters this$members = this.getMembers();
            PaginationParameters other$members = other.getMembers();
            if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
                return false;
            }
            PaginationParameters this$watchers = this.getWatchers();
            PaginationParameters other$watchers = other.getWatchers();
            return !(this$watchers == null ? other$watchers != null : !((Object)this$watchers).equals(other$watchers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelGetRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $watch = this.getWatch();
            result = result * 59 + ($watch == null ? 43 : ((Object)$watch).hashCode());
            Boolean $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            Boolean $presence = this.getPresence();
            result = result * 59 + ($presence == null ? 43 : ((Object)$presence).hashCode());
            String $connectionId = this.getConnectionId();
            result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
            ChannelRequestObject $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            MessagePaginationParameters $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            PaginationParameters $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            PaginationParameters $watchers = this.getWatchers();
            result = result * 59 + ($watchers == null ? 43 : ((Object)$watchers).hashCode());
            return result;
        }

        public static class ChannelGetRequest
        extends StreamRequest<ChannelGetResponse> {
            private String connectionId;
            private ChannelRequestObject data;
            private Boolean watch;
            private Boolean state;
            private Boolean presence;
            private MessagePaginationParameters messages;
            private PaginationParameters members;
            private PaginationParameters watchers;
            @NotNull
            private String channelType;
            @Nullable
            private String channelId;

            private ChannelGetRequest(@NotNull String channelType, @Nullable String channelId) {
                this.channelId = channelId;
                this.channelType = channelType;
            }

            @Override
            protected Call<ChannelGetResponse> generateCall(Client client) {
                if (this.channelId != null) {
                    return client.create(ChannelService.class).getOrCreateWithId(this.channelType, this.channelId, this.internalBuild());
                }
                return client.create(ChannelService.class).getOrCreateWithoutId(this.channelType, this.internalBuild());
            }

            @JsonProperty(value="connection_id")
            public ChannelGetRequest connectionId(@Nullable String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            @JsonProperty(value="data")
            public ChannelGetRequest data(@Nullable ChannelRequestObject data) {
                this.data = data;
                return this;
            }

            @JsonProperty(value="watch")
            public ChannelGetRequest watch(@Nullable Boolean watch) {
                this.watch = watch;
                return this;
            }

            @JsonProperty(value="state")
            public ChannelGetRequest state(@Nullable Boolean state) {
                this.state = state;
                return this;
            }

            @JsonProperty(value="presence")
            public ChannelGetRequest presence(@Nullable Boolean presence) {
                this.presence = presence;
                return this;
            }

            @JsonProperty(value="messages")
            public ChannelGetRequest messages(@Nullable MessagePaginationParameters messages) {
                this.messages = messages;
                return this;
            }

            @JsonProperty(value="members")
            public ChannelGetRequest members(@Nullable PaginationParameters members) {
                this.members = members;
                return this;
            }

            @JsonProperty(value="watchers")
            public ChannelGetRequest watchers(@Nullable PaginationParameters watchers) {
                this.watchers = watchers;
                return this;
            }

            public ChannelGetRequestData internalBuild() {
                return new ChannelGetRequestData(this.connectionId, this.data, this.watch, this.state, this.presence, this.messages, this.members, this.watchers);
            }

            public String toString() {
                return "Channel.ChannelGetRequestData.ChannelGetRequest(connectionId=" + this.connectionId + ", data=" + String.valueOf(this.data) + ", watch=" + this.watch + ", state=" + this.state + ", presence=" + this.presence + ", messages=" + String.valueOf(this.messages) + ", members=" + String.valueOf(this.members) + ", watchers=" + String.valueOf(this.watchers) + ")";
            }
        }
    }

    public static class ChannelExportRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="messages_since")
        @Nullable
        private Date messagesSince;
        @JsonProperty(value="messages_until")
        @Nullable
        private Date messagesUntil;

        ChannelExportRequestObject(@Nullable String type, @Nullable String id, @Nullable Date messagesSince, @Nullable Date messagesUntil) {
            this.type = type;
            this.id = id;
            this.messagesSince = messagesSince;
            this.messagesUntil = messagesUntil;
        }

        public static ChannelExportRequestObjectBuilder builder() {
            return new ChannelExportRequestObjectBuilder();
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public Date getMessagesSince() {
            return this.messagesSince;
        }

        @Nullable
        public Date getMessagesUntil() {
            return this.messagesUntil;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelExportRequestObject)) {
                return false;
            }
            ChannelExportRequestObject other = (ChannelExportRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Date this$messagesSince = this.getMessagesSince();
            Date other$messagesSince = other.getMessagesSince();
            if (this$messagesSince == null ? other$messagesSince != null : !((Object)this$messagesSince).equals(other$messagesSince)) {
                return false;
            }
            Date this$messagesUntil = this.getMessagesUntil();
            Date other$messagesUntil = other.getMessagesUntil();
            return !(this$messagesUntil == null ? other$messagesUntil != null : !((Object)this$messagesUntil).equals(other$messagesUntil));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelExportRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Date $messagesSince = this.getMessagesSince();
            result = result * 59 + ($messagesSince == null ? 43 : ((Object)$messagesSince).hashCode());
            Date $messagesUntil = this.getMessagesUntil();
            result = result * 59 + ($messagesUntil == null ? 43 : ((Object)$messagesUntil).hashCode());
            return result;
        }

        public static class ChannelExportRequestObjectBuilder {
            private String type;
            private String id;
            private Date messagesSince;
            private Date messagesUntil;

            ChannelExportRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public ChannelExportRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="id")
            public ChannelExportRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="messages_since")
            public ChannelExportRequestObjectBuilder messagesSince(@Nullable Date messagesSince) {
                this.messagesSince = messagesSince;
                return this;
            }

            @JsonProperty(value="messages_until")
            public ChannelExportRequestObjectBuilder messagesUntil(@Nullable Date messagesUntil) {
                this.messagesUntil = messagesUntil;
                return this;
            }

            public ChannelExportRequestObject build() {
                return new ChannelExportRequestObject(this.type, this.id, this.messagesSince, this.messagesUntil);
            }

            public String toString() {
                return "Channel.ChannelExportRequestObject.ChannelExportRequestObjectBuilder(type=" + this.type + ", id=" + this.id + ", messagesSince=" + String.valueOf(this.messagesSince) + ", messagesUntil=" + String.valueOf(this.messagesUntil) + ")";
            }
        }
    }

    public static class ConfigOverridesRequestObject {
        @JsonProperty(value="typing_events")
        @Nullable
        private Boolean typingEvents;
        @JsonProperty(value="reactions")
        @Nullable
        private Boolean reactions;
        @JsonProperty(value="replies")
        @Nullable
        private Boolean replies;
        @JsonProperty(value="uploads")
        @Nullable
        private Boolean uploads;
        @JsonProperty(value="url_enrichment")
        @Nullable
        private Boolean urlEnrichment;
        @JsonProperty(value="max_message_length")
        @Nullable
        private Integer maxMessageLength;
        @JsonProperty(value="blocklist")
        @Nullable
        private String blocklist;
        @JsonProperty(value="blocklist_behavior")
        @Nullable
        private ChannelType.BlocklistBehavior blocklistBehavior;
        @JsonProperty(value="commands")
        @Nullable
        private List<String> Commands;
        @JsonProperty(value="user_message_reminders")
        @Nullable
        private Boolean userMessageReminders;
        @JsonProperty(value="shared_locations")
        @Nullable
        private Boolean sharedLocations;
        @JsonProperty(value="count_messages")
        @Nullable
        private Boolean countMessages;

        ConfigOverridesRequestObject(@Nullable Boolean typingEvents, @Nullable Boolean reactions, @Nullable Boolean replies, @Nullable Boolean uploads, @Nullable Boolean urlEnrichment, @Nullable Integer maxMessageLength, @Nullable String blocklist, @Nullable ChannelType.BlocklistBehavior blocklistBehavior, @Nullable List<String> Commands, @Nullable Boolean userMessageReminders, @Nullable Boolean sharedLocations, @Nullable Boolean countMessages) {
            this.typingEvents = typingEvents;
            this.reactions = reactions;
            this.replies = replies;
            this.uploads = uploads;
            this.urlEnrichment = urlEnrichment;
            this.maxMessageLength = maxMessageLength;
            this.blocklist = blocklist;
            this.blocklistBehavior = blocklistBehavior;
            this.Commands = Commands;
            this.userMessageReminders = userMessageReminders;
            this.sharedLocations = sharedLocations;
            this.countMessages = countMessages;
        }

        public static ConfigOverridesRequestObjectBuilder builder() {
            return new ConfigOverridesRequestObjectBuilder();
        }

        @Nullable
        public Boolean getTypingEvents() {
            return this.typingEvents;
        }

        @Nullable
        public Boolean getReactions() {
            return this.reactions;
        }

        @Nullable
        public Boolean getReplies() {
            return this.replies;
        }

        @Nullable
        public Boolean getUploads() {
            return this.uploads;
        }

        @Nullable
        public Boolean getUrlEnrichment() {
            return this.urlEnrichment;
        }

        @Nullable
        public Integer getMaxMessageLength() {
            return this.maxMessageLength;
        }

        @Nullable
        public String getBlocklist() {
            return this.blocklist;
        }

        @Nullable
        public ChannelType.BlocklistBehavior getBlocklistBehavior() {
            return this.blocklistBehavior;
        }

        @Nullable
        public List<String> getCommands() {
            return this.Commands;
        }

        @Nullable
        public Boolean getUserMessageReminders() {
            return this.userMessageReminders;
        }

        @Nullable
        public Boolean getSharedLocations() {
            return this.sharedLocations;
        }

        @Nullable
        public Boolean getCountMessages() {
            return this.countMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigOverridesRequestObject)) {
                return false;
            }
            ConfigOverridesRequestObject other = (ConfigOverridesRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$typingEvents = this.getTypingEvents();
            Boolean other$typingEvents = other.getTypingEvents();
            if (this$typingEvents == null ? other$typingEvents != null : !((Object)this$typingEvents).equals(other$typingEvents)) {
                return false;
            }
            Boolean this$reactions = this.getReactions();
            Boolean other$reactions = other.getReactions();
            if (this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions)) {
                return false;
            }
            Boolean this$replies = this.getReplies();
            Boolean other$replies = other.getReplies();
            if (this$replies == null ? other$replies != null : !((Object)this$replies).equals(other$replies)) {
                return false;
            }
            Boolean this$uploads = this.getUploads();
            Boolean other$uploads = other.getUploads();
            if (this$uploads == null ? other$uploads != null : !((Object)this$uploads).equals(other$uploads)) {
                return false;
            }
            Boolean this$urlEnrichment = this.getUrlEnrichment();
            Boolean other$urlEnrichment = other.getUrlEnrichment();
            if (this$urlEnrichment == null ? other$urlEnrichment != null : !((Object)this$urlEnrichment).equals(other$urlEnrichment)) {
                return false;
            }
            Integer this$maxMessageLength = this.getMaxMessageLength();
            Integer other$maxMessageLength = other.getMaxMessageLength();
            if (this$maxMessageLength == null ? other$maxMessageLength != null : !((Object)this$maxMessageLength).equals(other$maxMessageLength)) {
                return false;
            }
            Boolean this$userMessageReminders = this.getUserMessageReminders();
            Boolean other$userMessageReminders = other.getUserMessageReminders();
            if (this$userMessageReminders == null ? other$userMessageReminders != null : !((Object)this$userMessageReminders).equals(other$userMessageReminders)) {
                return false;
            }
            Boolean this$sharedLocations = this.getSharedLocations();
            Boolean other$sharedLocations = other.getSharedLocations();
            if (this$sharedLocations == null ? other$sharedLocations != null : !((Object)this$sharedLocations).equals(other$sharedLocations)) {
                return false;
            }
            Boolean this$countMessages = this.getCountMessages();
            Boolean other$countMessages = other.getCountMessages();
            if (this$countMessages == null ? other$countMessages != null : !((Object)this$countMessages).equals(other$countMessages)) {
                return false;
            }
            String this$blocklist = this.getBlocklist();
            String other$blocklist = other.getBlocklist();
            if (this$blocklist == null ? other$blocklist != null : !this$blocklist.equals(other$blocklist)) {
                return false;
            }
            ChannelType.BlocklistBehavior this$blocklistBehavior = this.getBlocklistBehavior();
            ChannelType.BlocklistBehavior other$blocklistBehavior = other.getBlocklistBehavior();
            if (this$blocklistBehavior == null ? other$blocklistBehavior != null : !((Object)((Object)this$blocklistBehavior)).equals((Object)other$blocklistBehavior)) {
                return false;
            }
            List<String> this$Commands = this.getCommands();
            List<String> other$Commands = other.getCommands();
            return !(this$Commands == null ? other$Commands != null : !((Object)this$Commands).equals(other$Commands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigOverridesRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $typingEvents = this.getTypingEvents();
            result = result * 59 + ($typingEvents == null ? 43 : ((Object)$typingEvents).hashCode());
            Boolean $reactions = this.getReactions();
            result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
            Boolean $replies = this.getReplies();
            result = result * 59 + ($replies == null ? 43 : ((Object)$replies).hashCode());
            Boolean $uploads = this.getUploads();
            result = result * 59 + ($uploads == null ? 43 : ((Object)$uploads).hashCode());
            Boolean $urlEnrichment = this.getUrlEnrichment();
            result = result * 59 + ($urlEnrichment == null ? 43 : ((Object)$urlEnrichment).hashCode());
            Integer $maxMessageLength = this.getMaxMessageLength();
            result = result * 59 + ($maxMessageLength == null ? 43 : ((Object)$maxMessageLength).hashCode());
            Boolean $userMessageReminders = this.getUserMessageReminders();
            result = result * 59 + ($userMessageReminders == null ? 43 : ((Object)$userMessageReminders).hashCode());
            Boolean $sharedLocations = this.getSharedLocations();
            result = result * 59 + ($sharedLocations == null ? 43 : ((Object)$sharedLocations).hashCode());
            Boolean $countMessages = this.getCountMessages();
            result = result * 59 + ($countMessages == null ? 43 : ((Object)$countMessages).hashCode());
            String $blocklist = this.getBlocklist();
            result = result * 59 + ($blocklist == null ? 43 : $blocklist.hashCode());
            ChannelType.BlocklistBehavior $blocklistBehavior = this.getBlocklistBehavior();
            result = result * 59 + ($blocklistBehavior == null ? 43 : ((Object)((Object)$blocklistBehavior)).hashCode());
            List<String> $Commands = this.getCommands();
            result = result * 59 + ($Commands == null ? 43 : ((Object)$Commands).hashCode());
            return result;
        }

        public static class ConfigOverridesRequestObjectBuilder {
            private Boolean typingEvents;
            private Boolean reactions;
            private Boolean replies;
            private Boolean uploads;
            private Boolean urlEnrichment;
            private Integer maxMessageLength;
            private String blocklist;
            private ChannelType.BlocklistBehavior blocklistBehavior;
            private List<String> Commands;
            private Boolean userMessageReminders;
            private Boolean sharedLocations;
            private Boolean countMessages;

            ConfigOverridesRequestObjectBuilder() {
            }

            @JsonProperty(value="typing_events")
            public ConfigOverridesRequestObjectBuilder typingEvents(@Nullable Boolean typingEvents) {
                this.typingEvents = typingEvents;
                return this;
            }

            @JsonProperty(value="reactions")
            public ConfigOverridesRequestObjectBuilder reactions(@Nullable Boolean reactions) {
                this.reactions = reactions;
                return this;
            }

            @JsonProperty(value="replies")
            public ConfigOverridesRequestObjectBuilder replies(@Nullable Boolean replies) {
                this.replies = replies;
                return this;
            }

            @JsonProperty(value="uploads")
            public ConfigOverridesRequestObjectBuilder uploads(@Nullable Boolean uploads) {
                this.uploads = uploads;
                return this;
            }

            @JsonProperty(value="url_enrichment")
            public ConfigOverridesRequestObjectBuilder urlEnrichment(@Nullable Boolean urlEnrichment) {
                this.urlEnrichment = urlEnrichment;
                return this;
            }

            @JsonProperty(value="max_message_length")
            public ConfigOverridesRequestObjectBuilder maxMessageLength(@Nullable Integer maxMessageLength) {
                this.maxMessageLength = maxMessageLength;
                return this;
            }

            @JsonProperty(value="blocklist")
            public ConfigOverridesRequestObjectBuilder blocklist(@Nullable String blocklist) {
                this.blocklist = blocklist;
                return this;
            }

            @JsonProperty(value="blocklist_behavior")
            public ConfigOverridesRequestObjectBuilder blocklistBehavior(@Nullable ChannelType.BlocklistBehavior blocklistBehavior) {
                this.blocklistBehavior = blocklistBehavior;
                return this;
            }

            @JsonProperty(value="commands")
            public ConfigOverridesRequestObjectBuilder Commands(@Nullable List<String> Commands) {
                this.Commands = Commands;
                return this;
            }

            @JsonProperty(value="user_message_reminders")
            public ConfigOverridesRequestObjectBuilder userMessageReminders(@Nullable Boolean userMessageReminders) {
                this.userMessageReminders = userMessageReminders;
                return this;
            }

            @JsonProperty(value="shared_locations")
            public ConfigOverridesRequestObjectBuilder sharedLocations(@Nullable Boolean sharedLocations) {
                this.sharedLocations = sharedLocations;
                return this;
            }

            @JsonProperty(value="count_messages")
            public ConfigOverridesRequestObjectBuilder countMessages(@Nullable Boolean countMessages) {
                this.countMessages = countMessages;
                return this;
            }

            public ConfigOverridesRequestObject build() {
                return new ConfigOverridesRequestObject(this.typingEvents, this.reactions, this.replies, this.uploads, this.urlEnrichment, this.maxMessageLength, this.blocklist, this.blocklistBehavior, this.Commands, this.userMessageReminders, this.sharedLocations, this.countMessages);
            }

            public String toString() {
                return "Channel.ConfigOverridesRequestObject.ConfigOverridesRequestObjectBuilder(typingEvents=" + this.typingEvents + ", reactions=" + this.reactions + ", replies=" + this.replies + ", uploads=" + this.uploads + ", urlEnrichment=" + this.urlEnrichment + ", maxMessageLength=" + this.maxMessageLength + ", blocklist=" + this.blocklist + ", blocklistBehavior=" + String.valueOf((Object)this.blocklistBehavior) + ", Commands=" + String.valueOf(this.Commands) + ", userMessageReminders=" + this.userMessageReminders + ", sharedLocations=" + this.sharedLocations + ", countMessages=" + this.countMessages + ")";
            }
        }
    }

    public static class ChannelMemberRequestObject {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="is_moderator")
        @Nullable
        private Boolean isModerator;
        @JsonProperty(value="invited")
        @Nullable
        private Boolean invited;
        @JsonProperty(value="invite_accepted_at")
        @Nullable
        private Date inviteAcceptedAt;
        @JsonProperty(value="invite_rejected_at")
        @Nullable
        private Date inviteRejectedAt;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="channel_role")
        @Nullable
        private String channelRole;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="ban_expires")
        @Nullable
        private String banExpires;
        @JsonProperty(value="shadow_banned")
        @Nullable
        private Boolean shadowBanned;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static ChannelMemberRequestObject buildFrom(@Nullable ChannelMember channelMember) {
            return RequestObjectBuilder.build(ChannelMemberRequestObject.class, channelMember);
        }

        ChannelMemberRequestObject(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Boolean isModerator, @Nullable Boolean invited, @Nullable Date inviteAcceptedAt, @Nullable Date inviteRejectedAt, @Nullable String role, @Nullable String channelRole, @Nullable Date createdAt, @Nullable Date updatedAt, @Nullable Boolean banned, @Nullable String banExpires, @Nullable Boolean shadowBanned, @Nullable Map<String, Object> additionalFields) {
            this.userId = userId;
            this.user = user;
            this.isModerator = isModerator;
            this.invited = invited;
            this.inviteAcceptedAt = inviteAcceptedAt;
            this.inviteRejectedAt = inviteRejectedAt;
            this.role = role;
            this.channelRole = channelRole;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.banned = banned;
            this.banExpires = banExpires;
            this.shadowBanned = shadowBanned;
            this.additionalFields = additionalFields;
        }

        public static ChannelMemberRequestObjectBuilder builder() {
            return new ChannelMemberRequestObjectBuilder();
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User.UserRequestObject user) {
            this.user = user;
        }

        @JsonProperty(value="is_moderator")
        public void setIsModerator(@Nullable Boolean isModerator) {
            this.isModerator = isModerator;
        }

        @JsonProperty(value="invited")
        public void setInvited(@Nullable Boolean invited) {
            this.invited = invited;
        }

        @JsonProperty(value="invite_accepted_at")
        public void setInviteAcceptedAt(@Nullable Date inviteAcceptedAt) {
            this.inviteAcceptedAt = inviteAcceptedAt;
        }

        @JsonProperty(value="invite_rejected_at")
        public void setInviteRejectedAt(@Nullable Date inviteRejectedAt) {
            this.inviteRejectedAt = inviteRejectedAt;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="channel_role")
        public void setChannelRole(@Nullable String channelRole) {
            this.channelRole = channelRole;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="ban_expires")
        public void setBanExpires(@Nullable String banExpires) {
            this.banExpires = banExpires;
        }

        @JsonProperty(value="shadow_banned")
        public void setShadowBanned(@Nullable Boolean shadowBanned) {
            this.shadowBanned = shadowBanned;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        @Nullable
        public Boolean getIsModerator() {
            return this.isModerator;
        }

        @Nullable
        public Boolean getInvited() {
            return this.invited;
        }

        @Nullable
        public Date getInviteAcceptedAt() {
            return this.inviteAcceptedAt;
        }

        @Nullable
        public Date getInviteRejectedAt() {
            return this.inviteRejectedAt;
        }

        @Nullable
        public String getRole() {
            return this.role;
        }

        @Nullable
        public String getChannelRole() {
            return this.channelRole;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public Boolean getBanned() {
            return this.banned;
        }

        @Nullable
        public String getBanExpires() {
            return this.banExpires;
        }

        @Nullable
        public Boolean getShadowBanned() {
            return this.shadowBanned;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMemberRequestObject)) {
                return false;
            }
            ChannelMemberRequestObject other = (ChannelMemberRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isModerator = this.getIsModerator();
            Boolean other$isModerator = other.getIsModerator();
            if (this$isModerator == null ? other$isModerator != null : !((Object)this$isModerator).equals(other$isModerator)) {
                return false;
            }
            Boolean this$invited = this.getInvited();
            Boolean other$invited = other.getInvited();
            if (this$invited == null ? other$invited != null : !((Object)this$invited).equals(other$invited)) {
                return false;
            }
            Boolean this$banned = this.getBanned();
            Boolean other$banned = other.getBanned();
            if (this$banned == null ? other$banned != null : !((Object)this$banned).equals(other$banned)) {
                return false;
            }
            Boolean this$shadowBanned = this.getShadowBanned();
            Boolean other$shadowBanned = other.getShadowBanned();
            if (this$shadowBanned == null ? other$shadowBanned != null : !((Object)this$shadowBanned).equals(other$shadowBanned)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$inviteAcceptedAt = this.getInviteAcceptedAt();
            Date other$inviteAcceptedAt = other.getInviteAcceptedAt();
            if (this$inviteAcceptedAt == null ? other$inviteAcceptedAt != null : !((Object)this$inviteAcceptedAt).equals(other$inviteAcceptedAt)) {
                return false;
            }
            Date this$inviteRejectedAt = this.getInviteRejectedAt();
            Date other$inviteRejectedAt = other.getInviteRejectedAt();
            if (this$inviteRejectedAt == null ? other$inviteRejectedAt != null : !((Object)this$inviteRejectedAt).equals(other$inviteRejectedAt)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$channelRole = this.getChannelRole();
            String other$channelRole = other.getChannelRole();
            if (this$channelRole == null ? other$channelRole != null : !this$channelRole.equals(other$channelRole)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            String this$banExpires = this.getBanExpires();
            String other$banExpires = other.getBanExpires();
            if (this$banExpires == null ? other$banExpires != null : !this$banExpires.equals(other$banExpires)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMemberRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isModerator = this.getIsModerator();
            result = result * 59 + ($isModerator == null ? 43 : ((Object)$isModerator).hashCode());
            Boolean $invited = this.getInvited();
            result = result * 59 + ($invited == null ? 43 : ((Object)$invited).hashCode());
            Boolean $banned = this.getBanned();
            result = result * 59 + ($banned == null ? 43 : ((Object)$banned).hashCode());
            Boolean $shadowBanned = this.getShadowBanned();
            result = result * 59 + ($shadowBanned == null ? 43 : ((Object)$shadowBanned).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $inviteAcceptedAt = this.getInviteAcceptedAt();
            result = result * 59 + ($inviteAcceptedAt == null ? 43 : ((Object)$inviteAcceptedAt).hashCode());
            Date $inviteRejectedAt = this.getInviteRejectedAt();
            result = result * 59 + ($inviteRejectedAt == null ? 43 : ((Object)$inviteRejectedAt).hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $channelRole = this.getChannelRole();
            result = result * 59 + ($channelRole == null ? 43 : $channelRole.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            String $banExpires = this.getBanExpires();
            result = result * 59 + ($banExpires == null ? 43 : $banExpires.hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public static class ChannelMemberRequestObjectBuilder {
            private String userId;
            private User.UserRequestObject user;
            private Boolean isModerator;
            private Boolean invited;
            private Date inviteAcceptedAt;
            private Date inviteRejectedAt;
            private String role;
            private String channelRole;
            private Date createdAt;
            private Date updatedAt;
            private Boolean banned;
            private String banExpires;
            private Boolean shadowBanned;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            ChannelMemberRequestObjectBuilder() {
            }

            @JsonProperty(value="user_id")
            public ChannelMemberRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ChannelMemberRequestObjectBuilder user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="is_moderator")
            public ChannelMemberRequestObjectBuilder isModerator(@Nullable Boolean isModerator) {
                this.isModerator = isModerator;
                return this;
            }

            @JsonProperty(value="invited")
            public ChannelMemberRequestObjectBuilder invited(@Nullable Boolean invited) {
                this.invited = invited;
                return this;
            }

            @JsonProperty(value="invite_accepted_at")
            public ChannelMemberRequestObjectBuilder inviteAcceptedAt(@Nullable Date inviteAcceptedAt) {
                this.inviteAcceptedAt = inviteAcceptedAt;
                return this;
            }

            @JsonProperty(value="invite_rejected_at")
            public ChannelMemberRequestObjectBuilder inviteRejectedAt(@Nullable Date inviteRejectedAt) {
                this.inviteRejectedAt = inviteRejectedAt;
                return this;
            }

            @JsonProperty(value="role")
            public ChannelMemberRequestObjectBuilder role(@Nullable String role) {
                this.role = role;
                return this;
            }

            @JsonProperty(value="channel_role")
            public ChannelMemberRequestObjectBuilder channelRole(@Nullable String channelRole) {
                this.channelRole = channelRole;
                return this;
            }

            @JsonProperty(value="created_at")
            public ChannelMemberRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonProperty(value="updated_at")
            public ChannelMemberRequestObjectBuilder updatedAt(@Nullable Date updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            @JsonProperty(value="banned")
            public ChannelMemberRequestObjectBuilder banned(@Nullable Boolean banned) {
                this.banned = banned;
                return this;
            }

            @JsonProperty(value="ban_expires")
            public ChannelMemberRequestObjectBuilder banExpires(@Nullable String banExpires) {
                this.banExpires = banExpires;
                return this;
            }

            @JsonProperty(value="shadow_banned")
            public ChannelMemberRequestObjectBuilder shadowBanned(@Nullable Boolean shadowBanned) {
                this.shadowBanned = shadowBanned;
                return this;
            }

            public ChannelMemberRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public ChannelMemberRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelMemberRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public ChannelMemberRequestObject build() {
                Map<Object, Object> additionalFields;
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new ChannelMemberRequestObject(this.userId, this.user, this.isModerator, this.invited, this.inviteAcceptedAt, this.inviteRejectedAt, this.role, this.channelRole, this.createdAt, this.updatedAt, this.banned, this.banExpires, this.shadowBanned, additionalFields);
            }

            public String toString() {
                return "Channel.ChannelMemberRequestObject.ChannelMemberRequestObjectBuilder(userId=" + this.userId + ", user=" + String.valueOf(this.user) + ", isModerator=" + this.isModerator + ", invited=" + this.invited + ", inviteAcceptedAt=" + String.valueOf(this.inviteAcceptedAt) + ", inviteRejectedAt=" + String.valueOf(this.inviteRejectedAt) + ", role=" + this.role + ", channelRole=" + this.channelRole + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", banned=" + this.banned + ", banExpires=" + this.banExpires + ", shadowBanned=" + this.shadowBanned + ", additionalFields$key=" + String.valueOf(this.additionalFields$key) + ", additionalFields$value=" + String.valueOf(this.additionalFields$value) + ")";
            }
        }
    }

    public static class ChannelRequestObject {
        @JsonProperty(value="created_by")
        @Nullable
        private User.UserRequestObject createdBy;
        @JsonProperty(value="team")
        @Nullable
        private String team;
        @JsonProperty(value="auto_translation_enabled")
        @Nullable
        private Boolean autoTranslationEnabled;
        @JsonProperty(value="auto_translation_language")
        @Nullable
        private Language autoTranslationLanguage;
        @JsonProperty(value="frozen")
        @Nullable
        private Boolean frozen;
        @JsonProperty(value="members")
        @Nullable
        private List<ChannelMemberRequestObject> members;
        @JsonProperty(value="invites")
        @Nullable
        private List<ChannelMemberRequestObject> invites;
        @JsonProperty(value="config_overrides")
        @Nullable
        private ConfigOverridesRequestObject configOverrides;
        @JsonProperty(value="filter_tags")
        @Nullable
        private List<String> filterTags;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static ChannelRequestObject buildFrom(@Nullable Channel channel) {
            return RequestObjectBuilder.build(ChannelRequestObject.class, channel);
        }

        private ChannelRequestObject(@Nullable User.UserRequestObject createdBy, @Nullable String team, @Nullable Boolean autoTranslationEnabled, @Nullable Language autoTranslationLanguage, @Nullable Boolean frozen, @Nullable List<ChannelMemberRequestObject> members, @Nullable List<ChannelMemberRequestObject> invites, @Nullable ConfigOverridesRequestObject configOverrides, @Nullable List<String> filterTags, Map<String, Object> additionalFields) {
            this.createdBy = createdBy;
            this.team = team;
            this.autoTranslationEnabled = autoTranslationEnabled;
            this.autoTranslationLanguage = autoTranslationLanguage;
            this.frozen = frozen;
            this.members = members;
            this.invites = invites;
            this.configOverrides = configOverrides;
            this.filterTags = filterTags;
            this.additionalFields = new HashMap<String, Object>(additionalFields);
        }

        public static ChannelRequestObjectBuilder builder() {
            return new ChannelRequestObjectBuilder();
        }

        @JsonProperty(value="created_by")
        public void setCreatedBy(@Nullable User.UserRequestObject createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty(value="team")
        public void setTeam(@Nullable String team) {
            this.team = team;
        }

        @JsonProperty(value="auto_translation_enabled")
        public void setAutoTranslationEnabled(@Nullable Boolean autoTranslationEnabled) {
            this.autoTranslationEnabled = autoTranslationEnabled;
        }

        @JsonProperty(value="auto_translation_language")
        public void setAutoTranslationLanguage(@Nullable Language autoTranslationLanguage) {
            this.autoTranslationLanguage = autoTranslationLanguage;
        }

        @JsonProperty(value="frozen")
        public void setFrozen(@Nullable Boolean frozen) {
            this.frozen = frozen;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<ChannelMemberRequestObject> members) {
            this.members = members;
        }

        @JsonProperty(value="invites")
        public void setInvites(@Nullable List<ChannelMemberRequestObject> invites) {
            this.invites = invites;
        }

        @JsonProperty(value="config_overrides")
        public void setConfigOverrides(@Nullable ConfigOverridesRequestObject configOverrides) {
            this.configOverrides = configOverrides;
        }

        @JsonProperty(value="filter_tags")
        public void setFilterTags(@Nullable List<String> filterTags) {
            this.filterTags = filterTags;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        @Nullable
        public User.UserRequestObject getCreatedBy() {
            return this.createdBy;
        }

        @Nullable
        public String getTeam() {
            return this.team;
        }

        @Nullable
        public Boolean getAutoTranslationEnabled() {
            return this.autoTranslationEnabled;
        }

        @Nullable
        public Language getAutoTranslationLanguage() {
            return this.autoTranslationLanguage;
        }

        @Nullable
        public Boolean getFrozen() {
            return this.frozen;
        }

        @Nullable
        public List<ChannelMemberRequestObject> getMembers() {
            return this.members;
        }

        @Nullable
        public List<ChannelMemberRequestObject> getInvites() {
            return this.invites;
        }

        @Nullable
        public ConfigOverridesRequestObject getConfigOverrides() {
            return this.configOverrides;
        }

        @Nullable
        public List<String> getFilterTags() {
            return this.filterTags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelRequestObject)) {
                return false;
            }
            ChannelRequestObject other = (ChannelRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$autoTranslationEnabled = this.getAutoTranslationEnabled();
            Boolean other$autoTranslationEnabled = other.getAutoTranslationEnabled();
            if (this$autoTranslationEnabled == null ? other$autoTranslationEnabled != null : !((Object)this$autoTranslationEnabled).equals(other$autoTranslationEnabled)) {
                return false;
            }
            Boolean this$frozen = this.getFrozen();
            Boolean other$frozen = other.getFrozen();
            if (this$frozen == null ? other$frozen != null : !((Object)this$frozen).equals(other$frozen)) {
                return false;
            }
            User.UserRequestObject this$createdBy = this.getCreatedBy();
            User.UserRequestObject other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
                return false;
            }
            String this$team = this.getTeam();
            String other$team = other.getTeam();
            if (this$team == null ? other$team != null : !this$team.equals(other$team)) {
                return false;
            }
            Language this$autoTranslationLanguage = this.getAutoTranslationLanguage();
            Language other$autoTranslationLanguage = other.getAutoTranslationLanguage();
            if (this$autoTranslationLanguage == null ? other$autoTranslationLanguage != null : !((Object)((Object)this$autoTranslationLanguage)).equals((Object)other$autoTranslationLanguage)) {
                return false;
            }
            List<ChannelMemberRequestObject> this$members = this.getMembers();
            List<ChannelMemberRequestObject> other$members = other.getMembers();
            if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
                return false;
            }
            List<ChannelMemberRequestObject> this$invites = this.getInvites();
            List<ChannelMemberRequestObject> other$invites = other.getInvites();
            if (this$invites == null ? other$invites != null : !((Object)this$invites).equals(other$invites)) {
                return false;
            }
            ConfigOverridesRequestObject this$configOverrides = this.getConfigOverrides();
            ConfigOverridesRequestObject other$configOverrides = other.getConfigOverrides();
            if (this$configOverrides == null ? other$configOverrides != null : !((Object)this$configOverrides).equals(other$configOverrides)) {
                return false;
            }
            List<String> this$filterTags = this.getFilterTags();
            List<String> other$filterTags = other.getFilterTags();
            if (this$filterTags == null ? other$filterTags != null : !((Object)this$filterTags).equals(other$filterTags)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $autoTranslationEnabled = this.getAutoTranslationEnabled();
            result = result * 59 + ($autoTranslationEnabled == null ? 43 : ((Object)$autoTranslationEnabled).hashCode());
            Boolean $frozen = this.getFrozen();
            result = result * 59 + ($frozen == null ? 43 : ((Object)$frozen).hashCode());
            User.UserRequestObject $createdBy = this.getCreatedBy();
            result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
            String $team = this.getTeam();
            result = result * 59 + ($team == null ? 43 : $team.hashCode());
            Language $autoTranslationLanguage = this.getAutoTranslationLanguage();
            result = result * 59 + ($autoTranslationLanguage == null ? 43 : ((Object)((Object)$autoTranslationLanguage)).hashCode());
            List<ChannelMemberRequestObject> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            List<ChannelMemberRequestObject> $invites = this.getInvites();
            result = result * 59 + ($invites == null ? 43 : ((Object)$invites).hashCode());
            ConfigOverridesRequestObject $configOverrides = this.getConfigOverrides();
            result = result * 59 + ($configOverrides == null ? 43 : ((Object)$configOverrides).hashCode());
            List<String> $filterTags = this.getFilterTags();
            result = result * 59 + ($filterTags == null ? 43 : ((Object)$filterTags).hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public static class ChannelRequestObjectBuilder {
            private User.UserRequestObject createdBy;
            private String team;
            private Boolean autoTranslationEnabled;
            private Language autoTranslationLanguage;
            private Boolean frozen;
            private ArrayList<ChannelMemberRequestObject> members;
            private ArrayList<ChannelMemberRequestObject> invites;
            private ConfigOverridesRequestObject configOverrides;
            private ArrayList<String> filterTags;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            ChannelRequestObjectBuilder() {
            }

            @JsonProperty(value="created_by")
            public ChannelRequestObjectBuilder createdBy(@Nullable User.UserRequestObject createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="team")
            public ChannelRequestObjectBuilder team(@Nullable String team) {
                this.team = team;
                return this;
            }

            @JsonProperty(value="auto_translation_enabled")
            public ChannelRequestObjectBuilder autoTranslationEnabled(@Nullable Boolean autoTranslationEnabled) {
                this.autoTranslationEnabled = autoTranslationEnabled;
                return this;
            }

            @JsonProperty(value="auto_translation_language")
            public ChannelRequestObjectBuilder autoTranslationLanguage(@Nullable Language autoTranslationLanguage) {
                this.autoTranslationLanguage = autoTranslationLanguage;
                return this;
            }

            @JsonProperty(value="frozen")
            public ChannelRequestObjectBuilder frozen(@Nullable Boolean frozen) {
                this.frozen = frozen;
                return this;
            }

            public ChannelRequestObjectBuilder member(ChannelMemberRequestObject member) {
                if (this.members == null) {
                    this.members = new ArrayList();
                }
                this.members.add(member);
                return this;
            }

            @JsonProperty(value="members")
            public ChannelRequestObjectBuilder members(Collection<? extends ChannelMemberRequestObject> members) {
                if (members == null) {
                    throw new NullPointerException("members cannot be null");
                }
                if (this.members == null) {
                    this.members = new ArrayList();
                }
                this.members.addAll(members);
                return this;
            }

            public ChannelRequestObjectBuilder clearMembers() {
                if (this.members != null) {
                    this.members.clear();
                }
                return this;
            }

            public ChannelRequestObjectBuilder invite(ChannelMemberRequestObject invite) {
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.add(invite);
                return this;
            }

            @JsonProperty(value="invites")
            public ChannelRequestObjectBuilder invites(Collection<? extends ChannelMemberRequestObject> invites) {
                if (invites == null) {
                    throw new NullPointerException("invites cannot be null");
                }
                if (this.invites == null) {
                    this.invites = new ArrayList();
                }
                this.invites.addAll(invites);
                return this;
            }

            public ChannelRequestObjectBuilder clearInvites() {
                if (this.invites != null) {
                    this.invites.clear();
                }
                return this;
            }

            @JsonProperty(value="config_overrides")
            public ChannelRequestObjectBuilder configOverrides(@Nullable ConfigOverridesRequestObject configOverrides) {
                this.configOverrides = configOverrides;
                return this;
            }

            public ChannelRequestObjectBuilder filterTag(String filterTag) {
                if (this.filterTags == null) {
                    this.filterTags = new ArrayList();
                }
                this.filterTags.add(filterTag);
                return this;
            }

            @JsonProperty(value="filter_tags")
            public ChannelRequestObjectBuilder filterTags(Collection<? extends String> filterTags) {
                if (filterTags == null) {
                    throw new NullPointerException("filterTags cannot be null");
                }
                if (this.filterTags == null) {
                    this.filterTags = new ArrayList();
                }
                this.filterTags.addAll(filterTags);
                return this;
            }

            public ChannelRequestObjectBuilder clearFilterTags() {
                if (this.filterTags != null) {
                    this.filterTags.clear();
                }
                return this;
            }

            public ChannelRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public ChannelRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public ChannelRequestObject build() {
                Map<String, Object> additionalFields;
                List<String> filterTags;
                List<ChannelMemberRequestObject> invites;
                List<ChannelMemberRequestObject> members;
                switch (this.members == null ? 0 : this.members.size()) {
                    case 0: {
                        members = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        members = Collections.singletonList(this.members.get(0));
                        break;
                    }
                    default: {
                        members = Collections.unmodifiableList(new ArrayList<ChannelMemberRequestObject>(this.members));
                    }
                }
                switch (this.invites == null ? 0 : this.invites.size()) {
                    case 0: {
                        invites = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        invites = Collections.singletonList(this.invites.get(0));
                        break;
                    }
                    default: {
                        invites = Collections.unmodifiableList(new ArrayList<ChannelMemberRequestObject>(this.invites));
                    }
                }
                switch (this.filterTags == null ? 0 : this.filterTags.size()) {
                    case 0: {
                        filterTags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        filterTags = Collections.singletonList(this.filterTags.get(0));
                        break;
                    }
                    default: {
                        filterTags = Collections.unmodifiableList(new ArrayList<String>(this.filterTags));
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new ChannelRequestObject(this.createdBy, this.team, this.autoTranslationEnabled, this.autoTranslationLanguage, this.frozen, members, invites, this.configOverrides, filterTags, additionalFields);
            }

            public String toString() {
                return "Channel.ChannelRequestObject.ChannelRequestObjectBuilder(createdBy=" + String.valueOf(this.createdBy) + ", team=" + this.team + ", autoTranslationEnabled=" + this.autoTranslationEnabled + ", autoTranslationLanguage=" + String.valueOf((Object)this.autoTranslationLanguage) + ", frozen=" + this.frozen + ", members=" + String.valueOf(this.members) + ", invites=" + String.valueOf(this.invites) + ", configOverrides=" + String.valueOf(this.configOverrides) + ", filterTags=" + String.valueOf(this.filterTags) + ", additionalFields$key=" + String.valueOf(this.additionalFields$key) + ", additionalFields$value=" + String.valueOf(this.additionalFields$value) + ")";
            }
        }
    }

    public static class RoleAssignment {
        @JsonProperty(value="channel_role")
        @Nullable
        private String channelRole;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        @Nullable
        public String getChannelRole() {
            return this.channelRole;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @JsonProperty(value="channel_role")
        public void setChannelRole(@Nullable String channelRole) {
            this.channelRole = channelRole;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleAssignment)) {
                return false;
            }
            RoleAssignment other = (RoleAssignment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelRole = this.getChannelRole();
            String other$channelRole = other.getChannelRole();
            if (this$channelRole == null ? other$channelRole != null : !this$channelRole.equals(other$channelRole)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoleAssignment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelRole = this.getChannelRole();
            result = result * 59 + ($channelRole == null ? 43 : $channelRole.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        public String toString() {
            return "Channel.RoleAssignment(channelRole=" + this.getChannelRole() + ", userId=" + this.getUserId() + ")";
        }
    }

    public static class ChannelMember {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="is_moderator")
        @Nullable
        private Boolean isModerator;
        @JsonProperty(value="invited")
        @Nullable
        private Boolean invited;
        @JsonProperty(value="invite_accepted_at")
        @Nullable
        private Date inviteAcceptedAt;
        @JsonProperty(value="invite_rejected_at")
        @Nullable
        private Date inviteRejectedAt;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="channel_role")
        @Nullable
        private String channelRole;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="ban_expires")
        @Nullable
        private String banExpires;
        @JsonProperty(value="shadow_banned")
        @Nullable
        private Boolean shadowBanned;
        @JsonProperty(value="notifications_muted")
        @Nullable
        private Boolean notificationsMuted;
        @JsonProperty(value="status")
        @Nullable
        private InviteStatus status;
        @JsonProperty(value="archived_at")
        @Nullable
        private Date archivedAt;
        @JsonProperty(value="pinned_at")
        @Nullable
        private Date pinnedAt;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Boolean getIsModerator() {
            return this.isModerator;
        }

        @Nullable
        public Boolean getInvited() {
            return this.invited;
        }

        @Nullable
        public Date getInviteAcceptedAt() {
            return this.inviteAcceptedAt;
        }

        @Nullable
        public Date getInviteRejectedAt() {
            return this.inviteRejectedAt;
        }

        @Nullable
        public String getRole() {
            return this.role;
        }

        @Nullable
        public String getChannelRole() {
            return this.channelRole;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public Boolean getBanned() {
            return this.banned;
        }

        @Nullable
        public String getBanExpires() {
            return this.banExpires;
        }

        @Nullable
        public Boolean getShadowBanned() {
            return this.shadowBanned;
        }

        @Nullable
        public Boolean getNotificationsMuted() {
            return this.notificationsMuted;
        }

        @Nullable
        public InviteStatus getStatus() {
            return this.status;
        }

        @Nullable
        public Date getArchivedAt() {
            return this.archivedAt;
        }

        @Nullable
        public Date getPinnedAt() {
            return this.pinnedAt;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="is_moderator")
        public void setIsModerator(@Nullable Boolean isModerator) {
            this.isModerator = isModerator;
        }

        @JsonProperty(value="invited")
        public void setInvited(@Nullable Boolean invited) {
            this.invited = invited;
        }

        @JsonProperty(value="invite_accepted_at")
        public void setInviteAcceptedAt(@Nullable Date inviteAcceptedAt) {
            this.inviteAcceptedAt = inviteAcceptedAt;
        }

        @JsonProperty(value="invite_rejected_at")
        public void setInviteRejectedAt(@Nullable Date inviteRejectedAt) {
            this.inviteRejectedAt = inviteRejectedAt;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="channel_role")
        public void setChannelRole(@Nullable String channelRole) {
            this.channelRole = channelRole;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="ban_expires")
        public void setBanExpires(@Nullable String banExpires) {
            this.banExpires = banExpires;
        }

        @JsonProperty(value="shadow_banned")
        public void setShadowBanned(@Nullable Boolean shadowBanned) {
            this.shadowBanned = shadowBanned;
        }

        @JsonProperty(value="notifications_muted")
        public void setNotificationsMuted(@Nullable Boolean notificationsMuted) {
            this.notificationsMuted = notificationsMuted;
        }

        @JsonProperty(value="status")
        public void setStatus(@Nullable InviteStatus status) {
            this.status = status;
        }

        @JsonProperty(value="archived_at")
        public void setArchivedAt(@Nullable Date archivedAt) {
            this.archivedAt = archivedAt;
        }

        @JsonProperty(value="pinned_at")
        public void setPinnedAt(@Nullable Date pinnedAt) {
            this.pinnedAt = pinnedAt;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMember)) {
                return false;
            }
            ChannelMember other = (ChannelMember)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isModerator = this.getIsModerator();
            Boolean other$isModerator = other.getIsModerator();
            if (this$isModerator == null ? other$isModerator != null : !((Object)this$isModerator).equals(other$isModerator)) {
                return false;
            }
            Boolean this$invited = this.getInvited();
            Boolean other$invited = other.getInvited();
            if (this$invited == null ? other$invited != null : !((Object)this$invited).equals(other$invited)) {
                return false;
            }
            Boolean this$banned = this.getBanned();
            Boolean other$banned = other.getBanned();
            if (this$banned == null ? other$banned != null : !((Object)this$banned).equals(other$banned)) {
                return false;
            }
            Boolean this$shadowBanned = this.getShadowBanned();
            Boolean other$shadowBanned = other.getShadowBanned();
            if (this$shadowBanned == null ? other$shadowBanned != null : !((Object)this$shadowBanned).equals(other$shadowBanned)) {
                return false;
            }
            Boolean this$notificationsMuted = this.getNotificationsMuted();
            Boolean other$notificationsMuted = other.getNotificationsMuted();
            if (this$notificationsMuted == null ? other$notificationsMuted != null : !((Object)this$notificationsMuted).equals(other$notificationsMuted)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$inviteAcceptedAt = this.getInviteAcceptedAt();
            Date other$inviteAcceptedAt = other.getInviteAcceptedAt();
            if (this$inviteAcceptedAt == null ? other$inviteAcceptedAt != null : !((Object)this$inviteAcceptedAt).equals(other$inviteAcceptedAt)) {
                return false;
            }
            Date this$inviteRejectedAt = this.getInviteRejectedAt();
            Date other$inviteRejectedAt = other.getInviteRejectedAt();
            if (this$inviteRejectedAt == null ? other$inviteRejectedAt != null : !((Object)this$inviteRejectedAt).equals(other$inviteRejectedAt)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$channelRole = this.getChannelRole();
            String other$channelRole = other.getChannelRole();
            if (this$channelRole == null ? other$channelRole != null : !this$channelRole.equals(other$channelRole)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            String this$banExpires = this.getBanExpires();
            String other$banExpires = other.getBanExpires();
            if (this$banExpires == null ? other$banExpires != null : !this$banExpires.equals(other$banExpires)) {
                return false;
            }
            InviteStatus this$status = this.getStatus();
            InviteStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            Date this$archivedAt = this.getArchivedAt();
            Date other$archivedAt = other.getArchivedAt();
            if (this$archivedAt == null ? other$archivedAt != null : !((Object)this$archivedAt).equals(other$archivedAt)) {
                return false;
            }
            Date this$pinnedAt = this.getPinnedAt();
            Date other$pinnedAt = other.getPinnedAt();
            if (this$pinnedAt == null ? other$pinnedAt != null : !((Object)this$pinnedAt).equals(other$pinnedAt)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMember;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isModerator = this.getIsModerator();
            result = result * 59 + ($isModerator == null ? 43 : ((Object)$isModerator).hashCode());
            Boolean $invited = this.getInvited();
            result = result * 59 + ($invited == null ? 43 : ((Object)$invited).hashCode());
            Boolean $banned = this.getBanned();
            result = result * 59 + ($banned == null ? 43 : ((Object)$banned).hashCode());
            Boolean $shadowBanned = this.getShadowBanned();
            result = result * 59 + ($shadowBanned == null ? 43 : ((Object)$shadowBanned).hashCode());
            Boolean $notificationsMuted = this.getNotificationsMuted();
            result = result * 59 + ($notificationsMuted == null ? 43 : ((Object)$notificationsMuted).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $inviteAcceptedAt = this.getInviteAcceptedAt();
            result = result * 59 + ($inviteAcceptedAt == null ? 43 : ((Object)$inviteAcceptedAt).hashCode());
            Date $inviteRejectedAt = this.getInviteRejectedAt();
            result = result * 59 + ($inviteRejectedAt == null ? 43 : ((Object)$inviteRejectedAt).hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $channelRole = this.getChannelRole();
            result = result * 59 + ($channelRole == null ? 43 : $channelRole.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            String $banExpires = this.getBanExpires();
            result = result * 59 + ($banExpires == null ? 43 : $banExpires.hashCode());
            InviteStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            Date $archivedAt = this.getArchivedAt();
            result = result * 59 + ($archivedAt == null ? 43 : ((Object)$archivedAt).hashCode());
            Date $pinnedAt = this.getPinnedAt();
            result = result * 59 + ($pinnedAt == null ? 43 : ((Object)$pinnedAt).hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public String toString() {
            return "Channel.ChannelMember(userId=" + this.getUserId() + ", user=" + String.valueOf(this.getUser()) + ", isModerator=" + this.getIsModerator() + ", invited=" + this.getInvited() + ", inviteAcceptedAt=" + String.valueOf(this.getInviteAcceptedAt()) + ", inviteRejectedAt=" + String.valueOf(this.getInviteRejectedAt()) + ", role=" + this.getRole() + ", channelRole=" + this.getChannelRole() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", banned=" + this.getBanned() + ", banExpires=" + this.getBanExpires() + ", shadowBanned=" + this.getShadowBanned() + ", notificationsMuted=" + this.getNotificationsMuted() + ", status=" + String.valueOf((Object)this.getStatus()) + ", archivedAt=" + String.valueOf(this.getArchivedAt()) + ", pinnedAt=" + String.valueOf(this.getPinnedAt()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ")";
        }

        public static enum InviteStatus {
            PENDING,
            MEMBER,
            REJECTED,
            ACCEPTED,
            UNKNOWN;

        }
    }

    public static class ChannelRead {
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="last_read")
        @Nullable
        private Date lastRead;
        @JsonProperty(value="unread_messages")
        @Nullable
        private Integer unreadMessages;

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Date getLastRead() {
            return this.lastRead;
        }

        @Nullable
        public Integer getUnreadMessages() {
            return this.unreadMessages;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="last_read")
        public void setLastRead(@Nullable Date lastRead) {
            this.lastRead = lastRead;
        }

        @JsonProperty(value="unread_messages")
        public void setUnreadMessages(@Nullable Integer unreadMessages) {
            this.unreadMessages = unreadMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelRead)) {
                return false;
            }
            ChannelRead other = (ChannelRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$unreadMessages = this.getUnreadMessages();
            Integer other$unreadMessages = other.getUnreadMessages();
            if (this$unreadMessages == null ? other$unreadMessages != null : !((Object)this$unreadMessages).equals(other$unreadMessages)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$lastRead = this.getLastRead();
            Date other$lastRead = other.getLastRead();
            return !(this$lastRead == null ? other$lastRead != null : !((Object)this$lastRead).equals(other$lastRead));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelRead;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $unreadMessages = this.getUnreadMessages();
            result = result * 59 + ($unreadMessages == null ? 43 : ((Object)$unreadMessages).hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $lastRead = this.getLastRead();
            result = result * 59 + ($lastRead == null ? 43 : ((Object)$lastRead).hashCode());
            return result;
        }

        public String toString() {
            return "Channel.ChannelRead(user=" + String.valueOf(this.getUser()) + ", lastRead=" + String.valueOf(this.getLastRead()) + ", unreadMessages=" + this.getUnreadMessages() + ")";
        }
    }
}

