/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.core.controller.inject.closed.ConstantConcurrentUsersInjection;
import io.gatling.core.controller.inject.closed.RampConcurrentUsersInjection;
import io.gatling.core.controller.inject.closed.StairsConcurrentUsersCompositeStep;
import io.gatling.javaapi.core.internal.ClosedInjectionSteps;
import io.gatling.javaapi.core.internal.Converters;
import java.time.Duration;
import javax.annotation.Nonnull;

public class ClosedInjectionStep {
    private final io.gatling.core.controller.inject.closed.ClosedInjectionStep wrapped;

    private ClosedInjectionStep(@Nonnull io.gatling.core.controller.inject.closed.ClosedInjectionStep closedInjectionStep) {
        this.wrapped = closedInjectionStep;
    }

    @Nonnull
    public io.gatling.core.controller.inject.closed.ClosedInjectionStep asScala() {
        return this.wrapped;
    }

    public static final class Composite
    extends ClosedInjectionStep {
        Composite(io.gatling.core.controller.inject.closed.ClosedInjectionStep closedInjectionStep) {
            super(closedInjectionStep);
        }

        private StairsConcurrentUsersCompositeStep wrapped() {
            return (StairsConcurrentUsersCompositeStep)this.asScala();
        }

        @Nonnull
        public Composite startingFrom(int n) {
            return new Composite((io.gatling.core.controller.inject.closed.ClosedInjectionStep)this.wrapped().startingFrom(n));
        }

        @Nonnull
        public Composite separatedByRampsLasting(long l) {
            return this.separatedByRampsLasting(Duration.ofSeconds(l));
        }

        @Nonnull
        public Composite separatedByRampsLasting(Duration duration) {
            return new Composite((io.gatling.core.controller.inject.closed.ClosedInjectionStep)this.wrapped().separatedByRampsLasting(Converters.toScalaDuration(duration)));
        }
    }

    public static final class StairsWithTime {
        private final int usersIncrement;
        private final int levels;

        public StairsWithTime(int n, int n2) {
            this.usersIncrement = n;
            this.levels = n2;
        }

        @Nonnull
        public Composite eachLevelLasting(long l) {
            return this.eachLevelLasting(Duration.ofSeconds(l));
        }

        @Nonnull
        public Composite eachLevelLasting(@Nonnull Duration duration) {
            return new Composite((io.gatling.core.controller.inject.closed.ClosedInjectionStep)ClosedInjectionSteps.newEachLevelLasting(this.usersIncrement, this.levels).eachLevelLasting(Converters.toScalaDuration(duration)));
        }
    }

    public static final class Stairs {
        private final int usersIncrement;

        Stairs(int n) {
            this.usersIncrement = n;
        }

        @Nonnull
        public StairsWithTime times(int n) {
            return new StairsWithTime(this.usersIncrement, n);
        }
    }

    public static final class RampTo {
        private final int from;
        private final int to;

        public RampTo(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        @Nonnull
        public ClosedInjectionStep during(long l) {
            return this.during(Duration.ofSeconds(l));
        }

        @Nonnull
        public ClosedInjectionStep during(@Nonnull Duration duration) {
            return new ClosedInjectionStep((io.gatling.core.controller.inject.closed.ClosedInjectionStep)new RampConcurrentUsersInjection(this.from, this.to, Converters.toScalaDuration(duration)));
        }
    }

    public static final class Ramp {
        private final int from;

        public Ramp(int n) {
            this.from = n;
        }

        @Nonnull
        public RampTo to(int n) {
            return new RampTo(this.from, n);
        }
    }

    public static final class Constant {
        private final int users;

        Constant(int n) {
            this.users = n;
        }

        @Nonnull
        public ClosedInjectionStep during(long l) {
            return this.during(Duration.ofSeconds(l));
        }

        @Nonnull
        public ClosedInjectionStep during(@Nonnull Duration duration) {
            return new ClosedInjectionStep((io.gatling.core.controller.inject.closed.ClosedInjectionStep)new ConstantConcurrentUsersInjection(this.users, Converters.toScalaDuration(duration)));
        }
    }
}

