/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.pem;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.DerValue;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.jwt.domain.KeyType;
import io.fusionauth.pem.PEMDecoderException;
import io.fusionauth.pem.domain.PEM;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;

public class PEMDecoder {
    private static final byte[] EC_ENCRYPTION_OID = new byte[]{42, -122, 72, -50, 61, 2, 1};

    public PEM decode(Path path) {
        Objects.requireNonNull(path);
        try {
            return this.decode(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new PEMDecoderException("Unable to read the file from path [" + path.toAbsolutePath().toString() + "]", e);
        }
    }

    public PEM decode(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return this.decode(new String(bytes));
    }

    public PEM decode(String encodedKey) {
        Objects.requireNonNull(encodedKey);
        try {
            if (encodedKey.contains("-----BEGIN RSA PUBLIC KEY-----")) {
                return this.decode_PKCS_1_Public(encodedKey);
            }
            if (encodedKey.contains("-----BEGIN PUBLIC KEY-----")) {
                return this.decode_X_509(encodedKey);
            }
            if (encodedKey.contains("-----BEGIN CERTIFICATE-----")) {
                return new PEM(CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(this.getKeyBytes(encodedKey, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"))));
            }
            if (encodedKey.contains("-----BEGIN RSA PRIVATE KEY-----")) {
                return this.decode_PKCS_1_Private(encodedKey);
            }
            if (encodedKey.contains("-----BEGIN PRIVATE KEY-----")) {
                return this.decode_PKCS_8(encodedKey);
            }
            if (encodedKey.contains("-----END EC PRIVATE KEY-----")) {
                return this.decode_EC_privateKey(encodedKey);
            }
            throw new PEMDecoderException(new InvalidParameterException("Unexpected PEM Format"));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new PEMDecoderException(e);
        }
    }

    private PEM decode_EC_privateKey(String encodedKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] bytes = this.getKeyBytes(encodedKey, "-----BEGIN EC PRIVATE KEY-----", "-----END EC PRIVATE KEY-----");
        DerValue[] sequence = new DerInputStream(bytes).getSequence();
        BigInteger version = sequence[0].getBigInteger();
        if (!version.equals(BigInteger.valueOf(1L))) {
            throw new PEMDecoderException("Expected version [1] but found version of [" + version + "]");
        }
        if (sequence.length == 2) {
            throw new PEMDecoderException("Unable to decode the provided PEM, the EC private key does not contain the curve identifier necessary to convert to a PKCS#8 format before building a private key");
        }
        ObjectIdentifier curveOID = sequence[2].getOID();
        DerOutputStream pkcs_8 = new DerOutputStream().writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(BigInteger.valueOf(0L))).writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(6, EC_ENCRYPTION_OID)).writeValue(new DerValue(6, curveOID.value)))).writeValue(new DerValue(4, bytes))));
        ECPrivateKey privateKey = (ECPrivateKey)KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(pkcs_8.toByteArray()));
        DerValue bitString = new DerInputStream(sequence[3]).readDerValue();
        PublicKey publicKey = this.getPublicKeyFromPrivateEC(bitString, privateKey);
        return new PEM(privateKey, publicKey);
    }

    private PEM decode_PKCS_1_Private(String encodedKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] bytes = this.getKeyBytes(encodedKey, "-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");
        DerValue[] sequence = new DerInputStream(bytes).getSequence();
        if (sequence.length < 9) {
            throw new PEMDecoderException(new InvalidKeyException("Could not build a PKCS#1 private key. Expected at least 9 values in the DER encoded sequence."));
        }
        BigInteger n = sequence[1].getBigInteger();
        BigInteger e = sequence[2].getBigInteger();
        BigInteger d = sequence[3].getBigInteger();
        BigInteger p = sequence[4].getBigInteger();
        BigInteger q = sequence[5].getBigInteger();
        BigInteger d_mod_p1 = sequence[6].getBigInteger();
        BigInteger d_mod_q1 = sequence[7].getBigInteger();
        BigInteger mod_p = sequence[8].getBigInteger();
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new RSAPrivateCrtKeySpec(n, e, d, p, q, d_mod_p1, d_mod_q1, mod_p));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(n, e));
        return new PEM(privateKey, publicKey);
    }

    private PEM decode_PKCS_1_Public(String encodedKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        byte[] bytes = this.getKeyBytes(encodedKey, "-----BEGIN RSA PUBLIC KEY-----", "-----END RSA PUBLIC KEY-----");
        DerValue[] sequence = new DerInputStream(bytes).getSequence();
        if (sequence.length != 2 || !sequence[0].tag.is(2) || !sequence[1].tag.is(2)) {
            throw new InvalidKeyException("Could not build this PKCS#1 public key. Expecting values in the DER encoded sequence in the following format [ Integer | Integer ]");
        }
        BigInteger modulus = sequence[0].getBigInteger();
        BigInteger publicExponent = sequence[1].getBigInteger();
        return new PEM(KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent)));
    }

    private PEM decode_PKCS_8(String encodedKey) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, InvalidKeyException {
        byte[] bytes = this.getKeyBytes(encodedKey, "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
        DerValue[] sequence = new DerInputStream(bytes).getSequence();
        if (!(sequence.length == 3 && sequence[0].tag.is(2) && sequence[1].tag.is(48) && sequence[2].tag.is(4))) {
            throw new InvalidKeyException("Could not decode the private key. Expecting values in the DER encoded sequence in the following format [ Integer | Sequence | OctetString ]");
        }
        ObjectIdentifier algorithmOID = new DerInputStream(sequence[1].toByteArray()).getOID();
        KeyType type = KeyType.getKeyTypeFromOid(algorithmOID.decode());
        if (type == null) {
            throw new InvalidKeyException("Could not decode the private key. Expected an EC or RSA key type but found OID [" + algorithmOID.decode() + "] and was unable to match that to a supported algorithm.");
        }
        PrivateKey privateKey = KeyFactory.getInstance(type.name()).generatePrivate(new PKCS8EncodedKeySpec(bytes));
        if (privateKey instanceof ECPrivateKey) {
            DerValue[] privateKeySequence = new DerInputStream(sequence[2]).getSequence();
            if (privateKeySequence.length == 3 && privateKeySequence[2].tag.rawByte == -95) {
                DerValue bitString = new DerInputStream(privateKeySequence[2]).readDerValue();
                PublicKey publicKey = this.getPublicKeyFromPrivateEC(bitString, (ECPrivateKey)privateKey);
                return new PEM(privateKey, publicKey);
            }
            return new PEM(privateKey);
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            BigInteger modulus = ((RSAPrivateCrtKey)privateKey).getModulus();
            BigInteger publicExponent = ((RSAPrivateCrtKey)privateKey).getPublicExponent();
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
            return new PEM(privateKey, publicKey);
        }
        return new PEM(privateKey);
    }

    private PEM decode_X_509(String encodedKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        byte[] bytes = this.getKeyBytes(encodedKey, "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
        DerValue[] sequence = new DerInputStream(bytes).getSequence();
        if (sequence.length != 2 || !sequence[0].tag.is(48) || !sequence[1].tag.is(3)) {
            throw new InvalidKeyException("Could not decode the X.509 public key. Expected values in the DER encoded sequence in the following format [ Sequence | BitString ]");
        }
        DerInputStream der = new DerInputStream(sequence[0].toByteArray());
        ObjectIdentifier algorithmOID = der.getOID();
        KeyType type = KeyType.getKeyTypeFromOid(algorithmOID.decode());
        if (type == null) {
            throw new InvalidKeyException("Could not decode the X.509 public key. Expected at 2 values in the DER encoded sequence but found [" + sequence.length + "]");
        }
        return new PEM(KeyFactory.getInstance(type.name()).generatePublic(new X509EncodedKeySpec(bytes)));
    }

    private byte[] getKeyBytes(String key, String keyPrefix, String keySuffix) {
        int startIndex = key.indexOf(keyPrefix);
        int endIndex = key.indexOf(keySuffix);
        String base64 = key.substring(startIndex + keyPrefix.length(), endIndex).replaceAll("\\s+", "");
        return Base64.getDecoder().decode(base64);
    }

    private PublicKey getPublicKeyFromPrivateEC(DerValue bitString, ECPrivateKey privateKey) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        DerValue[] sequence = new DerInputStream(privateKey.getEncoded()).getSequence();
        byte[] encodedPublicKey = new DerOutputStream().writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(48, sequence[1].toByteArray())).writeValue(new DerValue(3, bitString.toByteArray())))).toByteArray();
        return KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(encodedPublicKey));
    }
}

