/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fusionauth.domain.Buildable;
import io.fusionauth.jwks.JSONWebKeyBuilder;
import io.fusionauth.jwks.JSONWebKeyBuilderException;
import io.fusionauth.jwks.JSONWebKeyParser;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.KeyType;
import io.fusionauth.jwt.json.Mapper;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JSONWebKey
implements Buildable<JSONWebKey> {
    public Algorithm alg;
    public String crv;
    public String d;
    public String dp;
    public String dq;
    public String e;
    public String kid;
    public KeyType kty;
    public String n;
    @JsonAnySetter
    public Map<String, Object> other = new LinkedHashMap<String, Object>();
    public String p;
    public String q;
    public String qi;
    public String use;
    public String x;
    public List<String> x5c;
    public String x5t;
    @JsonProperty(value="x5t#S256")
    public String x5t_256;
    public String y;

    public static JSONWebKey build(String encodedPEM) {
        return new JSONWebKeyBuilder().build(encodedPEM);
    }

    public static PublicKey parse(JSONWebKey key) {
        return new JSONWebKeyParser().parse(key);
    }

    public static JSONWebKey build(Certificate certificate) {
        return new JSONWebKeyBuilder().build(certificate);
    }

    public static JSONWebKey build(PrivateKey privateKey) {
        return new JSONWebKeyBuilder().build(privateKey);
    }

    public static JSONWebKey build(PublicKey publicKey) {
        return new JSONWebKeyBuilder().build(publicKey);
    }

    @JsonIgnore
    public JSONWebKey add(String key, Object value) {
        if (key == null || value == null) {
            return this;
        }
        switch (key) {
            case "alg": 
            case "crv": 
            case "d": 
            case "dp": 
            case "dq": 
            case "e": 
            case "kid": 
            case "kty": 
            case "n": 
            case "p": 
            case "q": 
            case "qi": 
            case "use": 
            case "x": 
            case "x5c": 
            case "x5t": 
            case "x5t_256": 
            case "y": {
                throw new JSONWebKeyBuilderException("You can not add a named property. Use the field for [" + key + "] instead.", new IllegalArgumentException());
            }
        }
        this.other.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSONWebKey)) {
            return false;
        }
        JSONWebKey that = (JSONWebKey)o;
        return this.alg == that.alg && Objects.equals(this.crv, that.crv) && Objects.equals(this.d, that.d) && Objects.equals(this.dp, that.dp) && Objects.equals(this.dq, that.dq) && Objects.equals(this.e, that.e) && Objects.equals(this.kid, that.kid) && this.kty == that.kty && Objects.equals(this.n, that.n) && Objects.equals(this.p, that.p) && Objects.equals(this.q, that.q) && Objects.equals(this.qi, that.qi) && Objects.equals(this.use, that.use) && Objects.equals(this.x, that.x) && Objects.equals(this.x5c, that.x5c) && Objects.equals(this.x5t, that.x5t) && Objects.equals(this.x5t_256, that.x5t_256) && Objects.equals(this.y, that.y);
    }

    @JsonAnyGetter
    public Map<String, Object> getOther() {
        return this.other;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alg, this.crv, this.d, this.dp, this.dq, this.e, this.kid, this.kty, this.n, this.p, this.q, this.qi, this.use, this.x, this.x5c, this.x5t, this.x5t_256, this.y});
    }

    public String toJSON() {
        return new String(Mapper.serialize(this));
    }

    public String toString() {
        return new String(Mapper.prettyPrint(this));
    }
}

