/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks;

import io.fusionauth.jwks.JSONWebKeyBuilderException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Base64;

public class JWKUtils {
    public static BigInteger base64DecodeUint(String encoded) {
        byte[] bytes = Base64.getUrlDecoder().decode(encoded);
        if (bytes.length % 8 == 0 && bytes[0] != 0) {
            byte[] copy = new byte[bytes.length + 1];
            copy[0] = 0;
            System.arraycopy(bytes, 0, copy, 1, bytes.length);
            return new BigInteger(copy);
        }
        return new BigInteger(bytes);
    }

    public static String base64EncodeUint(BigInteger value) {
        return JWKUtils.base64EncodeUint(value, -1);
    }

    public static String base64EncodeUint(BigInteger value, int minimumLength) {
        if (value.signum() < 0) {
            throw new JSONWebKeyBuilderException("Illegal parameter, cannot encode a negative number.", new IllegalArgumentException());
        }
        byte[] bytes = value.toByteArray();
        if (value.bitLength() % 8 == 0 && bytes[0] == 0 && bytes.length > 1) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (minimumLength != -1 && bytes.length < minimumLength) {
            byte[] buf = new byte[minimumLength];
            System.arraycopy(bytes, 0, buf, minimumLength - bytes.length, bytes.length);
            bytes = buf;
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

