/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks;

import com.fasterxml.jackson.databind.JsonNode;
import io.fusionauth.http.AbstractHttpHelper;
import io.fusionauth.jwks.JSONWebKeyBuilderException;
import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.json.Mapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class JSONWebKeySetHelper
extends AbstractHttpHelper {
    public static List<JSONWebKey> retrieveKeysFromIssuer(String issuer) {
        return JSONWebKeySetHelper.retrieveKeysFromIssuer(issuer, null);
    }

    public static List<JSONWebKey> retrieveKeysFromIssuer(String issuer, Consumer<HttpURLConnection> consumer) {
        Objects.requireNonNull(issuer);
        if (issuer.endsWith("/")) {
            issuer = issuer.substring(0, issuer.length() - 1);
        }
        return JSONWebKeySetHelper.retrieveKeysFromWellKnownConfiguration(issuer + "/.well-known/openid-configuration", consumer);
    }

    public static List<JSONWebKey> retrieveKeysFromWellKnownConfiguration(HttpURLConnection httpURLConnection) {
        return JSONWebKeySetHelper.get(httpURLConnection, is -> {
            JsonNode response = Mapper.deserialize(is, JsonNode.class);
            JsonNode jwksURI = response.at("/jwks_uri");
            if (jwksURI.isMissingNode()) {
                String endpoint = httpURLConnection.getURL().toString();
                throw new JSONWebKeySetException("The well-known endpoint [" + endpoint + "] has not defined a JSON Web Key Set endpoint. Missing the [jwks_uri] property.");
            }
            return JSONWebKeySetHelper.retrieveKeysFromJWKS(jwksURI.asText());
        }, JSONWebKeyBuilderException::new);
    }

    public static List<JSONWebKey> retrieveKeysFromWellKnownConfiguration(String endpoint) {
        return JSONWebKeySetHelper.retrieveKeysFromWellKnownConfiguration(endpoint, null);
    }

    public static List<JSONWebKey> retrieveKeysFromWellKnownConfiguration(String endpoint, Consumer<HttpURLConnection> consumer) {
        HttpURLConnection connection = JSONWebKeySetHelper.buildURLConnection(endpoint);
        if (consumer != null) {
            consumer.accept(connection);
        }
        return JSONWebKeySetHelper.retrieveKeysFromWellKnownConfiguration(connection);
    }

    public static List<JSONWebKey> retrieveKeysFromJWKS(String endpoint) {
        return JSONWebKeySetHelper.retrieveKeysFromJWKS(endpoint, null);
    }

    public static List<JSONWebKey> retrieveKeysFromJWKS(String endpoint, Consumer<HttpURLConnection> consumer) {
        HttpURLConnection connection = JSONWebKeySetHelper.buildURLConnection(endpoint);
        if (consumer != null) {
            consumer.accept(connection);
        }
        return JSONWebKeySetHelper.retrieveKeysFromJWKS(connection);
    }

    public static List<JSONWebKey> retrieveKeysFromJWKS(HttpURLConnection httpURLConnection) {
        return JSONWebKeySetHelper.get(httpURLConnection, is -> Mapper.deserialize((InputStream)is, JSONWebKeySetResponse.class).keys, JSONWebKeyBuilderException::new);
    }

    public static class JSONWebKeySetResponse {
        public List<JSONWebKey> keys;
    }

    public static class JSONWebKeySetException
    extends RuntimeException {
        public JSONWebKeySetException(String message) {
            super(message);
        }

        public JSONWebKeySetException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

