/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerDecodingException;
import io.fusionauth.der.DerValue;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.der.Tag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class DerInputStream {
    public ByteArrayInputStream data;
    public int length;

    public DerInputStream(DerValue dervalue) {
        this(dervalue.toByteArray());
    }

    public DerInputStream(byte[] bytes) {
        this.data = new ByteArrayInputStream(bytes);
        this.length = bytes.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DerInputStream)) {
            return false;
        }
        DerInputStream that = (DerInputStream)o;
        return this.length == that.length && Arrays.equals(this.toByteArray(), that.toByteArray());
    }

    public ObjectIdentifier getOID() throws DerDecodingException {
        int tag = this.data.read();
        if (tag != 6) {
            throw new DerDecodingException("Expected to find an Object Identifier tag 6 (" + Tag.hexString(6) + ") but found " + tag + " (" + Tag.hexString(tag) + ")");
        }
        int length = this.readLength();
        if (length > this.data.available()) {
            throw new DerDecodingException("A DER encoded value indicates it is [" + length + "] bytes long, but only [" + this.data.available() + "] are available to read in the input stream length. Unable to read the Object Identifier from the stream.");
        }
        byte[] buf = new byte[length];
        this.data.read(buf, 0, length);
        return new ObjectIdentifier(buf);
    }

    public DerValue[] getSequence() throws DerDecodingException {
        int tag = this.data.read();
        if (tag != 48) {
            throw new DerDecodingException("Expected to find a sequence tag 48 (" + Tag.hexString(48) + ") but found " + tag + " (" + Tag.hexString(tag) + ")");
        }
        int length = this.readLength();
        byte[] sequence = this.copyBytes(length);
        return this.getValuesFromBytes(sequence);
    }

    public int hashCode() {
        return Objects.hash(this.toByteArray(), this.length);
    }

    public DerValue readDerValue() throws DerDecodingException {
        int tag = this.data.read();
        int length = this.readLength();
        byte[] bytes = this.copyBytes(length);
        return new DerValue(tag, bytes);
    }

    public byte[] toByteArray() {
        try {
            byte[] buffer = new byte[this.length];
            this.data.reset();
            int actualLength = this.data.read(buffer);
            if (actualLength != this.length) {
                throw new IOException("Failed to read the entire byte array. Expected to read " + this.length + " bytes, but only read " + actualLength + ".");
            }
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] copyBytes(int l) {
        byte[] seq = new byte[l];
        for (int i = 0; i < l; ++i) {
            seq[i] = (byte)this.data.read();
        }
        return seq;
    }

    private DerValue[] getValuesFromBytes(byte[] bytes) throws DerDecodingException {
        ArrayList<DerValue> result = new ArrayList<DerValue>();
        int index = 0;
        while (index < bytes.length) {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes, index, bytes.length);
            int avail = stream.available();
            Tag tag = new Tag(stream.read());
            int length = this.readLength(stream);
            int adjustment = Math.abs(stream.available() - avail);
            byte[] buf = new byte[length];
            for (int i = 0; i < length; ++i) {
                buf[i] = (byte)stream.read();
            }
            result.add(new DerValue(tag, buf));
            index = index + length + adjustment;
        }
        return result.toArray(new DerValue[0]);
    }

    private int readLength(InputStream inputStream) throws DerDecodingException {
        try {
            int b = inputStream.read();
            if (b == -1) {
                throw new IOException("Invalid DER encoding, unable to read length of -1.");
            }
            int length = b;
            int remaining = length & 0x80;
            if (remaining == 0) {
                return length;
            }
            remaining = length & 0x7F;
            if (remaining == 0) {
                return -1;
            }
            if (remaining < 0) {
                throw new IOException("Invalid DER encoding.");
            }
            if (remaining > 4) {
                throw new IOException("Invalid DER encoding, the value is too big.");
            }
            length = inputStream.read() & 0xFF;
            --remaining;
            if (length == 0) {
                throw new IOException("Redundant length bytes found");
            }
            while (remaining > 0) {
                --remaining;
                length <<= 8;
                length += inputStream.read() & 0xFF;
            }
            if (length < 0) {
                throw new IOException("Invalid length bytes");
            }
            if (length <= 127) {
                throw new IOException("Should use short form for length");
            }
            return length;
        }
        catch (IOException e) {
            throw new DerDecodingException(e);
        }
    }

    private int readLength() throws DerDecodingException {
        return this.readLength(this.data);
    }
}

