/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.oauth2.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.fusionauth.jwt.json.Mapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthorizationServerMetaData {
    public String authorization_endpoint;
    public List<String> code_challenge_methods_supported;
    public List<String> grant_types_supported;
    public String introspection_endpoint;
    public List<String> introspection_endpoint_auth_methods_supported;
    public List<String> introspection_endpoint_auth_signing_alg_values_supported;
    public String issuer;
    public String jwks_uri;
    public String op_policy_uri;
    public String op_tos_uri;
    @JsonAnySetter
    public Map<String, Object> otherClaims = new LinkedHashMap<String, Object>();
    public String registration_endpoint;
    public List<String> response_modes_supported;
    public List<String> response_types_supported;
    public String revocation_endpoint;
    public List<String> revocation_endpoint_auth_methods_supported;
    public List<String> revocation_endpoint_auth_signing_alg_values_supported;
    public List<String> scopes_supported;
    public String service_documentation;
    public String token_endpoint;
    public List<String> token_endpoint_auth_methods_supported;
    public List<String> token_endpoint_auth_signing_alg_values_supported;
    public List<String> ui_locales_supported;

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    public String toString() {
        return new String(Mapper.prettyPrint(this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServerMetaData metaData = (AuthorizationServerMetaData)o;
        return Objects.equals(this.authorization_endpoint, metaData.authorization_endpoint) && Objects.equals(this.code_challenge_methods_supported, metaData.code_challenge_methods_supported) && Objects.equals(this.grant_types_supported, metaData.grant_types_supported) && Objects.equals(this.introspection_endpoint, metaData.introspection_endpoint) && Objects.equals(this.introspection_endpoint_auth_methods_supported, metaData.introspection_endpoint_auth_methods_supported) && Objects.equals(this.introspection_endpoint_auth_signing_alg_values_supported, metaData.introspection_endpoint_auth_signing_alg_values_supported) && Objects.equals(this.issuer, metaData.issuer) && Objects.equals(this.jwks_uri, metaData.jwks_uri) && Objects.equals(this.op_policy_uri, metaData.op_policy_uri) && Objects.equals(this.op_tos_uri, metaData.op_tos_uri) && Objects.equals(this.otherClaims, metaData.otherClaims) && Objects.equals(this.registration_endpoint, metaData.registration_endpoint) && Objects.equals(this.response_modes_supported, metaData.response_modes_supported) && Objects.equals(this.response_types_supported, metaData.response_types_supported) && Objects.equals(this.revocation_endpoint, metaData.revocation_endpoint) && Objects.equals(this.revocation_endpoint_auth_methods_supported, metaData.revocation_endpoint_auth_methods_supported) && Objects.equals(this.revocation_endpoint_auth_signing_alg_values_supported, metaData.revocation_endpoint_auth_signing_alg_values_supported) && Objects.equals(this.scopes_supported, metaData.scopes_supported) && Objects.equals(this.service_documentation, metaData.service_documentation) && Objects.equals(this.token_endpoint, metaData.token_endpoint) && Objects.equals(this.token_endpoint_auth_methods_supported, metaData.token_endpoint_auth_methods_supported) && Objects.equals(this.token_endpoint_auth_signing_alg_values_supported, metaData.token_endpoint_auth_signing_alg_values_supported) && Objects.equals(this.ui_locales_supported, metaData.ui_locales_supported);
    }

    public int hashCode() {
        return Objects.hash(this.authorization_endpoint, this.code_challenge_methods_supported, this.grant_types_supported, this.introspection_endpoint, this.introspection_endpoint_auth_methods_supported, this.introspection_endpoint_auth_signing_alg_values_supported, this.issuer, this.jwks_uri, this.op_policy_uri, this.op_tos_uri, this.otherClaims, this.registration_endpoint, this.response_modes_supported, this.response_types_supported, this.revocation_endpoint, this.revocation_endpoint_auth_methods_supported, this.revocation_endpoint_auth_signing_alg_values_supported, this.scopes_supported, this.service_documentation, this.token_endpoint, this.token_endpoint_auth_methods_supported, this.token_endpoint_auth_signing_alg_values_supported, this.ui_locales_supported);
    }
}

