/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.hmac;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACVerifier
implements Verifier {
    private final byte[] secret;
    private final CryptoProvider cryptoProvider;

    private HMACVerifier(String secret, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(secret);
        Objects.requireNonNull(cryptoProvider);
        this.cryptoProvider = cryptoProvider;
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    private HMACVerifier(byte[] secret, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(secret);
        Objects.requireNonNull(cryptoProvider);
        this.cryptoProvider = cryptoProvider;
        this.secret = secret;
    }

    public static HMACVerifier newVerifier(String secret) {
        return HMACVerifier.newVerifier(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACVerifier newVerifier(Path path) {
        return HMACVerifier.newVerifier(path, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACVerifier newVerifier(byte[] bytes) {
        return HMACVerifier.newVerifier(bytes, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACVerifier newVerifier(String secret, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(secret);
        return new HMACVerifier(secret, cryptoProvider);
    }

    public static HMACVerifier newVerifier(Path path, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(path);
        try {
            return new HMACVerifier(Files.readAllBytes(path), cryptoProvider);
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + path.toAbsolutePath().toString() + "]", e);
        }
    }

    public static HMACVerifier newVerifier(byte[] bytes, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(bytes);
        return new HMACVerifier(bytes, cryptoProvider);
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        try {
            Mac mac = this.cryptoProvider.getMacInstance(algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, algorithm.getName()));
            byte[] actualSignature = mac.doFinal(message);
            if (!MessageDigest.isEqual(signature, actualSignature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }
}

