/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.domain.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class OpenIDConnect {
    public static String at_hash(String accessToken, Algorithm algorithm) {
        return OpenIDConnect.generate_hash(accessToken, algorithm);
    }

    public static String c_hash(String authorizationCode, Algorithm algorithm) {
        return OpenIDConnect.generate_hash(authorizationCode, algorithm);
    }

    private static String generate_hash(String string, Algorithm algorithm) {
        int leftMostBits;
        MessageDigest messageDigest;
        Objects.requireNonNull(string);
        Objects.requireNonNull(algorithm);
        switch (algorithm) {
            case ES256: 
            case HS256: 
            case RS256: {
                messageDigest = OpenIDConnect.getDigest("SHA-256");
                leftMostBits = 128;
                break;
            }
            case ES384: 
            case HS384: 
            case RS384: {
                messageDigest = OpenIDConnect.getDigest("SHA-384");
                leftMostBits = 192;
                break;
            }
            case ES512: 
            case HS512: 
            case RS512: {
                messageDigest = OpenIDConnect.getDigest("SHA-512");
                leftMostBits = 256;
                break;
            }
            default: {
                throw new IllegalArgumentException("You specified an unsupported algorithm. The algorithm [" + (Object)((Object)algorithm) + "] is not supported. You must use ES256, ES384, ES512,  HS256, HS384, HS512, RS256, RS384 or RS512.");
            }
        }
        byte[] digest = string.getBytes(StandardCharsets.UTF_8);
        digest = messageDigest.digest(digest);
        int toIndex = Math.min(digest.length, leftMostBits / 8);
        byte[] leftMostBytes = Arrays.copyOfRange(digest, 0, toIndex);
        return new String(Base64.getUrlEncoder().withoutPadding().encode(leftMostBytes));
    }

    private static MessageDigest getDigest(String digest) {
        try {
            return MessageDigest.getInstance(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

