/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.domain;

public enum Algorithm {
    ES256("SHA256withECDSA"),
    ES384("SHA384withECDSA"),
    ES512("SHA512withECDSA"),
    HS256("HmacSHA256"),
    HS384("HmacSHA384"),
    HS512("HmacSHA512"),
    RS256("SHA256withRSA"),
    RS384("SHA384withRSA"),
    RS512("SHA512withRSA"),
    none("None");

    public String algorithm;

    private Algorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Algorithm fromName(String name) {
        for (Algorithm alg : Algorithm.values()) {
            if (!alg.getName().equals(name)) continue;
            return alg;
        }
        return null;
    }

    public String getName() {
        return this.algorithm;
    }
}

