/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTSigningException;
import io.fusionauth.jwt.MissingPrivateKeyException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.ec.ECDSASignature;
import io.fusionauth.pem.domain.PEM;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Objects;

public class ECSigner
implements Signer {
    private final Algorithm algorithm;
    private ECPrivateKey privateKey;

    private ECSigner(Algorithm algorithm, String privateKey) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        PEM pem = PEM.decode(privateKey);
        if (pem.privateKey == null) {
            throw new MissingPrivateKeyException("The provided PEM encoded string did not contain a private key.");
        }
        if (!(pem.privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyTypeException("Expecting an EC private key, but found " + pem.privateKey.getAlgorithm() + " / " + pem.privateKey.getFormat() + "");
        }
        this.privateKey = (ECPrivateKey)pem.getPrivateKey();
    }

    public static ECSigner newSHA256Signer(String privateKey) {
        return new ECSigner(Algorithm.ES256, privateKey);
    }

    public static ECSigner newSHA384Signer(String privateKey) {
        return new ECSigner(Algorithm.ES384, privateKey);
    }

    public static ECSigner newSHA512Signer(String privateKey) {
        return new ECSigner(Algorithm.ES512, privateKey);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(message);
        try {
            Signature signature = Signature.getInstance(this.algorithm.getName());
            signature.initSign(this.privateKey, new SecureRandom());
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] derEncoded = signature.sign();
            return new ECDSASignature(derEncoded).derDecode(this.algorithm);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }
}

