/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.validators;

import java.util.ArrayList;
import java.util.List;
import org.boon.validation.FieldValidator;
import org.boon.validation.ValidatorMessage;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.ValidatorMessages;
import org.boon.validation.validators.BaseValidator;
import org.boon.validation.validators.RequiredValidator;
import org.boon.validation.validators.StopOnRuleValidator;

public class CompositeValidator
implements FieldValidator {
    private List<FieldValidator> validatorList = new ArrayList<FieldValidator>();
    private RequiredValidator requiredValidator = null;
    private List<String> detailArgs;
    private List<String> summaryArgs;
    private String stopOnRule = "";
    private boolean stopOnFirstRule = false;
    private boolean stopOnBlank = true;

    public void setValidatorList(List<FieldValidator> list) {
        this.validatorList = list;
        StopOnRuleValidator stopOnRuleValidator = null;
        for (FieldValidator validator : list) {
            if (validator instanceof RequiredValidator) {
                this.requiredValidator = (RequiredValidator)validator;
            }
            if (!(validator instanceof StopOnRuleValidator)) continue;
            stopOnRuleValidator = (StopOnRuleValidator)validator;
        }
        if (stopOnRuleValidator != null) {
            this.validatorList.remove(this.stopOnRule);
            String ruleName = stopOnRuleValidator.getRuleName();
            if ("first".equals(ruleName) || ruleName == null) {
                this.stopOnFirstRule = true;
            } else {
                this.stopOnRule = ruleName;
            }
        }
        if (this.requiredValidator != null) {
            this.validatorList.remove(this.requiredValidator);
        }
    }

    @Override
    public ValidatorMessageHolder validate(Object object, String fieldLabel) {
        boolean proceed;
        ValidatorMessages messages = new ValidatorMessages();
        ValidatorMessage requiredMessage = this.validateWithRequriedIfPresent(object, fieldLabel, messages);
        boolean bl = proceed = !this.stopOnBlank || object != null && object.toString().trim().length() != 0;
        if ((requiredMessage == null || !requiredMessage.hasError()) && proceed) {
            this.runValidationRules(object, fieldLabel, messages);
        }
        return messages;
    }

    private void runValidationRules(Object object, String fieldLabel, ValidatorMessages messages) {
        for (FieldValidator validator : this.validatorList) {
            this.putArgs(validator);
            ValidatorMessage message = (ValidatorMessage)validator.validate(object, fieldLabel);
            if (!message.hasError()) continue;
            messages.add(message);
            if (!this.stopOnFirstRule && !validator.getClass().getSimpleName().equalsIgnoreCase(this.stopOnRule)) continue;
            break;
        }
    }

    private ValidatorMessage validateWithRequriedIfPresent(Object object, String fieldLabel, ValidatorMessages messages) {
        ValidatorMessage requiredMessage = null;
        if (this.requiredValidator != null) {
            this.putArgs(this.requiredValidator);
            requiredMessage = (ValidatorMessage)this.requiredValidator.validate(object, fieldLabel);
            if (requiredMessage.hasError()) {
                messages.add(requiredMessage);
            }
        }
        return requiredMessage;
    }

    private void putArgs(FieldValidator validator) {
        if (validator instanceof BaseValidator) {
            BaseValidator aValidator = (BaseValidator)validator;
            aValidator.setDetailArgs(this.detailArgs);
            aValidator.setSummaryArgs(this.summaryArgs);
        }
    }

    public void setDetailArgs(List<String> detailArgKeys) {
        this.detailArgs = detailArgKeys;
    }

    public void setSummaryArgs(List<String> summaryArgKeys) {
        this.summaryArgs = summaryArgKeys;
    }

    public void setStopOnBlank(boolean stopOnBlank) {
        this.stopOnBlank = stopOnBlank;
    }
}

