/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Objects;
import org.boon.Universal;

public class Lng {
    public static String str(long value) {
        return String.format("%,d", value);
    }

    public static long[] grow(long[] array, int size) {
        Objects.requireNonNull(array);
        long[] newArray = new long[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static long[] grow(long[] array) {
        Objects.requireNonNull(array);
        long[] newArray = new long[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static long[] shrink(long[] array, int size) {
        Objects.requireNonNull(array);
        long[] newArray = new long[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static long[] compact(long[] array) {
        Objects.requireNonNull(array);
        int nullCount = 0;
        for (long ch : array) {
            if (ch != 0L) continue;
            ++nullCount;
        }
        long[] newArray = new long[array.length - nullCount];
        int j = 0;
        for (long ch : array) {
            if (ch == 0L) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static long[] arrayOfLong(int size) {
        return new long[size];
    }

    @Universal
    public static long[] array(long ... array) {
        Objects.requireNonNull(array);
        return array;
    }

    @Universal
    public static int len(long[] array) {
        return array.length;
    }

    @Universal
    public static long idx(long[] array, int index) {
        int i = Lng.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(long[] array, int index, long value) {
        int i = Lng.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static long[] slc(long[] array, int startIndex, int endIndex) {
        Objects.requireNonNull(array);
        int start = Lng.calculateIndex(array, startIndex);
        int end = Lng.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] slc(long[] array, int startIndex) {
        Objects.requireNonNull(array);
        int start = Lng.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] slcEnd(long[] array, int endIndex) {
        int end;
        Objects.requireNonNull(array);
        int newLength = end = Lng.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(long value, long[] array) {
        for (long currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static long[] copy(long[] array) {
        Objects.requireNonNull(array);
        long[] newArray = new long[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static long[] add(long[] array, long v) {
        Objects.requireNonNull(array);
        long[] newArray = new long[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static long[] add(long[] array, long[] array2) {
        Objects.requireNonNull(array);
        long[] newArray = new long[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static long[] insert(long[] array, int idx, long v) {
        Objects.requireNonNull(array);
        if (idx >= array.length) {
            return Lng.add(array, v);
        }
        int index = Lng.calculateIndex(array, idx);
        long[] newArray = new long[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static long[] insert(long[] array, int fromIndex, long[] values) {
        Objects.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Lng.add(array, values);
        }
        int index = Lng.calculateIndex(array, fromIndex);
        long[] newArray = new long[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(long[] array, int originalIndex) {
        int length = array.length;
        Objects.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }
}

